/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
extends AStore {
    public static final MemoryStore DEFAULT = new MemoryStore();
    private static final Logger log = LoggerFactory.getLogger((String)MemoryStore.class.getName());
    private final HashMap<Hash, Ref<ACell>> hashRefs = new HashMap();
    private ACell rootData;

    @Override
    public <T extends ACell> Ref<T> refForHash(Hash hash) {
        Ref<ACell> ref = this.hashRefs.get(hash);
        if (ref != null) {
            return ref;
        }
        if (hash == Hash.NULL_HASH) {
            return Ref.NULL_VALUE;
        }
        return null;
    }

    @Override
    public <T extends ACell> Ref<T> storeRef(Ref<T> r2, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.persistRef(r2, noveltyHandler, status, false);
    }

    @Override
    public <T extends ACell> Ref<T> storeTopRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) {
        return this.persistRef(ref, noveltyHandler, status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends ACell> T decode(Blob encoding) throws BadFormatException {
        ACell decoded;
        Hash hash = encoding.getContentHash();
        Ref<ACell> cached = this.hashRefs.get(hash);
        if (cached != null) {
            return (T)cached.getValue();
        }
        AStore tempStore = Stores.current();
        if (tempStore == this) {
            decoded = this.decodeImpl(encoding);
        } else {
            try {
                Stores.setCurrent(this);
                decoded = this.decodeImpl(encoding);
            }
            finally {
                Stores.setCurrent(tempStore);
            }
        }
        return (T)decoded;
    }

    public <T extends ACell> Ref<T> persistRef(Ref<T> ref, Consumer<Ref<ACell>> noveltyHandler, int requiredStatus, boolean topLevel) {
        Ref<T> existing;
        T o = (ref = ref.toDirect()).getValue();
        if (o == null) {
            return Ref.NULL_VALUE;
        }
        Object cell = o;
        boolean embedded = ((ACell)cell).isEmbedded();
        Hash hash = null;
        if (!embedded && (existing = this.refForHash(hash = ref.getHash())) != null) {
            if (existing.getStatus() >= requiredStatus) {
                return existing;
            }
            ref = existing;
        }
        cell = ((ACell)cell).updateRefs(r -> this.persistRef(r, noveltyHandler, requiredStatus, false));
        ref = ref.withValue(cell);
        Object oTemp = cell;
        if (topLevel || !embedded) {
            Hash fHash;
            Hash hash2 = fHash = hash != null ? hash : ref.getHash();
            if (log.isTraceEnabled()) {
                log.trace("Persisting ref 0x" + fHash.toHexString() + " of class " + Utils.getClassName(oTemp) + " with store " + String.valueOf(this));
            }
            this.hashRefs.put(fHash, ref);
            if (noveltyHandler != null) {
                noveltyHandler.accept(ref);
            }
        }
        return ref.withMinimumStatus(requiredStatus);
    }

    @Override
    public Hash getRootHash() throws IOException {
        return this.rootData.getHash();
    }

    @Override
    public <T extends ACell> T getRootData() throws IOException {
        return (T)this.rootData;
    }

    @Override
    public <T extends ACell> Ref<T> setRootData(T data) {
        this.rootData = data;
        return Ref.get(data);
    }

    @Override
    public void close() {
        this.hashRefs.clear();
        this.rootData = null;
    }

    @Override
    public <T extends ACell> Ref<T> checkCache(Hash h) {
        return this.refForHash(h);
    }

    @Override
    public String shortName() {
        return "Memory Store " + Objects.toIdentityString(this);
    }
}

