/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Vectors;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.exception.AExceptional;
import convex.core.lang.ops.AMultiOp;

public class Try<T extends ACell>
extends AMultiOp<T> {
    public static final Try<?> EMPTY = Try.create(new AOp[0]);

    protected Try(AVector<AOp<ACell>> ops) {
        super(ops);
    }

    public static <T extends ACell> Try<T> create(AOp<?> ... ops) {
        return new Try<T>(Vectors.create(ops));
    }

    @Override
    protected Try<T> recreate(ASequence<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return new Try<T>(newOps.toVector());
    }

    public static <T extends ACell> Try<T> create(ASequence<AOp<ACell>> ops) {
        return new Try<T>(ops.toVector());
    }

    @Override
    public Context execute(Context context) {
        int n = this.ops.size();
        if (n == 0) {
            return context.withResult(50L, null);
        }
        Context ctx = context;
        for (int i = 0; i < n; ++i) {
            AExceptional ex;
            ctx = context.consumeJuice(50L);
            if (ctx.isExceptional()) {
                return ctx;
            }
            AOp op = (AOp)this.ops.get(i);
            Context fctx = ctx.fork();
            if ((fctx = fctx.execute(op)).isExceptional()) {
                ex = fctx.getExceptional();
                if (!ex.isCatchable()) {
                    return fctx;
                }
                if (i + 1 >= n) {
                    return fctx;
                }
            } else {
                return fctx;
            }
            ctx = ctx.withResult(ex.getCode());
            ctx = ctx.withJuice(fctx.getJuiceUsed());
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(try");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (((AOp)this.ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public byte opCode() {
        return 3;
    }

    public static <T extends ACell> Try<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        AVector ops = (AVector)Format.read(b, epos);
        Try<T> result = Try.create(ops);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(ops)));
        return result;
    }
}

