/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.ErrorCodes;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.util.Errors;

public class Set<T extends ACell>
extends AOp<T> {
    private final long position;
    private final Ref<AOp<T>> op;

    private Set(long position, Ref<AOp<T>> op) {
        this.position = position;
        this.op = op;
    }

    public static final <R extends ACell> Set<R> create(long position, AOp<R> op) {
        if (position < 0L) {
            return null;
        }
        return new Set(position, op.getRef());
    }

    @Override
    public Context execute(Context ctx) {
        AVector<ACell> env = ctx.getLocalBindings();
        long ec = env.count();
        if (this.position < 0L || this.position >= ec) {
            return ctx.withError(ErrorCodes.BOUNDS, "Bad position for set!: " + this.position);
        }
        if ((ctx = ctx.execute(this.op.getValue())).isExceptional()) {
            return ctx;
        }
        Object value = ctx.getResult();
        ASequence newEnv = env.assoc(this.position, (ACell)value);
        ctx = ctx.withLocalBindings((AVector<ACell>)newEnv);
        return ctx.consumeJuice(20L);
    }

    @Override
    public byte opCode() {
        return 11;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.position);
        pos = this.op.encode(bs, pos);
        return pos;
    }

    public static <R extends ACell> Set<R> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        long position = Format.readVLCLong(b, epos);
        AOp op = (AOp)Format.read(b, epos += Format.getVLCLength(position));
        Set<R> result = Set.create(position, op);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(op)));
        return result;
    }

    @Override
    public Set<T> updateRefs(IRefFunction func) {
        Ref<AOp<T>> newOp = func.apply(this.op);
        if (this.op == newOp) {
            return this;
        }
        return new Set<T>(this.position, newOp);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.op == null) {
            throw new InvalidDataException("Null Set op ", this);
        }
        if (this.position < 0L) {
            throw new InvalidDataException("Invalid Local position " + this.position, this);
        }
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    public Ref<AOp<T>> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.op;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(set! %");
        sb.append(Long.toString(this.position));
        sb.append(' ');
        if (!this.op.getValue().print(sb, limit)) {
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }
}

