/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.exception.RecurValue;
import convex.core.lang.ops.AMultiOp;

public class Let<T extends ACell>
extends AMultiOp<T> {
    protected final AVector<ACell> symbols;
    protected final int bindingCount;
    protected final boolean isLoop;

    protected Let(AVector<ACell> syms, AVector<AOp<ACell>> ops, boolean isLoop) {
        super(ops);
        this.symbols = syms;
        this.bindingCount = syms.size();
        this.isLoop = isLoop;
    }

    public static <T extends ACell> Let<T> create(AVector<ACell> syms, AVector<AOp<ACell>> ops, boolean isLoop) {
        return new Let<T>(syms, ops, isLoop);
    }

    @Override
    public Let<T> updateRefs(IRefFunction func) {
        ACell newOps = this.ops.updateRefs(func);
        ACell newSymbols = this.symbols.updateRefs(func);
        return this.recreate((ASequence<AOp<ACell>>)newOps, (AVector<ACell>)newSymbols);
    }

    @Override
    public int getRefCount() {
        return super.getRefCount() + this.symbols.getRefCount();
    }

    @Override
    public final <R extends ACell> Ref<R> getRef(int i) {
        int n = super.getRefCount();
        if (i < n) {
            return super.getRef(i);
        }
        return this.symbols.getRef(i - n);
    }

    @Override
    protected Let<T> recreate(ASequence<AOp<ACell>> newOps) {
        return this.recreate(newOps, this.symbols);
    }

    protected Let<T> recreate(ASequence<AOp<ACell>> newOps, AVector<ACell> newSymbols) {
        if (this.ops == newOps && this.symbols == newSymbols) {
            return this;
        }
        return new Let<T>(newSymbols, newOps.toVector(), this.isLoop);
    }

    @Override
    public Context execute(Context context) {
        Context ctx = context.consumeJuice(30L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        AVector<ACell> savedEnv = ctx.getLocalBindings();
        for (int i = 0; i < this.bindingCount; ++i) {
            AOp op = (AOp)this.ops.get(i);
            if (!(ctx = ctx.executeLocalBinding((ACell)this.symbols.get(i), op)).isExceptional()) continue;
            return ctx.withLocalBindings(savedEnv);
        }
        ctx = this.executeBody(ctx);
        if (this.isLoop && ctx.isExceptional()) {
            Object o = ctx.getExceptional();
            while (o instanceof RecurValue) {
                RecurValue rv = (RecurValue)o;
                ACell[] newArgs = rv.getValues();
                if (newArgs.length != this.bindingCount) {
                    String message = "Expected " + this.bindingCount + " value(s) for recur but got: " + newArgs.length;
                    ctx = ctx.withArityError(message);
                    break;
                }
                ctx = ctx.withLocalBindings(savedEnv);
                if ((ctx = ctx.updateBindings(this.symbols, newArgs)).isExceptional()) break;
                ctx = this.executeBody(ctx);
                o = ctx.getValue();
            }
        }
        return ctx.withLocalBindings(savedEnv);
    }

    public Context executeBody(Context ctx) {
        int end = this.ops.size();
        if (this.bindingCount == end) {
            return ctx.withResult(null);
        }
        for (int i = this.bindingCount; i < end; ++i) {
            if (!(ctx = ctx.execute((AOp)this.ops.get(i))).isExceptional()) continue;
            return ctx;
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        int i;
        bb.append(this.isLoop ? "(loop [" : "(let [");
        int len = this.ops.size();
        for (i = 0; i < this.bindingCount; ++i) {
            if (i > 0) {
                bb.append(' ');
            }
            if (!RT.print(bb, (ACell)this.symbols.get(i), limit)) {
                return false;
            }
            bb.append(' ');
            if (!((AOp)this.ops.get(i)).print(bb, limit)) {
                return false;
            }
            bb.append(' ');
        }
        bb.append("] ");
        for (i = this.bindingCount; i < len; ++i) {
            bb.append(' ');
            if (((AOp)this.ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public byte opCode() {
        return this.isLoop ? (byte)5 : 4;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.symbols);
        return super.encodeRaw(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return super.estimatedEncodingSize() + this.symbols.estimatedEncodingSize();
    }

    public static <T extends ACell> Let<T> read(Blob b, int pos, boolean isLoop) throws BadFormatException {
        int epos = pos + 1;
        AVector syms = (AVector)Format.read(b, epos);
        AVector ops = (AVector)Format.read(b, epos += Format.getEncodingLength(syms));
        Let<T> result = Let.create(syms, ops.toVector(), isLoop);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(ops)));
        return result;
    }
}

