/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;

public abstract class AMultiOp<T extends ACell>
extends AOp<T> {
    protected final AVector<AOp<ACell>> ops;

    protected AMultiOp(AVector<AOp<ACell>> ops) {
        this.ops = ops;
    }

    protected abstract AMultiOp<T> recreate(ASequence<AOp<ACell>> var1);

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.ops);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + this.ops.estimatedEncodingSize();
    }

    @Override
    public AMultiOp<T> updateRefs(IRefFunction func) {
        ACell newOps = this.ops.updateRefs(func);
        return this.recreate((ASequence<AOp<ACell>>)newOps);
    }

    @Override
    public int getRefCount() {
        return this.ops.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.ops.getRef(i);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.ops.validateCell();
    }
}

