/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.Keyword;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.impl.ADataFn;

public class KeywordFn<T extends ACell>
extends ADataFn<T> {
    private Keyword key;

    public KeywordFn(Keyword k) {
        this.key = k;
    }

    public static <T extends ACell> KeywordFn<T> wrap(Keyword k) {
        return new KeywordFn<T>(k);
    }

    @Override
    public Context invoke(Context context, ACell[] args) {
        ACell result;
        int n = args.length;
        if (n == 1) {
            ADataStructure<?> gettable = RT.ensureAssociative(args[0]);
            if (gettable == null) {
                return context.withCastError(0, (AType)Types.DATA_STRUCTURE);
            }
            result = gettable.get(this.key);
        } else if (n == 2) {
            ACell ds = args[0];
            ACell notFound = args[1];
            if (ds == null) {
                result = notFound;
            } else {
                ADataStructure<?> gettable = RT.ensureAssociative(ds);
                if (gettable == null) {
                    return context.withCastError(0, (AType)Types.DATA_STRUCTURE);
                }
                result = RT.get(gettable, this.key, notFound);
            }
        } else {
            return context.withArityError("Expected arity 1 or 2 for keyword lookup but got: " + n);
        }
        return context.withResult(result);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return this.key.print(sb, limit);
    }
}

