/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ACountable;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.IAssociative;
import convex.core.data.Keyword;
import convex.core.data.Lists;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AFn;
import convex.core.lang.impl.KeywordFn;
import convex.core.lang.impl.MapFn;
import convex.core.lang.impl.SeqFn;
import convex.core.lang.impl.SetFn;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class RT {
    public static <T extends ACell> Boolean allEqual(T[] values) {
        for (int i = 0; i < values.length - 1; ++i) {
            if (Cells.equals(values[i], values[i + 1])) continue;
            return false;
        }
        return true;
    }

    private static CVMBool checkShortCompare(ACell[] values) {
        int len = values.length;
        if (len == 0) {
            return CVMBool.TRUE;
        }
        if (len == 1) {
            if (null == RT.ensureNumber(values[0])) {
                return null;
            }
            return CVMBool.TRUE;
        }
        return CVMBool.FALSE;
    }

    public static CVMBool eq(ACell[] values) {
        CVMBool check = RT.checkShortCompare(values);
        if (check == null) {
            return null;
        }
        if (check == CVMBool.TRUE) {
            return check;
        }
        for (int i = 0; i < values.length - 1; ++i) {
            Long comp = RT.compare(values[i], values[i + 1], Long.MAX_VALUE);
            if (comp == null) {
                return null;
            }
            if (comp == 0L) continue;
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public static CVMBool ge(ACell[] values) {
        CVMBool check = RT.checkShortCompare(values);
        if (check == null) {
            return null;
        }
        if (check == CVMBool.TRUE) {
            return check;
        }
        for (int i = 0; i < values.length - 1; ++i) {
            Long comp = RT.compare(values[i], values[i + 1], Long.MIN_VALUE);
            if (comp == null) {
                return null;
            }
            if (comp >= 0L) continue;
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public static CVMBool gt(ACell[] values) {
        CVMBool check = RT.checkShortCompare(values);
        if (check == null) {
            return null;
        }
        if (check == CVMBool.TRUE) {
            return check;
        }
        for (int i = 0; i < values.length - 1; ++i) {
            Long comp = RT.compare(values[i], values[i + 1], Long.MIN_VALUE);
            if (comp == null) {
                return null;
            }
            if (comp > 0L) continue;
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public static CVMBool le(ACell[] values) {
        CVMBool check = RT.checkShortCompare(values);
        if (check == null) {
            return null;
        }
        if (check == CVMBool.TRUE) {
            return check;
        }
        for (int i = 0; i < values.length - 1; ++i) {
            Long comp = RT.compare(values[i], values[i + 1], Long.MAX_VALUE);
            if (comp == null) {
                return null;
            }
            if (comp <= 0L) continue;
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public static CVMBool lt(ACell[] values) {
        CVMBool check = RT.checkShortCompare(values);
        if (check == null) {
            return null;
        }
        if (check == CVMBool.TRUE) {
            return check;
        }
        for (int i = 0; i < values.length - 1; ++i) {
            Long comp = RT.compare(values[i], values[i + 1], Long.MAX_VALUE);
            if (comp == null) {
                return null;
            }
            if (comp < 0L) continue;
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public static ACell min(ACell[] values) {
        ACell acc = values[0];
        if (!RT.isNumber(acc)) {
            return null;
        }
        for (int i = 1; i < values.length; ++i) {
            ACell next = values[i];
            acc = RT.min(acc, next);
        }
        return acc;
    }

    public static ACell min(ACell a, ACell b) {
        if (a == null) {
            return null;
        }
        Long comp = RT.compare(a, b, Long.MIN_VALUE);
        if (comp == null) {
            return null;
        }
        if (Long.MIN_VALUE == comp) {
            return CVMDouble.NaN;
        }
        if (comp > 0L) {
            return b;
        }
        return a;
    }

    public static ACell max(ACell[] values) {
        ACell acc = values[0];
        if (!RT.isNumber(acc)) {
            return null;
        }
        for (int i = 1; i < values.length; ++i) {
            ACell next = values[i];
            acc = RT.max(acc, next);
        }
        return acc;
    }

    public static ACell max(ACell a, ACell b) {
        if (a == null) {
            return null;
        }
        Long comp = RT.compare(a, b, Long.MIN_VALUE);
        if (comp == null) {
            return null;
        }
        if (Long.MIN_VALUE == comp) {
            return CVMDouble.NaN;
        }
        if (comp < 0L) {
            return b;
        }
        return a;
    }

    public static Class<?> commonNumericType(ACell[] args) {
        Class highestFound = Long.class;
        for (int i = 0; i < args.length; ++i) {
            ACell a = args[i];
            Class<?> klass = RT.numericType(a);
            if (klass == null) {
                return null;
            }
            if (klass != Double.class) continue;
            highestFound = Double.class;
        }
        return highestFound;
    }

    public static int findNonNumeric(ACell[] args) {
        for (int i = 0; i < args.length; ++i) {
            ACell a = args[i];
            Class<?> klass = RT.numericType(a);
            if (klass != null) continue;
            return i;
        }
        return -1;
    }

    public static Class<?> numericType(ACell a) {
        if (a instanceof ANumeric) {
            return ((ANumeric)a).numericType();
        }
        return null;
    }

    public static ANumeric plus(ACell[] args) {
        int n = args.length;
        if (n == 0) {
            return CVMLong.ZERO;
        }
        ANumeric result = RT.ensureNumber(args[0]);
        for (int i = 1; i < args.length; ++i) {
            result = result.add(RT.ensureNumber(args[i]));
        }
        return result;
    }

    public static ANumeric minus(ACell[] args) {
        int n = args.length;
        if (n == 0) {
            return CVMLong.ZERO;
        }
        ANumeric result = RT.ensureNumber(args[0]);
        if (n == 1) {
            return result.negate();
        }
        for (int i = 1; i < n; ++i) {
            ANumeric b = RT.ensureNumber(args[i]);
            result = result.sub(b);
        }
        return result;
    }

    public static ANumeric multiply(ACell ... args) {
        int n = args.length;
        if (n == 0) {
            return CVMLong.ONE;
        }
        ANumeric result = RT.ensureNumber(args[0]);
        for (int i = 1; i < args.length; ++i) {
            result = result.multiply(RT.ensureNumber(args[i]));
        }
        return result;
    }

    public static CVMDouble divide(ACell[] args) {
        int n = args.length;
        CVMDouble arg0 = RT.ensureDouble(args[0]);
        if (arg0 == null) {
            return null;
        }
        double result = arg0.doubleValue();
        if (n == 1) {
            return CVMDouble.create(1.0 / result);
        }
        for (int i = 1; i < args.length; ++i) {
            CVMDouble v = RT.ensureDouble(args[i]);
            if (v == null) {
                return null;
            }
            result /= v.doubleValue();
        }
        return CVMDouble.create(result);
    }

    public static CVMDouble pow(ACell[] args) {
        CVMDouble a = RT.ensureDouble(args[0]);
        CVMDouble b = RT.ensureDouble(args[1]);
        if (a == null || b == null) {
            return null;
        }
        return CVMDouble.create(StrictMath.pow(a.doubleValue(), b.doubleValue()));
    }

    public static CVMDouble exp(ACell arg) {
        CVMDouble a = RT.ensureDouble(arg);
        if (a == null) {
            return null;
        }
        return CVMDouble.create(StrictMath.exp(a.doubleValue()));
    }

    public static CVMDouble floor(ACell a) {
        CVMDouble d = RT.ensureDouble(a);
        if (d == null) {
            return null;
        }
        return CVMDouble.create(StrictMath.floor(d.doubleValue()));
    }

    public static CVMDouble ceil(ACell a) {
        CVMDouble d = RT.ensureDouble(a);
        if (d == null) {
            return null;
        }
        return CVMDouble.create(StrictMath.ceil(d.doubleValue()));
    }

    public static CVMDouble sqrt(ACell a) {
        CVMDouble d = RT.ensureDouble(a);
        if (d == null) {
            return null;
        }
        return CVMDouble.create(StrictMath.sqrt(d.doubleValue()));
    }

    public static long splitmix64Update(long seed) {
        return seed + -7046029254386353131L;
    }

    public static long splitmix64Calc(long seed) {
        long x = seed;
        x = (x ^ x >>> 30) * -4658895280553007687L;
        x = (x ^ x >>> 27) * -7723592293110705685L;
        return x ^ x >>> 31;
    }

    public static double doubleFromUnsignedLong(long a) {
        if (a >= 0L) {
            return a;
        }
        return (double)(a >>> 1 | a & 1L) * 2.0;
    }

    public static APrimitive abs(ACell a) {
        ANumeric x = RT.ensureNumber(a);
        if (x == null) {
            return null;
        }
        return x.abs();
    }

    public static ACell signum(ACell a) {
        ANumeric x = RT.ensureNumber(a);
        if (x == null) {
            return null;
        }
        return x.signum();
    }

    public static Long compare(ACell a, ACell b, Long nanValue) {
        Class<?> ca = RT.numericType(a);
        if (ca == null) {
            return null;
        }
        Class<?> cb = RT.numericType(b);
        if (cb == null) {
            return null;
        }
        if (ca == Long.class && cb == Long.class) {
            return ((AInteger)a).compareTo((AInteger)b);
        }
        double da = RT.doubleValue(a);
        if (Double.isNaN(da)) {
            return nanValue;
        }
        double db = RT.doubleValue(b);
        if (Double.isNaN(db)) {
            return nanValue;
        }
        if (da == db) {
            return 0L;
        }
        if (da < db) {
            return -1L;
        }
        if (da > db) {
            return 1L;
        }
        return nanValue;
    }

    public static ANumeric ensureNumber(ACell a) {
        if (a instanceof ANumeric) {
            return (ANumeric)a;
        }
        return null;
    }

    public static boolean isNumber(ACell val) {
        return val instanceof ANumeric;
    }

    public static CVMDouble castDouble(ACell a) {
        if (a instanceof CVMDouble) {
            return (CVMDouble)a;
        }
        AInteger l = RT.ensureInteger(a);
        if (l == null) {
            return null;
        }
        return l.toDouble();
    }

    public static CVMDouble ensureDouble(ACell a) {
        if (a instanceof ANumeric) {
            ANumeric ap = (ANumeric)a;
            return ap.toDouble();
        }
        return null;
    }

    public static CVMLong castLong(ACell a) {
        if (a instanceof CVMLong) {
            return (CVMLong)a;
        }
        ANumeric n = RT.ensureNumber(a);
        if (n != null) {
            return RT.ensureLong(n.toInteger());
        }
        if (a instanceof APrimitive) {
            return CVMLong.create(((APrimitive)a).longValue());
        }
        if (a instanceof Address) {
            long lv = ((Address)a).longValue();
            return CVMLong.create(lv);
        }
        if (a instanceof ABlob) {
            long lv = ((ABlob)a).longValue();
            return CVMLong.create(lv);
        }
        return null;
    }

    public static CVMLong ensureLong(ACell a) {
        if (a instanceof CVMLong) {
            return (CVMLong)a;
        }
        if (a instanceof ANumeric) {
            ANumeric ap = (ANumeric)a;
            return ap.ensureLong();
        }
        return null;
    }

    public static AInteger castInteger(ACell a) {
        if (a instanceof AInteger) {
            return (AInteger)a;
        }
        ANumeric n = RT.ensureNumber(a);
        if (n != null) {
            return n.toInteger();
        }
        if (a instanceof APrimitive) {
            return CVMLong.create(((APrimitive)a).longValue());
        }
        if (a instanceof ABlob) {
            long lv = ((ABlob)a).longValue();
            return CVMLong.create(lv);
        }
        return null;
    }

    public static AInteger ensureInteger(ACell a) {
        if (a instanceof AInteger) {
            AInteger ap = (AInteger)a;
            return ap;
        }
        return null;
    }

    public static CVMLong castByte(ACell a) {
        if (a instanceof ABlob) {
            ABlob b = (ABlob)a;
            long n = b.count();
            if (n == 0L) {
                return CVMLong.ZERO;
            }
            return b.get(n - 1L);
        }
        AInteger l = RT.ensureInteger(a);
        if (l == null) {
            return null;
        }
        return CVMLong.forByte((byte)l.longValue());
    }

    private static double doubleValue(ACell a) {
        if (a instanceof APrimitive) {
            return ((APrimitive)a).doubleValue();
        }
        throw new IllegalArgumentException("Can't convert to double: " + Utils.getClassName(a));
    }

    public static <T extends ACell> AVector<T> vec(Object o) {
        if (o == null) {
            return Vectors.empty();
        }
        if (o instanceof ACell) {
            return RT.castVector((ACell)o);
        }
        if (o instanceof ACell[]) {
            ACell[] arr = (ACell[])o;
            return Vectors.wrap(arr);
        }
        if (o instanceof List) {
            return Vectors.create((List)o);
        }
        return null;
    }

    public static <T extends ACell> AVector<T> castVector(ACell o) {
        if (o == null) {
            return Vectors.empty();
        }
        if (o instanceof ACollection) {
            return RT.vec((ACollection)o);
        }
        if (o instanceof ACountable) {
            ACountable ds = (ACountable)o;
            long n = ds.count();
            ASequence r = Vectors.empty();
            int i = 0;
            while ((long)i < n) {
                r = r.conj((ACell)ds.get(i));
                ++i;
            }
            return r;
        }
        return null;
    }

    public static <T extends ACell> ASet<T> castSet(ACell o) {
        if (o == null) {
            return Sets.empty();
        }
        if (o instanceof ASet) {
            return (ASet)o;
        }
        if (o instanceof ACountable) {
            return Sets.create((ACountable)o);
        }
        return null;
    }

    public static <T extends ACell> AVector<T> vec(ACollection<T> coll) {
        if (coll == null) {
            return Vectors.empty();
        }
        return coll.toVector();
    }

    public static <T extends ACell> ASequence<T> sequence(ACell o) {
        if (o == null) {
            return Vectors.empty();
        }
        if (o instanceof ASequence) {
            return (ASequence)o;
        }
        if (o instanceof ACollection) {
            return ((ACollection)o).toVector();
        }
        if (o instanceof AMap) {
            return RT.sequence(((AMap)o).entryVector());
        }
        return null;
    }

    public static <T extends ACell> ASequence<T> ensureSequence(ACell o) {
        if (o == null) {
            return Vectors.empty();
        }
        if (o instanceof ASequence) {
            return (ASequence)o;
        }
        return null;
    }

    public static <T extends ACell> AVector<T> ensureVector(ACell o) {
        if (o instanceof AVector) {
            return (AVector)o;
        }
        return null;
    }

    public static <T extends ACell> T nth(ACell o, long i) {
        if (o instanceof ACountable) {
            return (T)((ACountable)o).get(i);
        }
        throw new ClassCastException("Don't know how to get nth item of type " + String.valueOf(RT.getType(o)));
    }

    public static <T extends ACell> T nth(Object o, long i) {
        if (o instanceof ACountable) {
            return (T)((ACountable)o).get(i);
        }
        try {
            if (o.getClass().isArray()) {
                return (T)((ACell)Array.get(o, Utils.checkedInt(i)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        throw new ClassCastException("Can't get nth element from object of class: " + Utils.getClassName(o));
    }

    public static Long count(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof ACell) {
            return RT.count((ACell)o);
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return null;
    }

    public static Long argumentCount(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof ADataStructure) {
            return ((ADataStructure)o).count();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return null;
    }

    public static Long count(ACell a) {
        if (a == null) {
            return 0L;
        }
        if (a instanceof ACountable) {
            return ((ACountable)a).count();
        }
        return null;
    }

    public static AString str(ACell[] args) {
        int n = args.length;
        AString[] strs = new AString[n];
        for (int i = 0; i < n; ++i) {
            AString s;
            strs[i] = s = RT.str(args[i]);
        }
        return Strings.appendAll(strs);
    }

    public static boolean print(BlobBuilder bb, ACell a, long limit) {
        if (a == null) {
            bb.append(Strings.NIL);
            return bb.check(limit);
        }
        return a.print(bb, limit);
    }

    public static AString print(ACell a, long limit) {
        if (a == null) {
            return limit >= 3L ? Strings.NIL : null;
        }
        BlobBuilder bb = new BlobBuilder();
        if (!RT.print(bb, a, limit)) {
            return null;
        }
        return bb.getCVMString();
    }

    public static AString print(ACell a) {
        return RT.print(a, 65536L);
    }

    public static AString print(Object o) {
        Object cell = RT.cvm(o);
        return RT.print(cell);
    }

    public static AString str(ACell a) {
        if (a == null) {
            return Strings.NIL;
        }
        if (a instanceof AString) {
            return (AString)a;
        }
        if (a.getType() == Types.BLOB) {
            return Strings.create(((ABlob)a).toHexString());
        }
        AString s = Strings.create(a.toString());
        return s;
    }

    public static String toString(ACell a) {
        return RT.toString(a, 65536L);
    }

    public static String toString(ACell a, long limit) {
        AString s = RT.print(a, limit);
        if (s == null) {
            return "<<Print limit exceeded>>";
        }
        return s.toString();
    }

    public static AString name(ACell a) {
        if (a instanceof AString) {
            return (AString)a;
        }
        if (a instanceof ASymbolic) {
            return ((ASymbolic)a).getName();
        }
        return null;
    }

    public static <T extends ACell> AList<T> cons(T x, ASequence<?> xs) {
        if (xs == null) {
            return Lists.of(x);
        }
        return xs.cons(x);
    }

    public static <T extends ACell> AList<T> cons(T x, T y, ACell xs) {
        ASequence<T> nxs = RT.sequence(xs);
        if (xs == null) {
            return Lists.of(x, y);
        }
        return nxs.cons(y).cons(x);
    }

    public static <T extends ACell> AList<T> cons(T x, T y, T z, ACell xs) {
        ASequence<T> nxs = RT.sequence(xs);
        return nxs.cons(z).cons(y).cons(x);
    }

    static <E extends ACell> ADataStructure<E> castDataStructure(ACell a) {
        if (a == null) {
            return Vectors.empty();
        }
        if (a instanceof ADataStructure) {
            return (ADataStructure)a;
        }
        return null;
    }

    public static <T extends ACell> AFn<T> castFunction(ACell a) {
        if (a instanceof AFn) {
            return (AFn)a;
        }
        if (a instanceof AMap) {
            return MapFn.wrap((AMap)a);
        }
        if (a instanceof ASequence) {
            return SeqFn.wrap((ASequence)a);
        }
        if (a instanceof ASet) {
            return SetFn.wrap((ASet)a);
        }
        if (a instanceof Keyword) {
            return KeywordFn.wrap((Keyword)a);
        }
        return null;
    }

    public static <T extends ACell> AFn<T> ensureFunction(ACell a) {
        if (a instanceof AFn) {
            return (AFn)a;
        }
        return null;
    }

    public static Address castAddress(ACell a) {
        if (a instanceof Address) {
            return (Address)a;
        }
        if (a instanceof ABlob) {
            return Address.create((ABlob)a);
        }
        CVMLong value = RT.ensureLong(a);
        if (value == null) {
            return null;
        }
        return Address.create(value.longValue());
    }

    public static Address toAddress(Object a) {
        if (a instanceof ACell) {
            return RT.castAddress((ACell)a);
        }
        if (a instanceof String) {
            return Address.parse((String)a);
        }
        return null;
    }

    public static Address ensureAddress(ACell a) {
        if (a instanceof Address) {
            return (Address)a;
        }
        return null;
    }

    public static AccountKey ensureAccountKey(ACell a) {
        if (a == null) {
            return null;
        }
        if (a instanceof AccountKey) {
            return (AccountKey)a;
        }
        if (a instanceof ABlob) {
            ABlob b = (ABlob)a;
            return AccountKey.create(b);
        }
        return null;
    }

    public static AccountKey castAccountKey(ACell a) {
        if (a == null) {
            return null;
        }
        if (a instanceof AString) {
            return AccountKey.fromHexOrNull((AString)a);
        }
        return RT.ensureAccountKey(a);
    }

    public static ABlob castBlob(ACell a) {
        if (a instanceof AString) {
            return Blobs.fromHex((AString)a);
        }
        if (a instanceof ABlobLike) {
            return ((ABlobLike)a).toBlob();
        }
        if (a instanceof AInteger) {
            return ((AInteger)a).toBlob();
        }
        if (a instanceof CVMChar) {
            return ((CVMChar)a).toUTFBlob();
        }
        if (a instanceof CVMBool) {
            return ((CVMBool)a).toBlob();
        }
        return null;
    }

    public static <K extends ACell, V extends ACell> AMap<K, V> ensureMap(ACell a) {
        if (a == null) {
            return Maps.empty();
        }
        if (a instanceof AMap) {
            return (AMap)a;
        }
        return null;
    }

    public static ACell get(ADataStructure<?> coll, ACell key) {
        if (coll == null) {
            return null;
        }
        return coll.get(key);
    }

    public static ACell get(ADataStructure<?> coll, ACell key, ACell notFound) {
        if (coll == null) {
            return notFound;
        }
        return coll.get(key, notFound);
    }

    public static boolean bool(ACell a) {
        return a != null && a != CVMBool.FALSE;
    }

    public static boolean bool(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        return a != CVMBool.FALSE;
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> ensureMapEntry(ACell x) {
        MapEntry me;
        if (x instanceof MapEntry) {
            me = (MapEntry)x;
        } else if (x instanceof AVector) {
            AVector v = (AVector)x;
            if (v.count() != 2L) {
                return null;
            }
            me = MapEntry.createRef(v.getRef(0), v.getRef(1));
        } else {
            return null;
        }
        return me;
    }

    public static Hash ensureHash(ACell o) {
        if (o instanceof Hash) {
            return (Hash)o;
        }
        if (o instanceof ABlob) {
            ABlob blob = (ABlob)o;
            return Hash.wrap(blob);
        }
        return null;
    }

    public static Keyword castKeyword(ACell a) {
        if (a instanceof Keyword) {
            return (Keyword)a;
        }
        AString name = RT.name(a);
        if (name == null) {
            return null;
        }
        Keyword k = Keyword.create(name);
        return k;
    }

    public static Symbol ensureSymbol(ACell a) {
        if (a instanceof Symbol) {
            return (Symbol)a;
        }
        return null;
    }

    public static <E extends ACell> ADataStructure<E> ensureDataStructure(ACell a) {
        if (a instanceof ADataStructure) {
            return (ADataStructure)a;
        }
        return null;
    }

    public static <E extends ACell> ACountable<E> ensureCountable(ACell a) {
        if (a instanceof ACountable) {
            return (ACountable)a;
        }
        return null;
    }

    public static boolean isCountable(ACell val) {
        return val == null || val instanceof ACountable;
    }

    public static boolean isBoolean(ACell value) {
        return value == CVMBool.TRUE || value == CVMBool.FALSE;
    }

    public static ASequence<?> concat(ASequence<?> a, ASequence<?> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.concat(b);
    }

    public static void validate(Object o) throws InvalidDataException {
        if (o == null) {
            return;
        }
        if (o instanceof ACell) {
            ((ACell)o).validate();
        } else if (o instanceof Ref) {
            ((Ref)o).validate();
        } else {
            throw new InvalidDataException("Data of class" + String.valueOf(Utils.getClass(o)) + " neither IValidated, canonical nor embedded: ", o);
        }
    }

    public static void validateCell(ACell o) throws InvalidDataException {
        if (o == null) {
            return;
        }
        if (o instanceof ACell) {
            o.validateCell();
        }
    }

    public static <R extends ACell> ADataStructure<R> assoc(ADataStructure<R> coll, ACell key, ACell value) {
        if (coll == null) {
            return Maps.create(key, value);
        }
        return coll.assoc(key, value);
    }

    public static <R extends ACell> AVector<R> keys(ACell a) {
        if (!(a instanceof AMap)) {
            return null;
        }
        AMap m = (AMap)a;
        return m.getKeys();
    }

    public static <R extends ACell> AVector<R> values(ACell a) {
        if (!(a instanceof AMap)) {
            return null;
        }
        AMap m = (AMap)a;
        return m.reduceValues(new BiFunction<AVector<R>, R, AVector<R>>(){

            @Override
            public AVector<R> apply(AVector<R> t, R u) {
                return t.conj((ACell)u);
            }
        }, Vectors.empty());
    }

    public static ADataStructure<?> ensureAssociative(ACell o) {
        if (o == null) {
            return Maps.empty();
        }
        if (o instanceof IAssociative) {
            return (ADataStructure)o;
        }
        return null;
    }

    public static <T extends ACell> ASet<T> ensureSet(ACell a) {
        if (a == null) {
            return Sets.empty();
        }
        if (!(a instanceof ASet)) {
            return null;
        }
        return (ASet)a;
    }

    public static <K extends ACell, V extends ACell> AHashMap<K, V> ensureHashMap(ACell a) {
        if (a == null) {
            return Maps.empty();
        }
        if (a instanceof AHashMap) {
            return (AHashMap)a;
        }
        return null;
    }

    public static ABlob ensureBlob(ACell a) {
        if (a instanceof ABlob) {
            ABlob b = (ABlob)a;
            if (b.getType() != Types.BLOB) {
                return null;
            }
            return b;
        }
        return null;
    }

    public static <V extends ACell> ABlobLike<V> ensureBlobLike(ACell a) {
        if (a instanceof ABlobLike) {
            ABlobLike b = (ABlobLike)a;
            return b;
        }
        return null;
    }

    public static AString ensureString(ACell a) {
        if (a instanceof AString) {
            return (AString)a;
        }
        return null;
    }

    public static boolean isValidAmount(long amount) {
        return amount >= 0L && amount <= 1000000000000000000L;
    }

    public static <T extends ACell> T cvm(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ACell) {
            return (T)((ACell)o);
        }
        if (o instanceof String) {
            return (T)Strings.create((String)o);
        }
        if (o instanceof Double) {
            return (T)CVMDouble.create((Double)o);
        }
        if (o instanceof Number) {
            return (T)CVMLong.create(((Number)o).longValue());
        }
        if (o instanceof Character) {
            return (T)CVMChar.create(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return (T)CVMBool.create((Boolean)o);
        }
        if (o instanceof List) {
            List l = (List)o;
            ASequence v = Vectors.empty();
            for (Object val : l) {
                v = v.conj((ACell)RT.cvm(val));
            }
            return (T)v;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            Object cm = Maps.empty();
            for (Map.Entry me : m.entrySet()) {
                Object k = me.getKey();
                Object v = me.getValue();
                T cvmk = RT.cvm(k);
                T cvmv = RT.cvm(v);
                cm = ((AMap)cm).assoc((ACell)cvmk, (ACell)cvmv);
            }
            return (T)cm;
        }
        Class<?> klass = o.getClass();
        if (klass.isArray()) {
            ASequence r = Vectors.empty();
            int n = Array.getLength(o);
            for (int i = 0; i < n; ++i) {
                Object elem = Array.get(o, i);
                T v = RT.cvm(elem);
                r = r.conj((ACell)v);
            }
            return (T)r;
        }
        throw new IllegalArgumentException("Can't convert to CVM type with class: " + Utils.getClassName(o));
    }

    public static <T> T jvm(ACell o) {
        if (o instanceof AString) {
            return (T)o.toString();
        }
        if (o instanceof CVMLong) {
            return (T)Long.valueOf(((CVMLong)o).longValue());
        }
        if (o instanceof CVMDouble) {
            return (T)Double.valueOf(((CVMDouble)o).doubleValue());
        }
        if (o instanceof CVMBool) {
            return (T)Boolean.valueOf(((CVMBool)o).booleanValue());
        }
        if (o instanceof CVMChar) {
            return (T)Character.valueOf(((CVMChar)o).charValue());
        }
        return (T)o;
    }

    public static <T> T json(ACell o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CVMLong) {
            return (T)Long.valueOf(((CVMLong)o).longValue());
        }
        if (o instanceof CVMDouble) {
            return (T)Double.valueOf(((CVMDouble)o).doubleValue());
        }
        if (o instanceof CVMBool) {
            return (T)Boolean.valueOf(((CVMBool)o).booleanValue());
        }
        if (o instanceof CVMChar) {
            return (T)((CVMChar)o).toString();
        }
        if (o instanceof Address) {
            return (T)Long.valueOf(((Address)o).longValue());
        }
        if (o instanceof AMap) {
            AMap m = (AMap)o;
            return (T)RT.jsonMap(m);
        }
        if (o instanceof ASequence) {
            ASequence seq = (ASequence)o;
            long n = seq.count();
            ArrayList<T> list = new ArrayList<T>();
            for (long i = 0L; i < n; ++i) {
                Object cvmv = seq.get(i);
                T v = RT.json(cvmv);
                list.add(v);
            }
            return (T)list;
        }
        return (T)o.toString();
    }

    public static HashMap<String, Object> jsonMap(AMap<?, ?> m) {
        int n = m.size();
        HashMap<String, Object> hm = new HashMap<String, Object>(n);
        for (long i = 0L; i < (long)n; ++i) {
            MapEntry<?, ?> me = m.entryAt(i);
            Object k = me.getKey();
            String sk = RT.jsonKey((ACell)k);
            Object v = RT.json((ACell)me.getValue());
            hm.put(sk, v);
        }
        return hm;
    }

    public static String jsonKey(ACell k) {
        if (k instanceof AString) {
            return k.toString();
        }
        if (k instanceof Keyword) {
            return ((Keyword)k).getName().toString();
        }
        return RT.toString(k);
    }

    public static AType getType(ACell a) {
        if (a == null) {
            return Types.NIL;
        }
        return a.getType();
    }

    public static boolean isNaN(ACell val) {
        return CVMDouble.NaN.equals(val);
    }

    public static CVMChar ensureChar(ACell a) {
        if (a instanceof CVMChar) {
            return (CVMChar)a;
        }
        if (a instanceof CVMLong) {
            return CVMChar.create(((CVMLong)a).longValue());
        }
        if (a instanceof AString) {
            AString s = (AString)a;
            long n = s.count();
            if (n == 0L || n > 4L) {
                return null;
            }
            long cv = s.charAt(0L);
            if (cv < 0L) {
                return null;
            }
            if (n != (long)CVMChar.utfLength(cv)) {
                return null;
            }
            return CVMChar.create(cv);
        }
        return null;
    }

    public static Address callableAddress(ACell a) {
        Address addr = RT.ensureAddress(a);
        if (addr == null && a instanceof AVector) {
            AVector v = (AVector)a;
            if (v.count() != 2L) {
                return null;
            }
            addr = RT.ensureAddress((ACell)v.get(0));
        }
        return addr;
    }

    public static ATransaction ensureTransaction(ACell maybeTx) {
        if (maybeTx instanceof ATransaction) {
            return (ATransaction)maybeTx;
        }
        return null;
    }
}

