/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.ADataStructure;
import convex.core.data.Cells;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMDouble;
import convex.core.lang.Context;
import convex.core.transactions.ATransaction;

public class Juice {
    public static final long TRANSACTION = 500L;
    public static final long SUB_TRANSACTION = 100L;
    public static final long CONSTANT = 5L;
    public static final long DEF = 100L;
    public static final long LOOKUP = 15L;
    public static final long CORE = 5L;
    public static final long LOOKUP_DYNAMIC = 40L;
    public static final long LOOKUP_SYM = 45L;
    public static final long DO = 5L;
    public static final long TRY = 50L;
    public static final long LET = 30L;
    public static final long COND_OP = 20L;
    public static final long LAMBDA = 100L;
    public static final long CALL_OP = 100L;
    protected static final long BUILD_DATA = 50L;
    protected static final long BUILD_PER_ELEMENT = 50L;
    protected static final long MAP = 100L;
    protected static final long REDUCE = 100L;
    public static final long EQUALS = 20L;
    public static final long NUMERIC_COMPARE = 10L;
    public static final long APPLY = 50L;
    public static final long HASH = 1000L;
    public static final long HASH_PER_BYTE = 20L;
    public static final long CHEAP_OP = 10L;
    public static final long SIMPLE_FN = 20L;
    protected static final long STR = 20L;
    protected static final long ARITHMETIC = 20L;
    protected static final long ADDRESS = 20L;
    protected static final long BALANCE = 50L;
    protected static final long BLOB = 20L;
    protected static final long BUILD_PER_BYTE = 1L;
    protected static final long GET = 30L;
    protected static final long KEYWORD = 20L;
    protected static final long SYMBOL = 20L;
    public static final long TRANSFER = 200L;
    public static final long TRANSACTION_PER_BYTE = 20L;
    public static final long RECUR = 30L;
    public static final long DEPLOY_CONTRACT = 1000L;
    protected static final long EVAL = 500L;
    public static final long COMPILE_CONSTANT = 30L;
    public static final long COMPILE_LOOKUP = 50L;
    public static final long COMPILE_LOOKUP_DEFINED = 65L;
    public static final long COMPILE_LOOKUP_CORE = 80L;
    public static final long COMPILE_LOOKUP_UNDEFINED = 95L;
    public static final long COMPILE_NODE = 200L;
    public static final long EXPAND_CONSTANT = 40L;
    public static final long EXPAND_SEQUENCE = 100L;
    public static final long SCHEDULE = 800L;
    public static final long SCHEDULE_MILLIS_PER_JUICE_UNIT = 360000L;
    public static final long RETURN = 20L;
    public static final long ACCEPT = 200L;
    public static final long SYNTAX = 20L;
    public static final long META = 10L;
    public static final long ASSOC = 150L;
    public static final long SET_COMPARE_PER_ELEMENT = 10L;
    public static final long CREATE_ACCOUNT = 100L;
    public static final long QUERY = 10L;
    public static final long LOG = 1000L;
    public static final long SPECIAL = 10L;
    public static final long SET_BANG = 20L;
    public static final long PEER_UPDATE = 1000L;
    private static final int MIN_NUMERIC_COST = 8;
    public static final int MEMORY_TRADE = 200;

    public static final long addMul(long a, long b, long c) {
        return Juice.add(a, Juice.mul(b, c));
    }

    public static final long mul(long a, long b) {
        if (a < 0L || b < 0L) {
            return Long.MAX_VALUE;
        }
        if (Math.multiplyHigh(a, b) > 0L) {
            return Long.MAX_VALUE;
        }
        return a * b;
    }

    public static final long add(long a, long b) {
        if (a < 0L || b < 0L) {
            return Long.MAX_VALUE;
        }
        if (a + b < 0L) {
            return Long.MAX_VALUE;
        }
        return a + b;
    }

    public static long costBuildStructure(ACountable<ACell> counted, long n) {
        long elementCost = Juice.costAddElement(counted);
        return Juice.addMul(50L, elementCost, n);
    }

    private static long costAddElement(ACountable<ACell> counted) {
        if (counted instanceof ADataStructure) {
            return 50L;
        }
        if (counted == null) {
            return 50L;
        }
        return 1L;
    }

    public static long buildStringCost(long n) {
        return Juice.addMul(20L, 1L, n);
    }

    public static long buildBlobCost(long n) {
        return Juice.addMul(20L, 1L, n);
    }

    public static long limitString(Context context) {
        long juice = context.getJuiceAvailable();
        long limit = juice / 1L;
        return limit;
    }

    public static long buildDataCost(long n) {
        return Juice.addMul(50L, 50L, n);
    }

    public static long precostNumericLinear(ACell[] args) {
        long r = 0L;
        long size = 0L;
        for (int i = 0; i < args.length; ++i) {
            long ar = Juice.costNumeric(args[i]);
            if (ar < 0L) {
                return -1L;
            }
            size = Math.max(size, ar);
            r = Juice.add(r, size);
        }
        return r;
    }

    public static long precostNumericMultiply(ACell[] args) {
        long result = 0L;
        long lastSize = 0L;
        boolean usedouble = false;
        for (int i = 0; i < args.length; ++i) {
            ACell a = args[i];
            long argSize = Juice.costNumeric(a);
            if (argSize < 0L) {
                return -1L;
            }
            if (usedouble) {
                result = Juice.add(result, argSize);
                continue;
            }
            if (a instanceof CVMDouble) {
                usedouble = true;
                result = Juice.add(result, argSize + lastSize);
                lastSize = 0L;
                continue;
            }
            long extra = lastSize * argSize;
            lastSize += argSize;
            result = Juice.add(result, extra);
        }
        return result;
    }

    public static long costNumeric(ACell a) {
        if (!(a instanceof ANumeric)) {
            return -1L;
        }
        if (a instanceof CVMBigInteger) {
            long bl = ((CVMBigInteger)a).byteLength();
            return Math.max(8L, bl);
        }
        return 8L;
    }

    public static long calcAvailable(long balance, long juicePrice) {
        long limit = balance / juicePrice - 500L;
        return Math.max(0L, limit);
    }

    public static long priceMemorySize(ACell a) {
        return Juice.mul(20L, Cells.storageSize(a));
    }

    public static long priceTransaction(ATransaction tx) {
        return 500L + Juice.priceMemorySize(tx);
    }
}

