/*
 * Decompiled with CFR 0.152.
 */
package convex.core.init;

import convex.core.Constants;
import convex.core.State;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Index;
import convex.core.data.PeerStatus;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.lang.Code;
import convex.core.lang.Context;
import convex.core.lang.Core;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.List;

public class Init {
    public static final Address NULL_ADDRESS = Address.create(0L);
    public static final Address INIT_ADDRESS = Address.create(1L);
    public static final Address FOUNDATION_ADDRESS = Address.create(2L);
    public static final Address RESERVE_ADDRESS = Address.create(3L);
    public static final Address UNRELEASED_ADDRESS = Address.create(4L);
    public static final Address DISTRIBUTION_ADDRESS = Address.create(5L);
    public static final Address GOVERNANCE_ADDRESS = Address.create(6L);
    public static final Address ADMIN_ADDRESS = Address.create(7L);
    public static final Address CORE_ADDRESS = Address.create(8L);
    public static final Address REGISTRY_ADDRESS = Address.create(9L);
    public static final Address TRUST_ADDRESS = Address.create(10L);
    public static final Address GENESIS_ADDRESS = Address.create(11L);
    public static final Address GENESIS_PEER_ADDRESS = Address.create(12L);
    public static final Address FIRST_USER_ADDRESS = Address.create(13L);
    private static final Index<AccountKey, PeerStatus> EMPTY_PEERS = Index.none();
    private static final Index<ABlob, AVector<ACell>> EMPTY_SCHEDULE = Index.none();

    public static State createBaseState(AccountKey governanceKey, AccountKey genesisKey, List<AccountKey> peerKeys) {
        Index<AccountKey, PeerStatus> peers = EMPTY_PEERS;
        AVector<AccountStatus> accts = Vectors.empty();
        long supply = 1000000000000000000L;
        AccountStatus nullAccount = AccountStatus.create(0L, AccountKey.NULL);
        accts = accts.conj(nullAccount);
        AccountStatus initAccount = AccountStatus.create(0L, AccountKey.NULL);
        accts = Init.addAccount(accts, INIT_ADDRESS, initAccount);
        long foundationFund = 1000000000000000L;
        AccountStatus foundationAccount = AccountStatus.create(foundationFund, governanceKey);
        accts = Init.addAccount(accts, FOUNDATION_ADDRESS, foundationAccount);
        supply -= foundationFund;
        long reserve = 248000000000000000L;
        AccountStatus reserveAccount = AccountStatus.create(reserve, governanceKey);
        reserveAccount = reserveAccount.withController(FOUNDATION_ADDRESS);
        accts = Init.addAccount(accts, RESERVE_ADDRESS, reserveAccount);
        supply -= reserve;
        long releaseCurveFund = 740000000000000000L;
        AccountStatus releaseCurveAccount = AccountStatus.create(releaseCurveFund, governanceKey);
        releaseCurveAccount = releaseCurveAccount.withController(FOUNDATION_ADDRESS);
        accts = Init.addAccount(accts, UNRELEASED_ADDRESS, releaseCurveAccount);
        supply -= releaseCurveFund;
        long distributionFund = 10000000000000000L;
        releaseCurveAccount = AccountStatus.create(distributionFund, governanceKey);
        releaseCurveAccount = releaseCurveAccount.withController(FOUNDATION_ADDRESS);
        accts = Init.addAccount(accts, DISTRIBUTION_ADDRESS, releaseCurveAccount);
        supply -= distributionFund;
        long governFund = 1000000000000L;
        AccountStatus governanceAccount = AccountStatus.create(governFund, governanceKey);
        governanceAccount = governanceAccount.withController(FOUNDATION_ADDRESS);
        accts = Init.addAccount(accts, GOVERNANCE_ADDRESS, governanceAccount);
        supply -= governFund;
        long admin = 1000000000000L;
        governanceAccount = AccountStatus.create(admin, genesisKey);
        governanceAccount = governanceAccount.withController(FOUNDATION_ADDRESS);
        accts = Init.addAccount(accts, ADMIN_ADDRESS, governanceAccount);
        supply -= admin;
        accts = Init.addCoreLibrary(accts);
        int keyCount = peerKeys.size();
        assert (keyCount > 0);
        AVector<ACell> globals = Constants.INITIAL_GLOBALS;
        State s = State.create(accts, peers, globals, EMPTY_SCHEDULE);
        assert ((supply -= s.getGlobalMemoryValue().longValue()) > 100000000000000L);
        s = Init.addStaticLibraries(s);
        accts = s.getAccounts();
        assert (accts.count() == GENESIS_ADDRESS.longValue());
        long userFunds = (long)((double)supply * 0.8);
        supply -= userFunds;
        long genFunds = userFunds / 2L;
        accts = Init.addAccount(accts, GENESIS_ADDRESS, peerKeys.get(0), genFunds);
        userFunds -= genFunds;
        for (int i = 0; i < keyCount; ++i) {
            Address address = Address.create(accts.count());
            assert (address.longValue() == accts.count());
            AccountKey key = peerKeys.get(i);
            long userBalance = userFunds / (long)(keyCount - i);
            accts = Init.addAccount(accts, address, key, userBalance);
            userFunds -= userBalance;
        }
        assert (userFunds == 0L);
        long peerFunds = supply;
        supply -= peerFunds;
        for (int i = 0; i < keyCount; ++i) {
            AccountKey peerKey = peerKeys.get(i);
            Address peerController = Init.getGenesisPeerAddress(i);
            long peerStake = peerFunds / (long)(keyCount - i);
            peers = Init.addPeer(peers, peerKey, peerController, peerStake);
            peerFunds -= peerStake;
        }
        assert (peerFunds == 0L);
        s = s.withAccounts(accts);
        long total = (s = s.withPeers(peers)).computeTotalFunds();
        if (total != 1000000000000000000L) {
            throw new Error("Bad total amount: " + total);
        }
        return s;
    }

    private static State addStaticLibraries(State s) {
        s = Init.doActorDeploy(s, "/convex/core/registry.cvx");
        s = Init.doActorDeploy(s, "/convex/core/trust.cvx");
        Context ctx = Context.create(s, INIT_ADDRESS);
        ctx = ctx.eval((ACell)Reader.read("(call *registry* (cns-update 'convex.core " + String.valueOf(CORE_ADDRESS) + "))"));
        s = ctx.getState();
        s = Init.register(s, CORE_ADDRESS, "Convex Core Library", "Core utilities accessible by default in any account.");
        s = Init.register(s, FOUNDATION_ADDRESS, "Foundation Governance", "Master network governance account.");
        s = Init.register(s, RESERVE_ADDRESS, "Foundation Reserve", "Unreleased Foundation coin reserve.");
        s = Init.register(s, UNRELEASED_ADDRESS, "Release Curve Reserve", "Release curve unreleased coins.");
        s = Init.register(s, DISTRIBUTION_ADDRESS, "Release Curve Pre-Distribution", "Release curve coins for future distribution.");
        s = Init.register(s, GOVERNANCE_ADDRESS, "Network Governance", "Network governance account.");
        s = Init.register(s, ADMIN_ADDRESS, "Network Admin", "Network admin accouns.");
        return s;
    }

    public static State createState(List<AccountKey> genesisKeys) {
        return Init.createState(genesisKeys.get(0), genesisKeys);
    }

    public static State createState(AccountKey genesisKey, List<AccountKey> peerKeys) {
        return Init.createState(genesisKey, genesisKey, peerKeys);
    }

    public static State createState(AccountKey governanceKey, AccountKey genesisKey, List<AccountKey> peerKeys) {
        State s = Init.createBaseState(governanceKey, genesisKey, peerKeys);
        s = Init.addStandardLibraries(s);
        s = Init.addTestingCurrencies(s);
        long finalTotal = (s = Init.addCNSTree(s)).computeTotalFunds();
        if (finalTotal != 1000000000000000000L) {
            throw new Error("Bad total funds in init state amount: " + finalTotal);
        }
        return s;
    }

    private static State addTestingCurrencies(State s) {
        try {
            AVector table = (AVector)Reader.readResourceAsData("/convex/torus/genesis-currencies.cvx");
            for (AVector row : table) {
                s = Init.doCurrencyDeploy(s, row);
            }
        }
        catch (IOException e) {
            throw new Error("Failure reading source data for currencies", e);
        }
        return s;
    }

    private static State addStandardLibraries(State s) {
        s = Init.doActorDeploy(s, "/convex/asset/fungible.cvx");
        s = Init.doActorDeploy(s, "/convex/lab/trusted-oracle/actor.cvx");
        s = Init.doActorDeploy(s, "/convex/lab/oracle.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/asset.cvx");
        s = Init.doActorDeploy(s, "/convex/torus/exchange.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/nft/simple.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/nft/basic.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/nft/tokens.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/box/actor.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/box.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/multi-token.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/share.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/market/trade.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/wrap/convex.cvx");
        s = Init.doActorDeploy(s, "/convex/lab/play.cvx");
        s = Init.doActorDeploy(s, "/convex/lab/did.cvx");
        s = Init.doActorDeploy(s, "/convex/lab/curation-market.cvx");
        s = Init.doActorDeploy(s, "/convex/trust/ownership-monitor.cvx");
        s = Init.doActorDeploy(s, "/convex/trust/delegate.cvx");
        s = Init.doActorDeploy(s, "/convex/trust/whitelist.cvx");
        s = Init.doActorDeploy(s, "/convex/trust/monitors.cvx");
        s = Init.doActorDeploy(s, "/convex/trust/governance.cvx");
        s = Init.doActorDeploy(s, "/convex/asset/spatial.cvx");
        return s;
    }

    private static State addCNSTree(State s) {
        Context ctx = Context.create(s, INIT_ADDRESS);
        s = ctx.getState();
        return s;
    }

    public static Address calcPeerAddress(int userCount, int index) {
        return Address.create(GENESIS_ADDRESS.longValue() + (long)userCount + (long)index);
    }

    public static Address calcUserAddress(int index) {
        return Address.create(GENESIS_ADDRESS.longValue() + (long)index);
    }

    private static State doActorDeploy(State s, String resource) {
        Context ctx = Context.create(s, INIT_ADDRESS);
        Object ADD_NETWORK_GOVERNANCE = Reader.read("(set-controller " + String.valueOf(GOVERNANCE_ADDRESS) + ")");
        try {
            AList<ACell> forms = Reader.readAll(Utils.readResourceAsString(resource));
            AList<ACell> code = forms.drop(1L);
            code = code.cons((ACell)ADD_NETWORK_GOVERNANCE);
            ctx = ctx.deploy(code.toCellArray());
            if (ctx.isExceptional()) {
                throw new Error("Error deploying actor: " + resource + "\n" + String.valueOf(ctx.getValue()));
            }
            Address addr = (Address)ctx.getResult();
            AList qsym = (AList)forms.get(0);
            Symbol sym = (Symbol)qsym.get(1);
            if ((ctx = ctx.eval(Code.cnsUpdate(sym, addr))).isExceptional()) {
                throw new Error("Error while registering actor:" + String.valueOf(ctx.getValue()));
            }
            return ctx.getState();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static State doCurrencyDeploy(State s, AVector<ACell> row) {
        String symName = ((ACell)row.get(0)).toString();
        String name = ((ACell)row.get(1)).toString();
        String desc = ((ACell)row.get(2)).toString();
        double usdPrice = (Double)RT.jvm((ACell)row.get(6));
        long decimals = (Long)RT.jvm((ACell)row.get(5));
        long usdValue = (Long)RT.jvm((ACell)row.get(4));
        long subDivisions = Math.round(Math.pow(10.0, decimals));
        double liquidity = (double)usdValue / usdPrice * (double)subDivisions;
        long supply = Math.round(liquidity);
        double cvxPrice = usdPrice * 1.0E9;
        double cvx = cvxPrice * (double)supply / (double)subDivisions;
        String metaString = "{:name " + String.valueOf(RT.print(name)) + ":desc " + String.valueOf(RT.print(desc)) + "}";
        Context ctx = Context.create(s, GENESIS_ADDRESS);
        ctx = ctx.eval((ACell)Reader.read("(do (import convex.fungible :as fun) (deploy '(call *registry* (register " + metaString + "))(fun/build-token {:supply " + supply + " :decimals " + decimals + "})))"));
        Address addr = (Address)ctx.getResult();
        if ((ctx = ctx.eval((ACell)Reader.read("(do (import torus.exchange :as torus) (torus/add-liquidity " + String.valueOf(addr) + " " + supply / 2L + " " + cvx / 2.0 + "))"))).isExceptional()) {
            throw new Error("Error adding market liquidity: " + String.valueOf(ctx.getValue()));
        }
        Symbol sym = Symbol.create("currency." + symName);
        if ((ctx = ctx.eval(Code.cnsUpdate(sym, addr))).isExceptional()) {
            throw new Error("Error registering currency in CNS: " + String.valueOf(ctx.getValue()));
        }
        return ctx.getState();
    }

    private static State register(State state, Address origin, String name, String description) {
        Context ctx = Context.create(state, origin);
        ctx = ctx.eval((ACell)Reader.read("(call *registry* (register {:description \"" + description + "\" :name \"" + name + "\"}))"));
        return ctx.getState();
    }

    public static Address getGenesisAddress() {
        return GENESIS_ADDRESS;
    }

    public static Address getGenesisPeerAddress(int index) {
        return GENESIS_ADDRESS.offset(index + 1);
    }

    private static Index<AccountKey, PeerStatus> addPeer(Index<AccountKey, PeerStatus> peers, AccountKey peerKey, Address owner, long initialStake) {
        PeerStatus ps = PeerStatus.create(owner, initialStake, null);
        if (peers.containsKey(peerKey)) {
            throw new IllegalArgumentException("Duplicate peer key");
        }
        return peers.assoc(peerKey, ps);
    }

    private static AVector<AccountStatus> addAccount(AVector<AccountStatus> accts, Address address, AccountStatus account) {
        long num = address.longValue();
        if (accts.count() != num) {
            throw new Error("Incorrect initialisation address: " + String.valueOf(address));
        }
        accts = accts.conj(account);
        return accts;
    }

    private static AVector<AccountStatus> addCoreLibrary(AVector<AccountStatus> accts) {
        if (accts.count() != CORE_ADDRESS.longValue()) {
            throw new Error("Incorrect core library address: " + accts.count());
        }
        AccountStatus as = AccountStatus.createActor();
        as = as.withEnvironment(Core.ENVIRONMENT);
        as = as.withMetadata(Core.METADATA);
        accts = accts.conj(as);
        return accts;
    }

    private static AVector<AccountStatus> addAccount(AVector<AccountStatus> accts, Address a, AccountKey key, long balance) {
        if (accts.count() != a.longValue()) {
            throw new Error("Incorrect account address: " + String.valueOf(a));
        }
        AccountStatus as = AccountStatus.create(0L, balance, key);
        as = as.withMemory(10000000L);
        accts = accts.conj(as);
        return accts;
    }
}

