/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.util;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import java.util.Spliterator;
import java.util.function.Consumer;

public class SequenceSpliterator<T extends ACell>
implements Spliterator<T> {
    long start;
    long end;
    private ASequence<T> seq;

    public SequenceSpliterator(ASequence<T> seq, long start, long end) {
        this.start = start;
        this.end = end;
        this.seq = seq;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.start < this.end) {
            T value = this.seq.get(this.start++);
            action.accept(value);
            return true;
        }
        return false;
    }

    @Override
    public SequenceSpliterator<T> trySplit() {
        if (this.start + 1L >= this.end) {
            return null;
        }
        long split = (this.start + this.end) / 2L;
        SequenceSpliterator<T> result = new SequenceSpliterator<T>(this.seq, split, this.end);
        this.end = split;
        return result;
    }

    @Override
    public long estimateSize() {
        return this.end - this.start;
    }

    @Override
    public int characteristics() {
        return 21584;
    }
}

