/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.math.BigInteger;

public final class CVMBigInteger
extends AInteger {
    public static final CVMBigInteger MIN_POSITIVE = CVMBigInteger.wrap(new byte[]{0, -128, 0, 0, 0, 0, 0, 0, 0});
    public static final CVMBigInteger MIN_NEGATIVE = CVMBigInteger.wrap(new byte[]{-1, 127, -1, -1, -1, -1, -1, -1, -1});
    public static final BigInteger MIN_POSITIVE_BIG = new BigInteger("9223372036854775808");
    public static final BigInteger MIN_NEGATIVE_BIG = new BigInteger("-9223372036854775809");
    protected static final long LONG_BYTELENGTH = 8L;
    protected static final long MAX_BYTELENGTH = 4096L;
    private ABlob blob;
    private BigInteger data;

    private CVMBigInteger(ABlob blob, BigInteger value) {
        this.blob = blob;
        this.data = value;
    }

    public static CVMBigInteger wrap(byte[] bs) {
        byte[] tbs = Utils.trimBigIntegerLeadingBytes(bs);
        if ((long)tbs.length > 4096L) {
            return null;
        }
        if (tbs == bs) {
            tbs = (byte[])tbs.clone();
        }
        return new CVMBigInteger(Blob.wrap(tbs), null);
    }

    public static CVMBigInteger wrap(BigInteger value) {
        if ((long)value.bitLength() > 32767L) {
            return null;
        }
        return new CVMBigInteger(null, value);
    }

    public static CVMBigInteger create(ABlob data) {
        byte bs2;
        byte bs;
        long n = data.count();
        if (n == 0L) {
            return null;
        }
        if (n > 1L && ((bs = data.byteAt(0L)) == 0 || bs == -1) && (bs & 0x80) == ((bs2 = data.byteAt(1L)) & 0x80)) {
            return null;
        }
        return new CVMBigInteger(data, null);
    }

    @Override
    public CVMLong toLong() {
        return CVMLong.create(this.longValue());
    }

    @Override
    public long longValue() {
        if (this.blob != null) {
            return this.blob.longValue();
        }
        return this.data.longValue();
    }

    @Override
    public BigInteger big() {
        if (this.data == null) {
            this.data = this.buildBigInteger();
        }
        return this.data;
    }

    protected ABlob blob() {
        if (this.blob == null) {
            this.blob = this.buildBlob();
        }
        return this.blob;
    }

    protected ABlob buildBlob() {
        return Blob.wrap(this.data.toByteArray());
    }

    protected BigInteger buildBigInteger() {
        long n = this.blob.count();
        if (n == 0L) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.blob.getBytes());
    }

    @Override
    public CVMDouble toDouble() {
        return CVMDouble.create(this.doubleValue());
    }

    @Override
    public Class<?> numericType() {
        return Long.class;
    }

    @Override
    public CVMLong signum() {
        if (this.data != null) {
            return CVMLong.forSignum(this.data.signum());
        }
        return CVMLong.forSignum(this.blob.byteAt(0L));
    }

    @Override
    public int estimatedEncodingSize() {
        if (this.blob != null) {
            return this.blob.estimatedEncodingSize();
        }
        return (int)Math.min((long)Blob.MAX_ENCODING_LENGTH, this.byteLength() + 10L);
    }

    @Override
    public double doubleValue() {
        return this.big().doubleValue();
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public byte getTag() {
        return this.getEncoding().byteAt(0L);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        if (!this.isCanonical()) {
            return ((ACell)this.getCanonical()).encode(bs, pos);
        }
        bs[pos++] = 25;
        return this.encodeRaw(bs, pos);
    }

    @Override
    protected int encodeRaw(byte[] bs, int pos) {
        ABlob b = this.blob();
        return b.encodeRaw(bs, pos);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        long blen = this.byteLength();
        if (blen > limit * 2L) {
            return false;
        }
        AString s = Strings.create(this.big().toString());
        if (s.count() > limit) {
            sb.append(s.slice(0L, limit));
            return false;
        }
        sb.append(s);
        return true;
    }

    @Override
    public long byteLength() {
        if (this.blob != null) {
            return this.blob.count();
        }
        return this.data.bitLength() / 8 + 1;
    }

    @Override
    public String toString() {
        return this.big().toString();
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof CVMLong) {
            if (this.isCanonical()) {
                return false;
            }
            return ((ACell)this.getCanonical()).equals(a);
        }
        if (a instanceof CVMBigInteger) {
            return this.equals((CVMBigInteger)a);
        }
        return false;
    }

    public boolean equals(CVMBigInteger a) {
        if (this.data != null && a.data != null) {
            return this.data.compareTo(a.data) == 0;
        }
        return this.blob().equals(a.blob());
    }

    public BigInteger getBigInteger() {
        return this.big();
    }

    @Override
    public boolean isCanonical() {
        return this.blob().count() > 8L;
    }

    @Override
    protected long calcMemorySize() {
        return this.blob().getMemorySize();
    }

    @Override
    public boolean isEmbedded() {
        if (this.memorySize == 0L) {
            return true;
        }
        return this.blob().isEmbedded();
    }

    @Override
    public int getRefCount() {
        return this.blob().getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.blob().getRef(i);
    }

    @Override
    public AInteger toCanonical() {
        if (this.isCanonical()) {
            return this;
        }
        ABlob b = this.blob();
        long v = b.longValue();
        int shift = (int)(64L - b.count() * 8L);
        v = v << shift >> shift;
        return CVMLong.create(v);
    }

    public static CVMBigInteger read(Blob blob, int offset) throws BadFormatException {
        Object b = Blobs.read(blob, offset);
        if (b == null) {
            throw new BadFormatException("Bad big integer format in read from blob");
        }
        if (((ABlob)b).count() <= 8L) {
            throw new BadFormatException("Non-canonical big integer length");
        }
        CVMBigInteger result = CVMBigInteger.create(b);
        if (result == null) {
            throw new BadFormatException("Null result in big integer create from blob");
        }
        result.attachEncoding(blob.slice(offset, offset + ((ACell)b).getEncodingLength()));
        return result;
    }

    @Override
    public ANumeric abs() {
        BigInteger bi = this.big();
        if (bi.signum() >= 0) {
            return this;
        }
        return CVMBigInteger.wrap(bi.abs());
    }

    @Override
    public AInteger inc() {
        BigInteger bi = this.big().add(BigInteger.ONE);
        return AInteger.create(bi);
    }

    @Override
    public AInteger dec() {
        BigInteger bi = this.big().subtract(BigInteger.ONE);
        return AInteger.create(bi);
    }

    @Override
    public int compareTo(ANumeric o) {
        if (o instanceof CVMLong) {
            if (!this.isCanonical()) {
                return ((CVMLong)this.getCanonical()).compareTo(o);
            }
            if (this.big().compareTo(MIN_POSITIVE.big()) >= 0) {
                return 1;
            }
            return -1;
        }
        if (o instanceof CVMBigInteger) {
            return this.big().compareTo(((CVMBigInteger)o).big());
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    @Override
    public AInteger add(AInteger a) {
        BigInteger bi = this.big();
        bi = bi.add(a.big());
        return CVMBigInteger.wrap(bi).toCanonical();
    }

    @Override
    public AInteger sub(AInteger b) {
        BigInteger bi = this.big();
        bi = bi.subtract(b.big());
        return CVMBigInteger.wrap(bi).toCanonical();
    }

    @Override
    public AInteger negate() {
        BigInteger bi = this.big();
        CVMBigInteger neg = CVMBigInteger.wrap(bi = bi.negate());
        if (neg == null) {
            return null;
        }
        return ((AInteger)neg).toCanonical();
    }

    public static CVMBigInteger parse(String s) {
        BigInteger bi = new BigInteger(s);
        return CVMBigInteger.wrap(bi);
    }

    @Override
    public CVMLong ensureLong() {
        if (this.byteLength() > 8L) {
            return null;
        }
        return (CVMLong)this.getCanonical();
    }

    @Override
    public ANumeric multiply(ANumeric b) {
        if (b instanceof CVMDouble) {
            return CVMDouble.create(this.big().doubleValue() * b.doubleValue());
        }
        BigInteger bb = b instanceof CVMLong ? BigInteger.valueOf(b.longValue()) : ((CVMBigInteger)b).getBigInteger();
        return CVMBigInteger.wrap(this.big().multiply(bb));
    }

    @Override
    public boolean isZero() {
        return this.big().signum() == 0;
    }

    @Override
    public AInteger mod(AInteger base) {
        BigInteger divisor = base.big();
        int signum = divisor.signum();
        if (signum == 0) {
            throw new IllegalArgumentException("mod by zero");
        }
        if (signum < 0) {
            divisor = divisor.negate();
        }
        return AInteger.create(this.big().mod(divisor));
    }

    @Override
    public AInteger rem(AInteger base) {
        BigInteger divisor = base.big();
        int signum = divisor.signum();
        if (signum == 0) {
            throw new IllegalArgumentException("rem by zero");
        }
        return AInteger.create(this.big().remainder(divisor));
    }

    @Override
    public AInteger div(AInteger base) {
        BigInteger divisor = base.big();
        int signum = divisor.signum();
        if (signum == 0) {
            throw new IllegalArgumentException("div by zero");
        }
        BigInteger d = this.big().divide(divisor);
        return AInteger.create(d);
    }

    @Override
    public AInteger quot(AInteger base) {
        BigInteger divisor = base.big();
        int signum = divisor.signum();
        if (signum == 0) {
            throw new IllegalArgumentException("quot by zero");
        }
        BigInteger d = this.big().divide(divisor);
        return AInteger.create(d);
    }

    @Override
    public ABlob toBlob() {
        return this.blob();
    }

    @Override
    public boolean isLong() {
        return !this.isCanonical();
    }
}

