/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.ASpecialVector;
import convex.core.data.AVector;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class VectorArray<T extends ACell>
extends ASpecialVector<T> {
    private ACell[] data;
    private int start;

    private VectorArray(ACell[] data, long start, long count) {
        super(count);
        this.data = data;
        this.start = Utils.checkedInt(start);
    }

    public static <T extends ACell> VectorArray<T> wrap(ACell[] arr) {
        return new VectorArray<T>(arr, 0L, arr.length);
    }

    public static <T extends ACell> VectorArray<T> of(Object ... os) {
        int n = os.length;
        ACell[] data = new ACell[n];
        for (int i = 0; i < n; ++i) {
            data[i] = RT.cvm(os[i]);
        }
        return new VectorArray<T>(data, 0L, n);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new VectorArrayIterator(0L);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.getCanonical().estimatedEncodingSize();
    }

    @Override
    public T get(long i) {
        this.checkIndex(i);
        return (T)this.data[Utils.checkedInt((long)this.start + i)];
    }

    @Override
    public AVector<T> appendChunk(AVector<T> listVector) {
        return this.toVector().appendChunk(listVector);
    }

    @Override
    public VectorLeaf<T> getChunk(long offset) {
        return this.toVector().getChunk(offset);
    }

    @Override
    public AVector<T> append(T value) {
        return this.toVector().append(value);
    }

    @Override
    public boolean isFullyPacked() {
        return this.toVector().isFullyPacked();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> pred) {
        return this.toVector().anyMatch(pred);
    }

    @Override
    public boolean allMatch(Predicate<? super T> pred) {
        return this.toVector().allMatch(pred);
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<? super T, ? extends R> mapper) {
        return this.toVector().map((Function)mapper);
    }

    @Override
    public AVector<T> concat(ASequence<? extends T> b) {
        return this.toVector().concat((ASequence)b);
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super T, ? extends R> func, R value) {
        return this.toVector().reduce(func, value);
    }

    @Override
    public ListIterator<T> listIterator(long index) {
        if (index < 0L || index > this.count) {
            throw new IndexOutOfBoundsException(index);
        }
        return new VectorArrayIterator(index);
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public AVector<T> updateRefs(IRefFunction func) {
        return this.toVector().updateRefs(func);
    }

    @Override
    public long commonPrefixLength(AVector<T> b) {
        return this.toVector().commonPrefixLength(b);
    }

    @Override
    public AVector<T> next() {
        if (this.count <= 1L) {
            return null;
        }
        return new VectorArray<T>(this.data, this.start + 1, this.count - 1L);
    }

    @Override
    public AVector<T> assoc(long i, T value) {
        return this.toVector().assoc(i, (ACell)value);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.toVector().encodeRaw(bs, pos);
    }

    @Override
    protected Ref<T> getElementRefUnsafe(long i) {
        return this.toVector().getElementRefUnsafe(i);
    }

    @Override
    public long longIndexOf(Object value) {
        int i = 0;
        while ((long)i < this.count) {
            if (Utils.equals((Object)this.data[this.start + i], value)) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long longLastIndexOf(Object value) {
        for (int i = Utils.checkedInt(this.count) - 1; i >= 0; --i) {
            if (!Utils.equals((Object)this.data[this.start + i], value)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        int i = 0;
        while ((long)i < this.count) {
            action.accept(this.data[this.start + i]);
            ++i;
        }
    }

    @Override
    public void visitElementRefs(Consumer<Ref<T>> f) {
        int i = 0;
        while ((long)i < this.count) {
            f.accept(Ref.get(this.data[this.start + i]));
            ++i;
        }
    }

    @Override
    public Ref<T> getElementRef(long index) {
        return Ref.get(this.get(index));
    }

    @Override
    public AVector<T> slice(long start, long end) {
        if (!this.checkRange(start, end)) {
            return null;
        }
        long length = end - start;
        if (length == 0L) {
            return Vectors.empty();
        }
        if (length == this.count) {
            return this;
        }
        return new VectorArray<T>(this.data, (long)this.start + start, length);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        return ((ACell)this.getCanonical()).encode(bs, pos);
    }

    @Override
    public AVector<T> toVector() {
        return (AVector)this.getCanonical();
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        int i = 0;
        while ((long)i < this.count) {
            arr[offset + i] = this.data[this.start + i];
            ++i;
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        ((ACell)this.getCanonical()).validateCell();
    }

    @Override
    public boolean equals(AVector<? super T> a) {
        if (a == this) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.count != a.count) {
            return false;
        }
        return ((ACell)this.getCanonical()).equals(a);
    }

    @Override
    protected ACell toCanonical() {
        return Vectors.create(this.data, Utils.checkedInt(this.start), Utils.checkedInt(this.count));
    }

    @Override
    public int getRefCount() {
        return ((ACell)this.getCanonical()).getRefCount();
    }

    public Ref<ACell> getRef(int i) {
        return ((ACell)this.getCanonical()).getRef(i);
    }

    private class VectorArrayIterator
    implements ListIterator<T> {
        long pos = 0L;

        public VectorArrayIterator(long pos) {
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < VectorArray.this.count;
        }

        @Override
        public T next() {
            if (this.pos >= VectorArray.this.count) {
                throw new NoSuchElementException();
            }
            return VectorArray.this.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0L;
        }

        @Override
        public T previous() {
            if (this.pos > 0L) {
                return VectorArray.this.get(--this.pos);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return Utils.checkedInt(this.pos);
        }

        @Override
        public int previousIndex() {
            return Utils.checkedInt(this.pos) - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }
    }
}

