/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public final class Syntax
extends ACell {
    public static final Syntax EMPTY = Syntax.create(null, null);
    public static final AString EMPTY_META_PREFIX = Strings.create("^{} ");
    public static final int MAX_ENCODING_LENGTH = 1 + Maps.MAX_ENCODING_SIZE + 140;
    private final Ref<ACell> datumRef;
    private final AHashMap<ACell, ACell> meta;

    private Syntax(Ref<ACell> datumRef, AHashMap<ACell, ACell> props) {
        this.datumRef = datumRef;
        this.meta = props;
    }

    @Override
    public AType getType() {
        return Types.SYNTAX;
    }

    public static Syntax createUnchecked(ACell value, AHashMap<ACell, ACell> meta) {
        return new Syntax(Ref.get(value), meta);
    }

    public static Syntax create(ACell value, AHashMap<ACell, ACell> meta) {
        if (value instanceof Syntax) {
            Syntax stx = (Syntax)value;
            if (meta == null) {
                return stx;
            }
            return stx.mergeMeta(meta);
        }
        if (meta == null) {
            meta = Maps.empty();
        }
        return new Syntax(Ref.get(value), meta);
    }

    public static Syntax create(ACell value) {
        if (value instanceof Syntax) {
            return (Syntax)value;
        }
        return Syntax.create(value, Maps.empty());
    }

    public static Syntax of(ACell value) {
        return Syntax.create(value);
    }

    public static Syntax of(Object value) {
        return Syntax.create(RT.cvm(value));
    }

    public <R> R getValue() {
        return (R)this.datumRef.getValue();
    }

    public AHashMap<ACell, ACell> getMeta() {
        return this.meta;
    }

    public Long getStart() {
        Object v = this.meta.get(Keywords.START);
        if (v instanceof CVMLong) {
            return ((CVMLong)v).longValue();
        }
        return null;
    }

    public Long getEnd() {
        Object v = this.meta.get(Keywords.END);
        if (v instanceof CVMLong) {
            return ((CVMLong)v).longValue();
        }
        return null;
    }

    public String getSource() {
        Object v = this.meta.get(Keywords.SOURCE);
        if (v instanceof AString) {
            return v.toString();
        }
        return null;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public final boolean isDataValue() {
        return true;
    }

    public static Syntax read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<ACell> datum = Format.readRef(b, epos);
        epos = (int)((long)epos + datum.getEncodingLength());
        AHashMap props = (AHashMap)Format.read(b, epos);
        epos += Format.getEncodingLength(props);
        if (props == null) {
            props = Maps.empty();
        } else if (props.isEmpty()) {
            throw new BadFormatException("Empty Syntax metadata should be encoded as nil");
        }
        Syntax result = new Syntax(datum, props);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -120;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.datumRef.encode(bs, pos);
        if (this.meta.isEmpty()) {
            bs[pos++] = 0;
        } else {
            pos = Format.write(bs, pos, this.meta);
        }
        return pos;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        if (this.meta == null) {
            bb.append(EMPTY_META_PREFIX);
        } else {
            bb.append('^');
            if (!this.meta.print(bb, limit)) {
                return false;
            }
            bb.append(' ');
        }
        return RT.print(bb, this.datumRef.getValue(), limit);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.datumRef == null) {
            throw new InvalidDataException("null datum ref", this);
        }
        if (this.meta == null) {
            throw new InvalidDataException("null metadata", this);
        }
        this.meta.validateCell();
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        ACell datum = this.datumRef.getValue();
        if (datum != null) {
            if (datum instanceof Syntax) {
                throw new InvalidDataException("Cannot double-wrap a Syntax value", this);
            }
            if (!datum.isCVMValue()) {
                throw new InvalidDataException("Syntax can only wrap CVM values", this);
            }
        }
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.meta.estimatedEncodingSize() + 140;
    }

    @Override
    public int getRefCount() {
        return 1 + this.meta.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i == 0) {
            return this.datumRef;
        }
        return this.meta.getRef(i - 1);
    }

    @Override
    public Syntax updateRefs(IRefFunction func) {
        Ref<ACell> newDatum = func.apply(this.datumRef);
        ACell newMeta = this.meta.updateRefs(func);
        if (this.datumRef == newDatum && this.meta == newMeta) {
            return this;
        }
        return new Syntax(newDatum, (AHashMap<ACell, ACell>)newMeta);
    }

    public Syntax mergeMeta(AHashMap<ACell, ACell> additionalMetadata) {
        AHashMap<ACell, ACell> mm = this.meta;
        mm = mm.merge(additionalMetadata);
        return this.withMeta(mm);
    }

    public static Syntax mergeMeta(ACell original, Syntax additional) {
        Syntax x = Syntax.create(original);
        if (additional != null) {
            x = x.mergeMeta(additional.getMeta());
        }
        return x;
    }

    public Syntax withMeta(AHashMap<ACell, ACell> newMetadata) {
        if (this.meta == newMetadata) {
            return this;
        }
        return new Syntax(this.datumRef, newMetadata);
    }

    public Syntax withoutMeta() {
        return this.withMeta((AHashMap<ACell, ACell>)Maps.empty());
    }

    public static <R> R unwrap(ACell x) {
        return (R)(x instanceof Syntax ? ((Syntax)x).getValue() : x);
    }

    public static <R extends ACell> R unwrapAll(ACell maybeSyntax) {
        ACell a = (ACell)Syntax.unwrap(maybeSyntax);
        if (a instanceof ACollection) {
            return (R)((ACollection)a).map(e -> Syntax.unwrapAll(e));
        }
        if (a instanceof AMap) {
            AMap m = (AMap)a;
            return (R)m.reduceEntries((acc, e) -> acc.assoc((ACell)Syntax.unwrapAll((ACell)e.getKey()), (ACell)Syntax.unwrapAll((ACell)e.getValue())), Maps.empty());
        }
        return (R)a;
    }

    @Override
    public byte getTag() {
        return -120;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public boolean equals(ACell o) {
        if (!(o instanceof Syntax)) {
            return false;
        }
        Syntax b = (Syntax)o;
        if (!this.meta.equals(b.meta)) {
            return false;
        }
        return this.datumRef.equals(b.datumRef);
    }
}

