/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefSoft;
import convex.core.exceptions.InvalidDataException;
import convex.core.store.AStore;

public class RefDirect<T extends ACell>
extends Ref<T> {
    private final T value;

    private RefDirect(T value, Hash hash, int flags) {
        super(hash, flags);
        this.value = value;
    }

    static <T extends ACell> RefDirect<T> create(T value, Hash hash, int status) {
        int flags = status & 0xF;
        return new RefDirect<T>(value, hash, flags);
    }

    public static <T extends ACell> RefDirect<T> create(T value) {
        if (value == null) {
            return Ref.NULL_VALUE;
        }
        return RefDirect.create(value, null, 0);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Hash getHash() {
        Hash newHash;
        if (this.hash != null) {
            return this.hash;
        }
        if (this.value == null) {
            return Hash.NULL_HASH;
        }
        this.hash = newHash = ((ACell)this.value).getHash();
        return newHash;
    }

    @Override
    public RefDirect<T> toDirect() {
        return this;
    }

    @Override
    public RefSoft<T> toSoft(AStore store) {
        return RefSoft.create(store, this.value, this.flags);
    }

    @Override
    public boolean equals(Ref<T> a) {
        if (a == this) {
            return true;
        }
        if (a instanceof RefDirect) {
            Hash ha;
            T va = ((RefDirect)a).value;
            if (this.value == va) {
                return true;
            }
            if (this.value == null) {
                return va == null;
            }
            if (this.hash != null && (ha = a.hash) != null) {
                return this.hash.equals(ha);
            }
            return ((ACell)this.value).equals((ACell)va);
        }
        return this.getHash().equals(a.getHash());
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.isEmbedded() != Format.isEmbedded(this.value)) {
            throw new InvalidDataException("Embedded flag is wrong!", this);
        }
        if (this.value == null && this != Ref.NULL_VALUE) {
            throw new InvalidDataException("Null Ref not singleton!", this);
        }
    }

    @Override
    public Ref<T> withValue(T newValue) {
        if (newValue != this.value) {
            return new RefDirect<T>(newValue, this.hash, this.flags);
        }
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        if (this.value == null) {
            return 1;
        }
        return this.isEmbedded() ? this.value.estimatedEncodingSize() : 33;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public RefDirect<T> withFlags(int newFlags) {
        return new RefDirect<T>(this.value, this.hash, newFlags);
    }

    @Override
    public RefDirect<T> ensureCanonical() {
        if (this.value == null || ((ACell)this.value).isCanonical()) {
            return this;
        }
        return new RefDirect<ACell>(((ACell)this.value).toCanonical(), this.hash, this.flags);
    }
}

