/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.MapLeaf;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.Panic;
import convex.core.exceptions.TODOException;
import convex.core.util.Bits;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapTree<K extends ACell, V extends ACell>
extends AHashMap<K, V> {
    private final Ref<AHashMap<K, V>>[] children;
    private static final int FANOUT = 16;
    private final int shift;
    private final short mask;
    public static int MAX_ENCODING_LENGTH = 2244;

    private MapTree(Ref<AHashMap<K, V>>[] blocks, int shift, short mask, long count) {
        super(count);
        this.children = blocks;
        this.shift = shift;
        this.mask = mask;
    }

    private static <K extends ACell, V extends ACell> long computeCount(Ref<AHashMap<K, V>>[] children) {
        long n = 0L;
        for (Ref<AHashMap<K, V>> cref : children) {
            if (cref == null) continue;
            AMap m = cref.getValue();
            n += m.count();
        }
        return n;
    }

    public static <K extends ACell, V extends ACell> MapTree<K, V> create(MapEntry<K, V>[] newEntries, int shift) {
        int n = newEntries.length;
        if (n <= 8) {
            throw new IllegalArgumentException("Insufficient distinct entries for TreeMap construction: " + newEntries.length);
        }
        Ref[] children = new Ref[16];
        for (int i = 0; i < n; ++i) {
            MapEntry<K, V> e = newEntries[i];
            int ix = e.getKeyHash().getHexDigit(shift);
            Ref ref = children[ix];
            if (ref == null) {
                children[ix] = MapLeaf.create(e).getRef();
                continue;
            }
            AHashMap<K, V> newChild = ((AHashMap)ref.getValue()).assocEntry(e, shift + 1);
            children[ix] = newChild.getRef();
        }
        return (MapTree)MapTree.createFull(children, shift);
    }

    private static <K extends ACell, V extends ACell> AHashMap<K, V> createFull(Ref<AHashMap<K, V>>[] children, int shift, long count) {
        if (children.length != 16) {
            throw new IllegalArgumentException("16 children required!");
        }
        Ref[] newChildren = Utils.filterArray(children, a -> {
            if (a == null) {
                return false;
            }
            AMap m = (AMap)a.getValue();
            return m != null && !m.isEmpty();
        });
        if (children != newChildren) {
            return MapTree.create(newChildren, shift, Utils.computeMask(children, newChildren), count);
        }
        return MapTree.create(children, shift, (short)-1, count);
    }

    private static <K extends ACell, V extends ACell> AHashMap<K, V> createFull(Ref<AHashMap<K, V>>[] newChildren, int shift) {
        return MapTree.createFull(newChildren, shift, MapTree.computeCount(newChildren));
    }

    private static <K extends ACell, V extends ACell> AHashMap<K, V> create(Ref<AHashMap<K, V>>[] children, int shift, short mask, long count) {
        int cLen = children.length;
        if (Integer.bitCount(mask & 0xFFFF) != cLen) {
            throw new IllegalArgumentException("Invalid child array length " + cLen + " for bit mask " + Utils.toHexString(mask));
        }
        if (count <= 8L) {
            MapEntry[] entries = new MapEntry[Utils.checkedInt(count)];
            int ix = 0;
            for (Ref<AHashMap<K, V>> childRef : children) {
                AMap child = childRef.getValue();
                long cc = child.count();
                for (long i = 0L; i < cc; ++i) {
                    entries[ix++] = child.entryAt(i);
                }
            }
            assert ((long)ix == count);
            return MapLeaf.create(entries);
        }
        int sel = (1 << cLen) - 1;
        short newMask = mask;
        for (int i = 0; i < cLen; ++i) {
            AMap child = children[i].getValue();
            if (!child.isEmpty()) continue;
            newMask = (short)(newMask & ~(1 << MapTree.digitForIndex(i, mask)));
            sel &= ~(1 << i);
        }
        if (mask != newMask) {
            return new MapTree<K, V>(Utils.filterSmallArray(children, sel), shift, newMask, count);
        }
        return new MapTree<K, V>(children, shift, mask, count);
    }

    @Override
    public MapEntry<K, V> getEntry(ACell k) {
        return this.getKeyRefEntry(Ref.get(k));
    }

    @Override
    public MapEntry<K, V> getKeyRefEntry(Ref<ACell> ref) {
        Hash h = ref.getHash();
        int digit = h.getHexDigit(this.shift);
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            return null;
        }
        return this.children[i].getValue().getKeyRefEntry(ref);
    }

    @Override
    public boolean containsValue(ACell value) {
        for (Ref<AHashMap<K, V>> b : this.children) {
            if (!b.getValue().containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(ACell key) {
        MapEntry<K, V> me = this.getKeyRefEntry(Ref.get(key));
        if (me == null) {
            return null;
        }
        return (V)me.getValue();
    }

    @Override
    public MapEntry<K, V> entryAt(long i) {
        long pos = i;
        for (Ref<AHashMap<K, V>> c : this.children) {
            AHashMap<K, V> child = c.getValue();
            long cc = child.count();
            if (pos < cc) {
                return child.entryAt(pos);
            }
            pos -= cc;
        }
        throw new IndexOutOfBoundsException((int)i);
    }

    @Override
    protected MapEntry<K, V> getEntryByHash(Hash hash) {
        int digit = hash.getHexDigit(this.shift);
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            return null;
        }
        return this.children[i].getValue().getEntryByHash(hash);
    }

    @Override
    public AHashMap<K, V> dissoc(ACell key) {
        return this.dissocRef(Ref.get(key));
    }

    @Override
    public AHashMap<K, V> dissocRef(Ref<K> keyRef) {
        AHashMap<K, V> newChild;
        int digit = keyRef.getHash().getHexDigit(this.shift);
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            return this;
        }
        AHashMap<K, V> child = this.children[i].getValue();
        if (child == (newChild = child.dissocRef(keyRef))) {
            return this;
        }
        if (this.count - 1L == 8L) {
            Set eset = this.entrySet();
            boolean removed = eset.removeIf(e -> Utils.equals(((MapEntry)e).getKeyRef(), keyRef));
            if (!removed) {
                throw new Panic("Expected to remove at least one entry!");
            }
            return MapLeaf.create(((HashSet)eset).toArray(MapLeaf.EMPTY_ENTRIES));
        }
        if (newChild.isEmpty()) {
            return this.dissocChild(i);
        }
        return this.replaceChild(i, newChild.getRef());
    }

    private AHashMap<K, V> dissocChild(int i) {
        int bsize = this.children.length;
        AHashMap<K, V> child = this.children[i].getValue();
        Ref[] newBlocks = new Ref[bsize - 1];
        System.arraycopy(this.children, 0, newBlocks, 0, i);
        System.arraycopy(this.children, i + 1, newBlocks, i, bsize - i - 1);
        short newMask = (short)(this.mask & ~(1 << MapTree.digitForIndex(i, this.mask)));
        long newCount = this.count - child.count();
        return MapTree.create(newBlocks, this.shift, newMask, newCount);
    }

    private MapTree<K, V> insertChild(int digit, Ref<AHashMap<K, V>> newChild) {
        int bsize = this.children.length;
        int i = Bits.positionForDigit(digit, this.mask);
        short newMask = (short)(this.mask | 1 << digit);
        if (this.mask == newMask) {
            throw new Panic("Digit already present!");
        }
        Ref[] newChildren = new Ref[bsize + 1];
        System.arraycopy(this.children, 0, newChildren, 0, i);
        System.arraycopy(this.children, i, newChildren, i + 1, bsize - i);
        newChildren[i] = newChild;
        long newCount = this.count + newChild.getValue().count();
        return (MapTree)MapTree.create(newChildren, this.shift, newMask, newCount);
    }

    private MapTree<K, V> replaceChild(int i, Ref<AHashMap<K, V>> newChild) {
        if (this.children[i] == newChild) {
            return this;
        }
        AHashMap<K, V> oldChild = this.children[i].getValue();
        Ref[] newChildren = (Ref[])this.children.clone();
        newChildren[i] = newChild;
        long newCount = this.count + newChild.getValue().count() - oldChild.count();
        return (MapTree)MapTree.create(newChildren, this.shift, this.mask, newCount);
    }

    public static int digitForIndex(int index, short mask) {
        int found = 0;
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0 || found++ != index) continue;
            return i;
        }
        throw new IllegalArgumentException("Index " + index + " not available in mask map: " + Utils.toHexString(mask));
    }

    @Override
    public MapTree<K, V> assoc(ACell key, ACell value) {
        ACell k = key;
        Ref<ACell> keyRef = Ref.get(k);
        return this.assocRef(keyRef, value, this.shift);
    }

    @Override
    public MapTree<K, V> assocRef(Ref<K> keyRef, V value) {
        return this.assocRef((Ref)keyRef, (ACell)value, this.shift);
    }

    @Override
    protected MapTree<K, V> assocRef(Ref<K> keyRef, V value, int shift) {
        if (this.shift != shift) {
            throw new Panic("Invalid shift!");
        }
        int digit = keyRef.getHash().getHexDigit(shift);
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            MapLeaf<K, V> newChild = MapLeaf.create(MapEntry.createRef(keyRef, Ref.get(value)));
            return this.insertChild(digit, newChild.getRef());
        }
        AHashMap<K, V> child = this.children[i].getValue();
        AHashMap<K, V> newChild = child.assocRef(keyRef, value, shift + 1);
        return this.replaceChild(i, newChild.getRef());
    }

    @Override
    public AHashMap<K, V> assocEntry(MapEntry<K, V> e) {
        assert (this.shift == 0);
        return this.assocEntry((MapEntry)e, 0);
    }

    @Override
    public MapTree<K, V> assocEntry(MapEntry<K, V> e, int shift) {
        AHashMap<K, V> newChild;
        assert (this.shift == shift);
        Ref<K> keyRef = e.getKeyRef();
        int digit = keyRef.getHash().getHexDigit(shift);
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            MapLeaf<K, V> newChild2 = MapLeaf.create(e);
            return this.insertChild(digit, newChild2.getRef());
        }
        AHashMap<K, V> child = this.children[i].getValue();
        if (child == (newChild = child.assocEntry(e, shift + 1))) {
            return this;
        }
        return this.replaceChild(i, newChild.getRef());
    }

    @Override
    public Set<K> keySet() {
        int len = this.size();
        HashSet h = new HashSet(len);
        this.accumulateKeySet(h);
        return h;
    }

    @Override
    protected void accumulateKeySet(Set<K> h) {
        for (Ref<AHashMap<K, V>> mr : this.children) {
            mr.getValue().accumulateKeySet(h);
        }
    }

    @Override
    protected void accumulateValues(List<V> al) {
        for (Ref<AHashMap<K, V>> mr : this.children) {
            mr.getValue().accumulateValues(al);
        }
    }

    @Override
    protected void accumulateEntrySet(Set<Map.Entry<K, V>> h) {
        for (Ref<AHashMap<K, V>> mr : this.children) {
            mr.getValue().accumulateEntrySet(h);
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -126;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int ilength = this.children.length;
        pos = Format.writeVLCLong(bs, pos, this.count);
        bs[pos++] = (byte)this.shift;
        pos = Utils.writeShort(bs, pos, this.mask);
        for (int i = 0; i < ilength; ++i) {
            pos = this.children[i].encode(bs, pos);
        }
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 4 + 140 * this.children.length;
    }

    public static <K extends ACell, V extends ACell> MapTree<K, V> read(Blob b, int pos, long count) throws BadFormatException {
        int epos = pos + 1 + Format.getVLCLength(count);
        byte shift = b.byteAt(epos);
        short mask = b.shortAt(epos + 1);
        epos += 3;
        int ilength = Integer.bitCount(mask & 0xFFFF);
        Ref[] blocks = new Ref[ilength];
        for (int i = 0; i < ilength; ++i) {
            Ref ref = Format.readRef(b, epos);
            epos = (int)((long)epos + ref.getEncodingLength());
            blocks[i] = ref;
        }
        MapTree<K, V> result = new MapTree<K, V>(blocks, shift, mask, count);
        if (!result.isValidStructure()) {
            throw new BadFormatException("Problem with TreeMap invariants");
        }
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Ref<AHashMap<K, V>> sub : this.children) {
            sub.getValue().forEach(action);
        }
    }

    @Override
    public boolean isCanonical() {
        return this.count > 8L;
    }

    @Override
    public final boolean isCVMValue() {
        return this.shift == 0;
    }

    @Override
    public final boolean isDataValue() {
        return this.shift == 0;
    }

    @Override
    public int getRefCount() {
        return this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.children[i];
    }

    @Override
    public MapTree<K, V> updateRefs(IRefFunction func) {
        int n = this.children.length;
        if (n == 0) {
            return this;
        }
        Ref<AHashMap<K, V>>[] newChildren = this.children;
        for (int i = 0; i < n; ++i) {
            Ref<AHashMap<K, V>> child = this.children[i];
            Ref<?> newChild = func.apply(child);
            if (child == newChild) continue;
            if (this.children == newChildren) {
                newChildren = (Ref[])this.children.clone();
            }
            newChildren[i] = newChild;
        }
        if (newChildren == this.children) {
            return this;
        }
        MapTree<K, V> result = new MapTree<K, V>(newChildren, this.shift, this.mask, this.count);
        result.attachEncoding(this.encoding);
        return result;
    }

    @Override
    public AHashMap<K, V> mergeWith(AHashMap<K, V> b, MergeFunction<V> func) {
        return this.mergeWith(b, func, this.shift);
    }

    @Override
    protected AHashMap<K, V> mergeWith(AHashMap<K, V> b, MergeFunction<V> func, int shift) {
        if (b instanceof MapTree) {
            MapTree bt = (MapTree)b;
            if (this.shift != bt.shift) {
                throw new Panic("Misaligned shifts!");
            }
            return this.mergeWith(bt, func, shift);
        }
        if (b instanceof MapLeaf) {
            return this.mergeWith((MapLeaf)b, func, shift);
        }
        throw new Panic("Unrecognised map type: " + String.valueOf(b.getClass()));
    }

    @Override
    private AHashMap<K, V> mergeWith(MapTree<K, V> b, MergeFunction<V> func, int shift) {
        assert (b.shift == shift);
        int fullMask = this.mask | b.mask;
        Ref[] newChildren = null;
        for (int digit = 0; digit < 16; ++digit) {
            AHashMap<K, V> bc;
            AHashMap<K, V> rc;
            int bitMask = 1 << digit;
            if ((fullMask & bitMask) == 0) continue;
            AHashMap<K, V> ac = this.childForDigit(digit).getValue();
            if (ac != (rc = ac.mergeWith(bc = b.childForDigit(digit).getValue(), func, shift + 1)) && newChildren == null) {
                newChildren = new Ref[16];
                for (int ii = 0; ii < digit; ++ii) {
                    int chi = Bits.indexForDigit(ii, this.mask);
                    if (chi < 0) continue;
                    newChildren[ii] = this.children[chi];
                }
            }
            if (newChildren == null) continue;
            newChildren[digit] = rc.getRef();
        }
        if (newChildren == null) {
            return this;
        }
        return MapTree.createFull(newChildren, shift);
    }

    @Override
    private AHashMap<K, V> mergeWith(MapLeaf<K, V> b, MergeFunction<V> func, int shift) {
        Ref[] newChildren = null;
        int ix = 0;
        for (int i = 0; i < 16; ++i) {
            MapLeaf<K, V> bSubset;
            AHashMap<K, V> newChild;
            Ref<AHashMap<K, V>> cref;
            AHashMap<K, V> child;
            int imask = 1 << i;
            if ((this.mask & imask) == 0) continue;
            if ((child = (cref = this.children[ix++]).getValue()) != (newChild = child.mergeWith(bSubset = b.filterHexDigits(shift, imask), func, shift + 1)) && newChildren == null) {
                newChildren = new Ref[16];
                for (int ii = 0; ii < this.children.length; ++ii) {
                    int chi = MapTree.digitForIndex(ii, this.mask);
                    newChildren[chi] = this.children[ii];
                }
            }
            if (newChildren == null) continue;
            newChildren[i] = newChild.getRef();
        }
        assert (ix == this.children.length);
        AHashMap result = newChildren == null ? this : MapTree.createFull(newChildren, shift);
        MapLeaf<K, V> extras = b.filterHexDigits(shift, ~this.mask);
        int en = extras.size();
        for (int i = 0; i < en; ++i) {
            MapEntry<K, V> e = extras.entryAt(i);
            ACell value = (ACell)func.merge(null, e.getValue());
            if (value == null) continue;
            result = ((AHashMap)result).assocEntry(e.withValue(value), shift);
        }
        return result;
    }

    @Override
    public AHashMap<K, V> mergeDifferences(AHashMap<K, V> b, MergeFunction<V> func) {
        return this.mergeDifferences(b, func, 0);
    }

    @Override
    protected AHashMap<K, V> mergeDifferences(AHashMap<K, V> b, MergeFunction<V> func, int shift) {
        if (b instanceof MapTree) {
            MapTree bt = (MapTree)b;
            if (this.shift != bt.shift) {
                throw new Panic("Misaligned shifts!");
            }
            return this.mergeDifferences(bt, func, shift);
        }
        return this.mergeDifferences((MapLeaf)b, func, shift);
    }

    @Override
    private AHashMap<K, V> mergeDifferences(MapTree<K, V> b, MergeFunction<V> func, int shift) {
        if (this.equals(b)) {
            return this;
        }
        int fullMask = this.mask | b.mask;
        Ref[] newChildren = null;
        for (int i = 0; i < 16; ++i) {
            AHashMap<K, V> bc;
            Ref<AHashMap<K, V>> bref;
            Ref<AHashMap<K, V>> aref;
            int bitMask = 1 << i;
            if ((fullMask & bitMask) == 0 || (aref = this.childForDigit(i)).equals(bref = b.childForDigit(i))) continue;
            AHashMap<K, V> ac = aref.getValue();
            AHashMap<K, V> newChild = ac.mergeDifferences(bc = bref.getValue(), func, shift + 1);
            if (newChild != ac && newChildren == null) {
                newChildren = new Ref[16];
                for (int ii = 0; ii < 16; ++ii) {
                    int chi = Bits.indexForDigit(ii, this.mask);
                    if (chi < 0) continue;
                    newChildren[ii] = this.children[chi];
                }
            }
            if (newChildren == null) continue;
            newChildren[i] = newChild == bc ? bref : newChild.getRef();
        }
        if (newChildren == null) {
            return this;
        }
        return MapTree.createFull(newChildren, shift);
    }

    @Override
    private AHashMap<K, V> mergeDifferences(MapLeaf<K, V> b, MergeFunction<V> func, int shift) {
        Ref[] newChildren = null;
        int ix = 0;
        for (int i = 0; i < 16; ++i) {
            MapLeaf<K, V> bSubset;
            AHashMap<K, V> newChild;
            Ref<AHashMap<K, V>> cref;
            AHashMap<K, V> child;
            int imask = 1 << i;
            if ((this.mask & imask) == 0) continue;
            if ((child = (cref = this.children[ix++]).getValue()) != (newChild = child.mergeDifferences(bSubset = b.filterHexDigits(shift, imask), func, shift + 1)) && newChildren == null) {
                newChildren = new Ref[16];
                for (int ii = 0; ii < this.children.length; ++ii) {
                    int chi = MapTree.digitForIndex(ii, this.mask);
                    newChildren[chi] = this.children[ii];
                }
            }
            if (newChildren == null) continue;
            newChildren[i] = newChild.getRef();
        }
        assert (ix == this.children.length);
        AHashMap result = newChildren == null ? this : MapTree.createFull(newChildren, shift);
        MapLeaf<K, V> extras = b.filterHexDigits(shift, ~this.mask);
        int en = extras.size();
        for (int i = 0; i < en; ++i) {
            MapEntry<K, V> e = extras.entryAt(i);
            ACell value = (ACell)func.merge(null, e.getValue());
            if (value == null) continue;
            result = ((AHashMap)result).assocEntry(e.withValue(value), shift);
        }
        return result;
    }

    private Ref<AHashMap<K, V>> childForDigit(int digit) {
        int ix = Bits.indexForDigit(digit, this.mask);
        if (ix < 0) {
            return Maps.emptyRef();
        }
        return this.children[ix];
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> func, R initial) {
        int n = this.children.length;
        R result = initial;
        for (int i = 0; i < n; ++i) {
            result = this.children[i].getValue().reduceValues(func, result);
        }
        return result;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> func, R initial) {
        int n = this.children.length;
        R result = initial;
        for (int i = 0; i < n; ++i) {
            result = this.children[i].getValue().reduceEntries(func, result);
        }
        return result;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof MapTree)) {
            return false;
        }
        return this.equals((MapTree)a);
    }

    boolean equals(MapTree<K, V> b) {
        if (b == null) {
            return false;
        }
        if (this == b) {
            return true;
        }
        long n = this.count;
        if (n != b.count) {
            return false;
        }
        if (this.mask != b.mask) {
            return false;
        }
        if (this.shift != b.shift) {
            return false;
        }
        return this.getHash().equals(b.getHash());
    }

    @Override
    public AHashMap<K, V> mapEntries(Function<MapEntry<K, V>, MapEntry<K, V>> func) {
        int n = this.children.length;
        if (n == 0) {
            return this;
        }
        Ref<AHashMap<K, V>>[] newChildren = this.children;
        for (int i = 0; i < n; ++i) {
            AHashMap<K, V> newChild;
            AHashMap<K, V> child = this.children[i].getValue();
            if (child == (newChild = child.mapEntries(func))) continue;
            if (this.children == newChildren) {
                newChildren = (Ref[])this.children.clone();
            }
            newChildren[i] = newChild.getRef();
        }
        if (newChildren == this.children) {
            return this;
        }
        return MapTree.create(newChildren, this.shift, this.mask, MapTree.computeCount(newChildren));
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.isCVMValue()) {
            this.validateWithPrefix("");
        }
    }

    @Override
    protected void validateWithPrefix(String prefix) throws InvalidDataException {
        if (this.mask == 0) {
            throw new InvalidDataException("TreeMap must have children!", this);
        }
        if (this.shift != prefix.length()) {
            throw new InvalidDataException("Invalid prefix [" + prefix + "] for TreeMap with shift=" + this.shift, this);
        }
        int bsize = this.children.length;
        long childCount = 0L;
        for (int i = 0; i < bsize; ++i) {
            if (this.children[i] == null) {
                throw new InvalidDataException("Null child ref at " + prefix + Utils.toHexChar(MapTree.digitForIndex(i, this.mask)), this);
            }
            AHashMap<K, V> o = this.children[i].getValue();
            if (!(o instanceof AHashMap)) {
                throw new InvalidDataException("Expected map child at " + prefix + Utils.toHexChar(MapTree.digitForIndex(i, this.mask)), this);
            }
            AHashMap<K, V> child = o;
            if (child.isEmpty()) {
                throw new InvalidDataException("Empty child at " + prefix + Utils.toHexChar(MapTree.digitForIndex(i, this.mask)), this);
            }
            int d = MapTree.digitForIndex(i, this.mask);
            child.validateWithPrefix(prefix + Utils.toHexChar(d));
            childCount += child.count();
        }
        if (this.count != childCount) {
            throw new InvalidDataException("Bad child count, expected " + this.count + " but children had: " + childCount, this);
        }
    }

    private boolean isValidStructure() {
        if (this.count <= 8L) {
            return false;
        }
        if (this.children.length != Integer.bitCount(this.mask & 0xFFFF)) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!this.isValidStructure()) {
            throw new InvalidDataException("Bad structure", this);
        }
    }

    @Override
    public boolean containsAllKeys(AHashMap<K, V> map) {
        if (map instanceof MapTree) {
            return this.containsAllKeys((MapTree)map);
        }
        long n = map.count;
        for (long i = 0L; i < n; ++i) {
            MapEntry me = map.entryAt(i);
            if (this.containsKeyRef(me.getKeyRef())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean containsAllKeys(MapTree<K, V> map) {
        if ((this.mask | map.mask) != this.mask) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            Ref<AHashMap<K, V>> mchild;
            Ref<AHashMap<K, V>> child = this.childForDigit(i);
            if (child == null || (mchild = map.childForDigit(i)) == null || child.getValue().containsAllKeys(mchild.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte getTag() {
        return -126;
    }

    @Override
    public AHashMap<K, V> toCanonical() {
        if (this.count > 8L) {
            return this;
        }
        throw new TODOException();
    }

    @Override
    public AHashMap<K, V> slice(long start, long end) {
        if (start < 0L || end > this.count || end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return Maps.empty();
        }
        if (start == 0L && end == this.count) {
            return this;
        }
        if (end - start <= 8L) {
            return this.smallSlice(start, end);
        }
        long pos = 0L;
        int cc = this.children.length;
        short m = 0;
        int istart = 0;
        int iend = 0;
        Ref<AHashMap<K, V>>[] newChildren = this.children;
        for (int i = 0; i < cc; ++i) {
            AHashMap<K, V> child = this.children[i].getValue();
            long csize = child.size();
            long cend = pos + csize;
            if (cend <= start) {
                ++istart;
                ++iend;
                pos += csize;
                continue;
            }
            if (end <= cend) {
                if (i == istart) {
                    return child.slice(start - pos, end - pos);
                }
                if (end <= pos) break;
            }
            if (this.children == newChildren) {
                newChildren = (Ref[])this.children.clone();
            }
            AMap newChild = child.slice(Math.max(0L, start - pos), Math.min(csize, end - pos));
            newChildren[i] = newChild.getRef();
            m = (short)(m | (short)(1 << MapTree.digitForIndex(i, this.mask)));
            ++iend;
            pos += csize;
        }
        newChildren = Arrays.copyOfRange(newChildren, istart, iend);
        return new MapTree<K, V>(newChildren, this.shift, m, end - start);
    }

    private AHashMap<K, V> smallSlice(long start, long end) {
        int n = (int)(end - start);
        MapEntry[] items = new MapEntry[n];
        for (int i = 0; i < n; ++i) {
            items[i] = this.entryAt(start + (long)i);
        }
        return MapLeaf.unsafeCreate(items);
    }
}

