/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ALongBlob;
import convex.core.data.Blob;
import convex.core.util.Utils;
import java.security.MessageDigest;

public final class LongBlob
extends ALongBlob {
    private static final int HEADER_LENGTH = 2;
    public static final int MAX_ENCODING_LENGTH = 10;
    public static final LongBlob ZERO = LongBlob.create(0L);

    private LongBlob(long value) {
        super(value);
    }

    public static LongBlob create(String string) {
        byte[] bs = Utils.hexToBytes(string);
        int bl = bs.length;
        return new LongBlob(Utils.readLong(bs, Math.max(0, bl - 8), Math.min(8, bl)));
    }

    public static LongBlob create(long value) {
        return new LongBlob(value);
    }

    @Override
    public ABlob slice(long start, long end) {
        if (start == 0L && end == 8L) {
            return this.toFlatBlob();
        }
        if (start < 0L) {
            return null;
        }
        return this.getEncoding().slice(start + 2L, end + 2L);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        byte[] bs = this.getEncoding().getInternalArray();
        digest.update(bs, 2, 8);
    }

    @Override
    public long hexMatch(ABlobLike<?> b) {
        if (b == this) {
            return 16L;
        }
        long max = Math.min(8L, b.count());
        for (long i = 0L; i < max; ++i) {
            byte bi;
            byte ai = this.byteAtUnchecked(i);
            if (ai == (bi = b.byteAtUnchecked(i))) continue;
            return i * 2L + (long)(Utils.firstDigitMatch(ai, bi) ? 1 : 0);
        }
        return max * 2L;
    }

    @Override
    public boolean equals(ABlob a) {
        if (a instanceof LongBlob) {
            return ((LongBlob)a).value == this.value;
        }
        return a.count() == 8L && a.longValue() == this.value;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = 8;
        Utils.writeLong(bs, pos, this.value);
        return pos + 8;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10;
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        if (b == this) {
            return length;
        }
        long end = start + length;
        for (long i = start; i < end; ++i) {
            if (this.getHexDigit(i) == b.getHexDigit(i)) continue;
            return i - start;
        }
        return length;
    }

    @Override
    public Blob toFlatBlob() {
        return this.getEncoding().slice(2L, 10L);
    }
}

