/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AList;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.IRefFunction;
import convex.core.data.Lists;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class List<T extends ACell>
extends AList<T> {
    public static final List<?> EMPTY = Cells.intern(List.wrap(VectorLeaf.EMPTY));
    public static final Ref<List<?>> EMPTY_REF = EMPTY.getRef();
    private AVector<T> data;

    private List(AVector<T> data) {
        super(data.count);
        this.data = data.toVector();
    }

    public static <R extends ACell> List<R> wrap(AVector<R> vector) {
        return new List<R>(vector);
    }

    public static <T extends ACell> List<T> reverse(AVector<T> vector) {
        if (vector.isEmpty()) {
            return Lists.empty();
        }
        return new List<T>(vector);
    }

    public static <T extends ACell> List<T> of(Object ... elements) {
        if (elements.length == 0) {
            return Lists.empty();
        }
        Utils.reverse(elements);
        return new List(Vectors.of(elements));
    }

    public static <T extends ACell> List<T> create(ACell ... args) {
        if (args.length == 0) {
            return Lists.empty();
        }
        Utils.reverse(args);
        return new List(Vectors.create(args));
    }

    @Override
    public Object[] toArray() {
        Object[] arr = this.data.toArray();
        Utils.reverse(arr, this.size());
        return arr;
    }

    @Override
    public <V> V[] toArray(V[] a) {
        V[] arr = this.data.toArray(a);
        Utils.reverse(arr, this.size());
        return arr;
    }

    @Override
    public T get(long index) {
        return this.data.get(this.count - 1L - index);
    }

    @Override
    public Ref<T> getElementRef(long i) {
        return this.data.getElementRef(this.count - 1L - i);
    }

    @Override
    public AList<T> assoc(long i, T value) {
        ASequence newData = this.data.assoc(this.count - 1L - i, (ACell)value);
        if (this.data == newData) {
            return this;
        }
        if (newData == null) {
            return null;
        }
        return new List<T>(newData);
    }

    @Override
    public int indexOf(Object o) {
        int pos = this.data.lastIndexOf(o);
        if (pos < 0) {
            return -1;
        }
        return this.size() - 1 - pos;
    }

    @Override
    public int lastIndexOf(Object o) {
        int pos = this.data.indexOf(o);
        if (pos < 0) {
            return -1;
        }
        return this.size() - 1 - pos;
    }

    @Override
    public long longIndexOf(Object o) {
        long pos = this.data.longLastIndexOf(o);
        if (pos < 0L) {
            return -1L;
        }
        return this.count - 1L - pos;
    }

    @Override
    public long longLastIndexOf(Object o) {
        long pos = this.data.longIndexOf(o);
        if (pos < 0L) {
            return -1L;
        }
        return this.count - 1L - pos;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new MyListIterator(0L);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new MyListIterator(index);
    }

    @Override
    public ListIterator<T> listIterator(long index) {
        return new MyListIterator(index);
    }

    @Override
    public int getRefCount() {
        return this.data.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.data.getRef(i);
    }

    @Override
    public List<T> updateRefs(IRefFunction func) {
        ACell newData = this.data.updateRefs(func);
        if (newData == this.data) {
            return this;
        }
        return new List<T>(newData);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append('(');
        long n = this.count;
        for (long i = 0L; i < n; ++i) {
            if (i > 0L) {
                bb.append(' ');
            }
            if (RT.print(bb, this.data.get(n - 1L - i), limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -127;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.data.encodeRaw(bs, pos);
        return pos;
    }

    public static <T extends ACell> List<T> read(Blob b, int pos) throws BadFormatException {
        try {
            AVector data = Vectors.read(b, pos);
            if (data.isEmpty()) {
                return EMPTY;
            }
            List result = new List(data);
            result.attachEncoding(data.cachedEncoding());
            data.attachEncoding(null);
            return result;
        }
        catch (ClassCastException e) {
            throw new BadFormatException("Expected vector in List format", e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int estimatedEncodingSize() {
        return this.data.estimatedEncodingSize();
    }

    @Override
    public List<T> conj(ACell value) {
        return new List<T>(this.data.conj(value));
    }

    @Override
    public AList<T> cons(T x) {
        return new List<T>(this.data.conj((ACell)x));
    }

    @Override
    public List<T> conjAll(ACollection<? extends T> xs) {
        return List.reverse(this.data.conjAll((ACollection)xs));
    }

    @Override
    public AVector<T> toVector() {
        return Vectors.create(this.toCellArray());
    }

    @Override
    public AList<T> next() {
        if (this.count <= 1L) {
            return null;
        }
        return this.slice(1L, this.count);
    }

    @Override
    public AList<T> slice(long start, long end) {
        if (start == 0L && end == this.count) {
            return this;
        }
        return List.reverse(this.data.slice(this.count - end, this.count - start));
    }

    @Override
    public <R extends ACell> AList<R> map(Function<? super T, ? extends R> mapper) {
        ASequence newData = this.data.map((Function)mapper);
        if (this.data == newData) {
            return this;
        }
        return new List<T>(newData);
    }

    @Override
    public List<T> concat(ASequence<? extends T> vals) {
        ASequence rvals;
        long n = RT.count(vals);
        if (n == 0L) {
            return this;
        }
        if (vals instanceof List) {
            List vlist = (List)vals;
            if (this.count == 0L) {
                return vlist;
            }
            rvals = vlist.data;
        } else {
            rvals = Vectors.empty();
            for (long i = 0L; i < n; ++i) {
                rvals = rvals.conj((ACell)vals.get(n - i - 1L));
            }
        }
        if (this.count > 0L) {
            rvals = rvals.concat(this.data);
        }
        return List.reverse(rvals);
    }

    @Override
    public void visitElementRefs(Consumer<Ref<T>> f) {
        this.data.visitElementRefs(f);
    }

    @Override
    public AVector<T> subVector(long start, long length) {
        if (!this.checkRange(start, start + length)) {
            return null;
        }
        if (length == 0L) {
            return Vectors.empty();
        }
        ACell[] arr = new ACell[Utils.checkedInt(length)];
        int i = 0;
        while ((long)i < length) {
            arr[i] = this.get(start + (long)i);
            ++i;
        }
        return Vectors.wrap(arr);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        long dc = this.data.count();
        if (this.count != dc) {
            throw new InvalidDataException("Bad data count " + this.count + " with underlying data count " + dc, this);
        }
        this.data.validateCell();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.data.forEach(action);
    }

    @Override
    public AList<T> drop(long n) {
        if (n == 0L) {
            return this;
        }
        long newLen = this.count - n;
        if (newLen < 0L) {
            return null;
        }
        if (newLen == 0L) {
            return Lists.empty();
        }
        return new List<T>(this.data.slice(0L, newLen));
    }

    @Override
    public byte getTag() {
        return -127;
    }

    @Override
    public AVector<T> reverse() {
        return this.data;
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        int n = Utils.checkedInt(this.count);
        for (int i = 0; i < n; ++i) {
            arr[offset + i] = this.get(offset + i);
        }
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public boolean equals(ACell o) {
        if (!(o instanceof List)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        List b = (List)o;
        return this.data.equals(b.data);
    }

    private class MyListIterator
    implements ListIterator<T> {
        private final ListIterator<T> dataIterator;

        public MyListIterator(long pos) {
            this.dataIterator = List.this.data.listIterator(List.this.count - pos);
        }

        @Override
        public boolean hasNext() {
            return this.dataIterator.hasPrevious();
        }

        @Override
        public T next() {
            return (ACell)this.dataIterator.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.dataIterator.hasNext();
        }

        @Override
        public T previous() {
            return (ACell)this.dataIterator.next();
        }

        @Override
        public int nextIndex() {
            return Utils.checkedInt(List.this.count - 1L - (long)this.dataIterator.previousIndex());
        }

        @Override
        public int previousIndex() {
            return Utils.checkedInt(List.this.count - 1L - (long)this.dataIterator.nextIndex());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }
    }
}

