/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AIndex;
import convex.core.data.AMap;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Bits;
import convex.core.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class Index<K extends ABlobLike<?>, V extends ACell>
extends AIndex<K, V> {
    public static final Ref<Index>[] EMPTY_CHILDREN = new Ref[0];
    private static final int MAX_DEPTH = 64;
    private static final int MAX_KEY_BYTES = 32;
    public static final Index<?, ?> EMPTY = Cells.intern(new Index(0L, null, EMPTY_CHILDREN, 0, 0L));
    private final Ref<Index<K, V>>[] children;
    private final MapEntry<K, V> entry;
    private final short mask;
    private final long depth;

    protected Index(long depth, MapEntry<K, V> entry, Ref<Index>[] entries, short mask, long count) {
        super(count);
        this.depth = depth;
        this.entry = entry;
        this.children = entries;
        this.mask = mask;
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> unsafeCreate(long depth, MapEntry<K, V> entry, Ref<Index>[] entries, int mask, long count) {
        return new Index<K, V>(depth, entry, entries, (short)mask, count);
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> create(MapEntry<K, V> me) {
        Object k = me.getKey();
        if (!(k instanceof ABlobLike)) {
            return null;
        }
        long depth = Index.effectiveLength((ABlobLike)k);
        return new Index<K, V>(depth, me, EMPTY_CHILDREN, 0, 1L);
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> create(K k, V v) {
        MapEntry<K, V> me = MapEntry.create(k, v);
        long hexLength = Index.effectiveLength(k);
        return new Index<K, V>(hexLength, me, EMPTY_CHILDREN, 0, 1L);
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> of(Object k, Object v) {
        return Index.create((ABlobLike)RT.cvm(k), RT.cvm(v));
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> of(Object ... kvs) {
        int n = kvs.length;
        if (Utils.isOdd(n)) {
            throw new IllegalArgumentException("Even number of key + values required");
        }
        AIndex result = EMPTY;
        for (int i = 0; i < n; i += 2) {
            Object value = RT.cvm(kvs[i + 1]);
            result = result.assoc((ABlobLike)kvs[i], (ACell)value);
        }
        return result;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public boolean isDataValue() {
        return true;
    }

    @Override
    public Index<K, V> updateRefs(IRefFunction func) {
        MapEntry<K, V> newEntry = Ref.update(this.entry, func);
        Ref<Index<K, V>>[] newChildren = Ref.updateRefs(this.children, func);
        if (this.entry == newEntry && this.children == newChildren) {
            return this;
        }
        Index<K, V> result = new Index<K, V>(this.depth, newEntry, newChildren, this.mask, this.count);
        result.attachEncoding(this.encoding);
        return result;
    }

    @Override
    public V get(K key) {
        MapEntry<K, V> me = this.getEntry(key);
        if (me == null) {
            return null;
        }
        return (V)me.getValue();
    }

    @Override
    public MapEntry<K, V> getEntry(K key) {
        long pl;
        long kl = ((ABlobLike)key).hexLength();
        if (kl < (pl = this.depth)) {
            return null;
        }
        if (kl == pl) {
            ABlobLike ekey;
            if (this.entry != null && Index.keyMatch(key, ekey = (ABlobLike)this.entry.getKey())) {
                return this.entry;
            }
            if (pl < 64L) {
                return null;
            }
        }
        if (pl == 64L) {
            if (this.entry == null) {
                return null;
            }
            if (((ABlobLike)key).hexMatch(((ABlobLike)this.entry.getKey()).toBlob(), 0L, 64L) == 64L) {
                return this.entry;
            }
            return null;
        }
        int digit = ((ABlobLike)key).getHexDigit(pl);
        Index<K, V> cc = this.getChild(digit);
        if (cc == null) {
            return null;
        }
        return cc.getEntry(key);
    }

    private Index<K, V> getChild(int digit) {
        int i = Bits.indexForDigit(digit, this.mask);
        if (i < 0) {
            return null;
        }
        return this.children[i].getValue();
    }

    @Override
    public int getRefCount() {
        return Cells.refCount(this.entry) + this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int cl;
        if (this.entry != null) {
            int erc = this.entry.getRefCount();
            if (i < erc) {
                return this.entry.getRef(i);
            }
            i -= erc;
        }
        if (i < (cl = this.children.length)) {
            return this.children[i];
        }
        throw new IndexOutOfBoundsException("No ref for index:" + i);
    }

    @Override
    public Index<K, V> assoc(ACell key, ACell value) {
        if (!(key instanceof ABlobLike)) {
            return null;
        }
        return this.assocEntry((MapEntry)MapEntry.create((ABlobLike)key, value));
    }

    @Override
    public Index<K, V> dissoc(K k) {
        if (this.count <= 1L) {
            if (this.count == 0L) {
                return this;
            }
            if (Index.keyMatch(k, (ABlobLike)this.entry.getKey())) {
                return this.empty();
            }
            return this;
        }
        long pDepth = this.depth;
        long kl = Index.effectiveLength(k);
        if (kl < pDepth) {
            return this;
        }
        if (kl == pDepth) {
            if (this.entry == null) {
                return this;
            }
            if (!Index.keyMatch(k, (ABlobLike)this.entry.getKey())) {
                return this;
            }
            if (this.children.length == 1) {
                Index<K, V> c = this.children[0].getValue();
                return c;
            }
            return new Index<K, V>(this.depth, null, this.children, this.mask, this.count - 1L);
        }
        int digit = ((ABlobLike)k).getHexDigit(pDepth);
        int childIndex = Bits.indexForDigit(digit, this.mask);
        if (childIndex < 0) {
            return this;
        }
        Index<K, V> oldChild = this.children[childIndex].getValue();
        AIndex newChild = oldChild.dissoc((ABlobLike)k);
        Index<K, V> r = this.withChild(digit, oldChild, (Index<K, V>)newChild);
        return r;
    }

    public static <K extends ABlobLike<?>> boolean keyMatch(K a, K b) {
        long n = a.count();
        if (n < 32L) {
            return a.equalsBytes(b.toBlob());
        }
        if (b.count() < 32L) {
            return false;
        }
        return a.hexMatch(b.toBlob(), 0L, 64L) == 64L;
    }

    private ABlobLike<?> getPrefix() {
        if (this.entry != null) {
            return (ABlobLike)this.entry.getKey();
        }
        int n = this.children.length;
        if (n == 0) {
            return Blob.EMPTY;
        }
        return this.children[0].getValue().getPrefix();
    }

    @Override
    protected void accumulateEntrySet(Set<Map.Entry<K, V>> h) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateEntrySet(h);
        }
        if (this.entry != null) {
            h.add(this.entry);
        }
    }

    @Override
    protected void accumulateKeySet(Set<K> h) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateKeySet(h);
        }
        if (this.entry != null) {
            h.add((ABlobLike)this.entry.getKey());
        }
    }

    @Override
    protected void accumulateValues(List<V> al) {
        if (this.entry != null) {
            al.add(this.entry.getValue());
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().accumulateValues(al);
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.entry != null) {
            action.accept(this.entry.getKey(), this.entry.getValue());
        }
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().forEach(action);
        }
    }

    @Override
    public Index<K, V> assocEntry(MapEntry<K, V> e) {
        return this.assocEntry(e, 0L);
    }

    private Index<K, V> assocEntry(MapEntry<K, V> e, long match) {
        Object maybeValidKey;
        if (this.count == 0L) {
            return Index.create(e);
        }
        if (this.count == 1L) {
            assert (this.mask == 0);
            if (this.entry.keyEquals(e)) {
                if (this.entry == e) {
                    return this;
                }
                return Index.create(e);
            }
        }
        if (!((maybeValidKey = e.getKey()) instanceof ABlobLike)) {
            return null;
        }
        ABlobLike k = (ABlobLike)maybeValidKey;
        long newKeyLength = Index.effectiveLength(k);
        ABlobLike<?> prefix = this.getPrefix();
        long mkl = newKeyLength >= this.depth ? match + k.hexMatch(prefix, match, this.depth - match) : match + k.hexMatch(prefix, match, newKeyLength - match);
        if (mkl < this.depth) {
            int d2;
            if (mkl == newKeyLength) {
                int splitDigit = prefix.getHexDigit(mkl);
                short splitMask = (short)(1 << splitDigit);
                Index<K, V> result = new Index<K, V>(mkl, e, new Ref[]{this.getRef()}, splitMask, this.count + 1L);
                return result;
            }
            Index<K, V> branch1 = this;
            Index<K, V> branch2 = Index.create(e);
            int d1 = prefix.getHexDigit(mkl);
            if (d1 > (d2 = k.getHexDigit(mkl))) {
                Index<K, V> temp = branch1;
                branch1 = branch2;
                branch2 = temp;
            }
            Ref[] newChildren = new Ref[]{branch1.getRef(), branch2.getRef()};
            short newMask = (short)(1 << d1 | 1 << d2);
            Index<K, V> fork = new Index<K, V>(mkl, null, newChildren, newMask, this.count + 1L);
            return fork;
        }
        assert (newKeyLength >= this.depth);
        if (newKeyLength == this.depth) {
            if (this.entry == null) {
                return new Index<K, V>(this.depth, e, this.children, this.mask, this.count + 1L);
            }
            if (this.entry == e) {
                return this;
            }
            return new Index<K, V>(this.depth, e, this.children, this.mask, this.count);
        }
        int childDigit = k.getHexDigit(this.depth);
        Index<K, V> oldChild = this.getChild(childDigit);
        AMap newChild = oldChild == null ? Index.create(e) : oldChild.assocEntry((MapEntry)e);
        return this.withChild(childDigit, oldChild, (Index<K, V>)newChild);
    }

    private Index<K, V> withChild(int childDigit, Index<K, V> oldChild, Index<K, V> newChild) {
        if (oldChild == EMPTY) {
            oldChild = null;
        }
        if (newChild == EMPTY) {
            newChild = null;
        }
        if (oldChild == newChild) {
            return this;
        }
        int n = this.children.length;
        Ref<Index<K, V>>[] newChildren = this.children;
        if (oldChild == null) {
            newChildren = new Ref[n + 1];
            int newPos = Bits.positionForDigit(childDigit, this.mask);
            short newMask = (short)(this.mask | 1 << childDigit);
            System.arraycopy(this.children, 0, newChildren, 0, newPos);
            newChildren[newPos] = newChild.getRef();
            System.arraycopy(this.children, newPos, newChildren, newPos + 1, n - newPos);
            return new Index<K, V>(this.depth, this.entry, newChildren, newMask, this.count + newChild.count());
        }
        if (newChild == null) {
            int delPos = Bits.positionForDigit(childDigit, this.mask);
            if (this.entry == null && n == 2) {
                Index<K, V> rm = this.children[1 - delPos].getValue();
                return rm;
            }
            newChildren = new Ref[n - 1];
            short newMask = (short)(this.mask & ~(1 << childDigit));
            System.arraycopy(this.children, 0, newChildren, 0, delPos);
            System.arraycopy(this.children, delPos + 1, newChildren, delPos, n - delPos - 1);
            return new Index<K, V>(this.depth, this.entry, newChildren, newMask, this.count - oldChild.count());
        }
        int childPos = Bits.positionForDigit(childDigit, this.mask);
        newChildren = (Ref[])this.children.clone();
        newChildren[childPos] = newChild.getRef();
        long newCount = this.count + newChild.count() - oldChild.count();
        return new Index<K, V>(this.depth, this.entry, newChildren, this.mask, newCount);
    }

    @Override
    public <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> func, R initial) {
        if (this.entry != null) {
            initial = func.apply(initial, this.entry.getValue());
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            initial = this.children[i].getValue().reduceValues(func, initial);
        }
        return initial;
    }

    @Override
    public <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> func, R initial) {
        if (this.entry != null) {
            initial = func.apply(initial, this.entry);
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            initial = this.children[i].getValue().reduceEntries(func, initial);
        }
        return initial;
    }

    @Override
    public Index<K, V> filterValues(Predicate<V> pred) {
        AIndex r = this;
        for (int i = 0; i < 16 && r != null; ++i) {
            Index<K, V> oldChild = r.getChild(i);
            if (oldChild == null) continue;
            AMap newChild = oldChild.filterValues((Predicate)pred);
            r = r.withChild(i, oldChild, (Index<K, V>)newChild);
        }
        if (r != null && r.entry != null && !pred.test(r.entry.getValue())) {
            r = r.dissoc((ABlobLike)r.entry.getKey());
        }
        if (r == null) {
            return this.empty();
        }
        return r;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -124;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCCount(bs, pos, this.count);
        if (this.count == 0L) {
            return pos;
        }
        pos = MapEntry.encodeCompressed(this.entry, bs, pos);
        if (this.count == 1L) {
            return pos;
        }
        pos = Format.writeVLCCount(bs, pos, this.depth);
        pos = Utils.writeShort(bs, pos, this.mask);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.encodeChild(bs, pos, i);
        }
        return pos;
    }

    private int encodeChild(byte[] bs, int pos, int i) {
        Ref<Index<K, V>> cref = this.children[i];
        return cref.encode(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 100 + (this.children.length * 2 + 1) * 140;
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> read(Blob b, int pos) throws BadFormatException {
        MapEntry me;
        byte etype;
        long count = Format.readVLCCount(b, pos + 1);
        if (count < 0L) {
            throw new BadFormatException("Negative count!");
        }
        if (count == 0L) {
            return EMPTY;
        }
        int epos = pos + 1 + Format.getVLCCountLength(count);
        if ((etype = b.byteAt(epos++)) == 0) {
            me = null;
        } else if (etype == -128) {
            Ref kr = Format.readRef(b, epos);
            epos = (int)((long)epos + kr.getEncodingLength());
            Ref vr = Format.readRef(b, epos);
            epos = (int)((long)epos + vr.getEncodingLength());
            me = MapEntry.createRef(kr, vr);
            if (count == 1L) {
                long depth = kr.isEmbedded() ? ((ABlobLike)kr.getValue()).hexLength() : 64L;
                Index result = new Index(depth, me, EMPTY_CHILDREN, 0, 1L);
                result.attachEncoding(b.slice(pos, epos));
                return result;
            }
        } else {
            throw new BadFormatException("Invalid MapEntry tag in Index: " + etype);
        }
        long depth = Format.readVLCCount(b, epos);
        if (depth < 0L) {
            throw new BadFormatException("Negative depth!");
        }
        if (depth >= 64L) {
            if (depth == 64L) {
                throw new BadFormatException("More than one entry and MAX_DEPTH");
            }
            throw new BadFormatException("Excessive depth!");
        }
        short mask = b.shortAt(epos += Format.getVLCCountLength(depth));
        epos += 2;
        int n = Utils.bitCount(mask);
        Ref[] children = new Ref[n];
        for (int i = 0; i < n; ++i) {
            Ref cr = Format.readRef(b, epos);
            epos = (int)((long)epos + cr.getEncodingLength());
            children[i] = cr;
        }
        Index result = new Index(depth, me, children, mask, count);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    protected MapEntry<K, V> getEntryByHash(Hash hash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() throws InvalidDataException {
        ABlobLike<?> prefix;
        super.validate();
        if (this.depth < 0L || this.depth > 64L) {
            throw new InvalidDataException("Invalid index depth", this);
        }
        if (this.entry != null) {
            ABlobLike k = RT.ensureBlobLike((ACell)this.entry.getKey());
            if (k == null) {
                throw new InvalidDataException("Invalid entry key type: " + Utils.getClassName(this.entry.getKey()), this);
            }
            if (this.depth != Index.effectiveLength(k)) {
                throw new InvalidDataException("Entry at inconsistent depth", this);
            }
        }
        if (this.depth > Index.effectiveLength(prefix = this.getPrefix())) {
            throw new InvalidDataException("depth longer than common prefix", this);
        }
        long ecount = this.entry == null ? 0L : 1L;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            Index<K, V> o = this.children[i].getValue();
            if (!(o instanceof Index)) {
                throw new InvalidDataException("Illegal Index child type: " + String.valueOf(Utils.getClass(o)), this);
            }
            Index<K, V> c = o;
            long ccount = c.count();
            if (ccount == 0L) {
                throw new InvalidDataException("Child " + i + " should not be empty! At depth " + this.depth, this);
            }
            if (c.getDepth() <= this.getDepth()) {
                throw new InvalidDataException("Child must have greater depth than parent", this);
            }
            ABlobLike<?> childPrefix = c.getPrefix();
            long ml = prefix.hexMatch(childPrefix, 0L, this.depth);
            if (ml < this.depth) {
                throw new InvalidDataException("Child does not have matching common prefix", this);
            }
            c.validate();
            int digit = childPrefix.getHexDigit(this.depth);
            if (i != Bits.indexForDigit(digit, this.mask)) {
                throw new InvalidDataException("Child does not have correct digit", this);
            }
            ecount += ccount;
        }
        if (this.count != ecount) {
            throw new InvalidDataException("Bad entry count: " + ecount + " expected: " + this.count, this);
        }
    }

    private static long effectiveLength(ABlobLike<?> prefix) {
        return Math.min(64L, prefix.hexLength());
    }

    long getDepth() {
        return this.depth;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count == 0L) {
            if (this != EMPTY) {
                throw new InvalidDataException("Non-singleton empty Index", this);
            }
            return;
        }
        if (this.count == 1L) {
            if (this.entry == null) {
                throw new InvalidDataException("Single entry Index with null entry?", this);
            }
            if (this.mask != 0) {
                throw new InvalidDataException("Single entry Index with child mask?", this);
            }
            return;
        }
        long pDepth = this.getDepth();
        if (pDepth > 64L) {
            throw new InvalidDataException("Excessive Prefix Depth beyond MAX_DEPTH", this);
        }
        if (pDepth == 64L && this.count != 1L) {
            throw new InvalidDataException("Can only have a single entry at MAX_DEPTH", this);
        }
        int cn = Utils.bitCount(this.mask);
        if (cn != this.children.length) {
            throw new InvalidDataException("Illegal mask: " + Utils.toHexString(this.mask) + " for given number of children: " + this.children.length, this);
        }
        if (this.entry != null) {
            this.entry.validateCell();
            long entryKeyLength = ((ABlobLike)this.entry.getKey()).hexLength();
            if (entryKeyLength < pDepth) {
                throw new InvalidDataException("Key too short for prefix depth", this);
            }
            if (entryKeyLength > 64L && pDepth != 64L) {
                throw new InvalidDataException("Key too long at this prefix depth", this);
            }
            if (cn == 0) {
                throw new InvalidDataException("Index with entry and count=" + this.count + " must have children", this);
            }
        } else if (cn <= 1) {
            throw new InvalidDataException("Index with no entry and count=" + this.count + " must have two or more children", this);
        }
    }

    @Override
    public Index<K, V> empty() {
        return EMPTY;
    }

    public static <K extends ABlobLike<?>, V extends ACell> Index<K, V> none() {
        return EMPTY;
    }

    @Override
    public MapEntry<K, V> entryAt(long ix) {
        if (this.entry != null) {
            if (ix == 0L) {
                return this.entry;
            }
            --ix;
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            Index<K, V> c = this.children[i].getValue();
            long cc = c.count();
            if (ix < cc) {
                return c.entryAt(ix);
            }
            ix -= cc;
        }
        throw new IndexOutOfBoundsException((int)ix);
    }

    @Override
    public Index<K, V> slice(long start) {
        return this.slice(start, this.count);
    }

    @Override
    public Index<K, V> slice(long start, long end) {
        MapEntry<K, V> me;
        long i;
        if (start < 0L || end > this.count) {
            return null;
        }
        if (end < start) {
            return null;
        }
        long n = end - start;
        if (n == 0L) {
            return this.empty();
        }
        if (n == this.count) {
            return this;
        }
        AIndex bm = this;
        for (i = this.count - 1L; i >= end; --i) {
            me = ((Index)bm).entryAt(i);
            bm = ((Index)bm).dissoc((ABlobLike)me.getKey());
        }
        for (i = 0L; i < start; ++i) {
            me = ((Index)bm).entryAt(0L);
            bm = ((Index)bm).dissoc((ABlobLike)me.getKey());
        }
        return bm;
    }

    @Override
    public boolean equals(ACell a) {
        if (this == a) {
            return true;
        }
        if (!(a instanceof Index)) {
            return false;
        }
        return this.equals((Index)a);
    }

    public boolean equals(Index<K, V> a) {
        if (a == null) {
            return false;
        }
        long n = this.count();
        if (n != a.count()) {
            return false;
        }
        if (this.mask != a.mask) {
            return false;
        }
        if (!Cells.equals(this.entry, a.entry)) {
            return false;
        }
        return this.getHash().equals(a.getHash());
    }

    @Override
    public byte getTag() {
        return -124;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public boolean containsValue(ACell value) {
        if (this.entry != null && Cells.equals(value, (ACell)this.entry.getValue())) {
            return true;
        }
        for (Ref<Index<K, V>> cr : this.children) {
            if (!cr.getValue().containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public static <R extends AIndex<K, V>, K extends ABlobLike<?>, V extends ACell> R create(HashMap<K, V> map) {
        AIndex result = EMPTY;
        for (Map.Entry<K, V> me : map.entrySet()) {
            if ((result = result.assoc((ACell)me.getKey(), (ACell)me.getValue())) != null) continue;
            return null;
        }
        return (R)result;
    }
}

