/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Belief;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.Order;
import convex.core.Receipt;
import convex.core.Result;
import convex.core.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Maps;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.Panic;
import convex.core.lang.AOp;
import convex.core.lang.Core;
import convex.core.lang.Ops;
import convex.core.lang.RT;
import convex.core.lang.impl.Fn;
import convex.core.lang.impl.MultiFn;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.Call;
import convex.core.transactions.Invoke;
import convex.core.transactions.Multi;
import convex.core.transactions.Transfer;
import convex.core.util.Bits;
import convex.core.util.Trees;
import convex.core.util.Utils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Format {
    public static final int LIMIT_ENCODING_LENGTH = 8191;
    public static final int MAX_VLC_LONG_LENGTH = 10;
    public static final int MAX_VLC_COUNT_LENGTH = 9;
    public static final int MAX_EMBEDDED_LENGTH = 140;
    public static final int NULL_ENCODING_LENGTH = 1;
    public static final int MAX_REF_LENGTH = Math.max(33, 140);
    public static final long MAX_MESSAGE_LENGTH = 20000000L;
    public static final long FULL_EMBEDDED_MEMORY_SIZE = 0L;

    public static int getVLCLength(long x) {
        if (x < 64L && x >= -64L) {
            return 1;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        return blen;
    }

    public static int getVLCCountLength(long x) {
        if (x < 0L) {
            throw new IllegalArgumentException("Negative Count");
        }
        if (x < 128L) {
            return 1;
        }
        int bitLength = Utils.bitLength(x) - 1;
        int blen = (bitLength + 6) / 7;
        return blen;
    }

    public static ByteBuffer writeVLCLong(ByteBuffer bb, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            return bb.put(single);
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bb = bb.put(single);
        }
        byte end = (byte)(x & 0x7FL);
        return bb.put(end);
    }

    public static int writeVLCLong(byte[] bs, int pos, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            bs[pos++] = single;
            return pos;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bs[pos++] = single;
        }
        byte end = (byte)(x & 0x7FL);
        bs[pos++] = end;
        return pos;
    }

    public static int writeVLCCount(byte[] bs, int pos, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException("VLC Count cannot be negative but got: " + x);
        }
        if (x < 128L) {
            byte single = (byte)(x & 0x7FL);
            bs[pos++] = single;
            return pos;
        }
        int bitLength = Utils.bitLength(x) - 1;
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bs[pos++] = single;
        }
        byte end = (byte)(x & 0x7FL);
        bs[pos++] = end;
        return pos;
    }

    public static long vlcSignExtend(byte b) {
        return (long)b << 57 >> 57;
    }

    protected static boolean vlcContinuesFrom(byte octet) {
        return (octet & 0x80) != 0;
    }

    public static long readVLCLong(AArrayBlob blob, int pos) throws BadFormatException {
        byte[] data = blob.getInternalArray();
        return Format.readVLCLong(data, pos + blob.getInternalOffset());
    }

    public static long readVLCLong(byte[] data, int pos) throws BadFormatException {
        byte octet = data[pos++];
        long result = Format.vlcSignExtend(octet);
        int bits = 7;
        while (Format.vlcContinuesFrom(octet)) {
            if (pos >= data.length) {
                throw new BadFormatException("VLC encoding beyond end of array");
            }
            if (bits > 64) {
                throw new BadFormatException("VLC encoding too long for long value");
            }
            octet = data[pos++];
            result = result << 7 | (long)(octet & 0x7F);
            bits += 7;
        }
        return result;
    }

    public static long readVLCCount(byte[] data, int pos) throws BadFormatException {
        byte octet;
        if ((octet = data[pos++]) == 128) {
            throw new BadFormatException("Superfluous leading zero on VLC count");
        }
        long result = octet & 0x7F;
        int bits = 7;
        while (Format.vlcContinuesFrom(octet)) {
            if (pos >= data.length) {
                throw new BadFormatException("VLC encoding beyond end of array");
            }
            if (bits > 64) {
                throw new BadFormatException("VLC encoding too long for long value");
            }
            octet = data[pos++];
            result = result << 7 | (long)(octet & 0x7F);
            bits += 7;
        }
        if (result < 0L) {
            throw new BadFormatException("VLC Count netative overflow");
        }
        return result;
    }

    public static long readVLCCount(AArrayBlob blob, int pos) throws BadFormatException {
        byte[] data = blob.getInternalArray();
        return Format.readVLCCount(data, pos + blob.getInternalOffset());
    }

    public static int peekMessageLength(ByteBuffer bb) throws BadFormatException {
        int remaining = bb.limit();
        if (remaining == 0) {
            return -1;
        }
        int len = bb.get(0);
        if (len == 0) {
            throw new BadFormatException("Format.peekMessageLength: Zero message length:" + String.valueOf(Utils.readBufferData(bb)));
        }
        if ((len & 0x40) != 0) {
            String hex = Utils.toHexString((byte)len);
            throw new BadFormatException("Format.peekMessageLength: Expected positive VLC message length, got first byte [" + hex + "]");
        }
        if ((len & 0x80) == 0) {
            return len & 0x3F;
        }
        len &= 0x7F;
        for (int i = 1; i < 10; ++i) {
            if (i >= remaining) {
                return -1;
            }
            byte lsb = bb.get(i);
            len = (len << 7) + (lsb & 0x7F);
            if ((lsb & 0x80) != 0) continue;
            return len;
        }
        throw new BadFormatException("Format.peekMessageLength: Too many bytes in length encoding");
    }

    public static ByteBuffer writeMessageLength(ByteBuffer bb, int len) {
        return Format.writeVLCLong(bb, len);
    }

    public static int write(byte[] bs, int pos, ACell cell) {
        if (cell == null) {
            bs[pos++] = 0;
            return pos;
        }
        Blob enc = cell.cachedEncoding();
        if (enc != null) {
            pos = enc.getBytes(bs, pos);
            return pos;
        }
        return cell.encode(bs, pos);
    }

    public static int writeRawUTF8String(byte[] bs, int pos, String s) {
        if (s.length() == 0) {
            return Format.writeVLCLong(bs, pos, 0L);
        }
        byte[] sBytes = Utils.toByteArray(s);
        int n = sBytes.length;
        pos = Format.writeVLCLong(bs, pos, sBytes.length);
        System.arraycopy(sBytes, 0, bs, pos, n);
        return pos + n;
    }

    public static AString readUTF8String(ByteBuffer bb, int len) throws BadFormatException {
        try {
            if (len == 0) {
                return Strings.empty();
            }
            byte[] bs = new byte[len];
            bb.get(bs);
            AString s = Strings.create(Blob.wrap(bs));
            return s;
        }
        catch (BufferUnderflowException e) {
            throw new BadFormatException("Buffer underflow", e);
        }
    }

    public static AString readUTF8String(Blob blob, int pos, int len) throws BadFormatException {
        if (len == 0) {
            return Strings.empty();
        }
        if (blob.count() < (long)(pos + len)) {
            throw new BadFormatException("Insufficient bytes in blob to read UTF-8 bytes");
        }
        byte[] bs = new byte[len];
        System.arraycopy(blob.getInternalArray(), blob.getInternalOffset() + pos, bs, 0, len);
        AString s = Strings.create(Blob.wrap(bs));
        return s;
    }

    public static ByteBuffer writeLength(ByteBuffer bb, int i) {
        bb = Format.writeVLCLong(bb, i);
        return bb;
    }

    public static <T extends ACell> Ref<T> readRef(Blob b, int pos) throws BadFormatException {
        byte tag = b.byteAt(pos);
        if (tag == 32) {
            return Ref.readRaw(b, pos + 1);
        }
        if (tag == 0) {
            return Ref.nil();
        }
        T cell = Format.read(tag, b, pos);
        if (!Format.isEmbedded(cell)) {
            throw new BadFormatException("Non-embedded Cell found instead of ref: type = " + String.valueOf(RT.getType(cell)));
        }
        return Ref.get(cell);
    }

    private static <T extends ACell> T readDataStructure(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -128) {
            return (T)Vectors.read(b, pos);
        }
        if (tag == -126) {
            return (T)Maps.read(b, pos);
        }
        if (tag == -120) {
            return (T)Syntax.read(b, pos);
        }
        if (tag == -125) {
            return (T)Sets.read(b, pos);
        }
        if (tag == -127) {
            return (T)List.read(b, pos);
        }
        if (tag == -124) {
            return (T)Index.read(b, pos);
        }
        throw new BadFormatException("Can't read data structure with tag byte: " + tag);
    }

    private static ACell readCode(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -51) {
            return Core.read(b, pos);
        }
        if (tag == -53) {
            MultiFn fn = MultiFn.read(b, pos);
            return fn;
        }
        if (tag == -49) {
            Fn fn = Fn.read(b, pos);
            return fn;
        }
        if (tag == -62) {
            return PeerStatus.read(b, pos);
        }
        if (tag == -63) {
            return AccountStatus.read(b, pos);
        }
        throw new BadFormatException("Can't read Op with tag byte: " + Utils.toHexString(tag));
    }

    public static <T extends ACell> T read(Blob blob) throws BadFormatException {
        long n = blob.count();
        if (n < 1L) {
            throw new BadFormatException("Attempt to decode from empty Blob");
        }
        byte tag = blob.byteAt(0L);
        T result = Format.read(tag, blob, 0);
        if (result == null) {
            if (n != 1L) {
                throw new BadFormatException("Decode of nil value but blob size = " + n);
            }
        } else if (((ACell)result).getEncoding().count() != n) {
            throw new BadFormatException("Excess bytes in read from Blob");
        }
        return result;
    }

    public static <T extends ACell> T read(Blob blob, int offset) throws BadFormatException {
        byte tag = blob.byteAt(offset);
        T result = Format.read(tag, blob, offset);
        return result;
    }

    public static <T extends ACell> T read(String hexString) throws BadFormatException {
        return Format.read(Blob.fromHex(hexString));
    }

    private static <T extends ACell> T read(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == 0) {
            return null;
        }
        if (tag == -79) {
            return (T)CVMBool.TRUE;
        }
        if (tag == -80) {
            return (T)CVMBool.FALSE;
        }
        if (tag == 16) {
            return (T)CVMLong.ZERO;
        }
        try {
            int high = tag & 0xF0;
            if (high == 16) {
                return (T)Format.readNumeric(tag, blob, offset);
            }
            if (high == 48) {
                return (T)Format.readBasicObject(tag, blob, offset);
            }
            if (tag == 33) {
                return (T)Address.read(blob, offset);
            }
            if (high == 224) {
                return (T)Format.readOp(tag, blob, offset);
            }
            if (high == 192) {
                return (T)Format.readCode(tag, blob, offset);
            }
            if (high == 128) {
                return Format.readDataStructure(tag, blob, offset);
            }
            if (high == 144) {
                return (T)Format.readSignedData(tag, blob, offset);
            }
            if (high == 208) {
                return Format.readTransaction(tag, blob, offset);
            }
            if (high == 160) {
                return Format.readRecord(tag, blob, offset);
            }
        }
        catch (BadFormatException e) {
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadFormatException("Read out of blob bounds when decoding with tag 0x" + Utils.toHexString(tag));
        }
        catch (Exception e) {
            throw new BadFormatException("Unexpected Exception when decoding: " + e.getMessage(), e);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    private static <T extends ACell> AOp<T> readOp(byte tag, Blob blob, int offset) throws BadFormatException {
        return Ops.read(blob, offset, (byte)(tag & 0xF));
    }

    private static <T extends ACell> SignedData<T> readSignedData(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == -112) {
            return SignedData.read(blob, offset, true);
        }
        if (tag == -111) {
            return SignedData.read(blob, offset, false);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    private static String badTagMessage(byte tag) {
        return "Unrecognised tag byte 0x" + Utils.toHexString(tag);
    }

    private static ANumeric readNumeric(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag < 25) {
            return CVMLong.read(tag, blob, offset);
        }
        if (tag == 25) {
            return CVMBigInteger.read(blob, offset);
        }
        if (tag == 29) {
            return CVMDouble.read(tag, blob, offset);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    private static ACell readBasicObject(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == 50) {
            return Symbol.read(blob, offset);
        }
        if (tag == 51) {
            return Keyword.read(blob, offset);
        }
        if (tag == 49) {
            return Blobs.read(blob, offset);
        }
        if (tag == 48) {
            return Strings.read(blob, offset);
        }
        if ((tag & 0x3C) == 60) {
            int len = CVMChar.byteCountFromTag(tag);
            if (len > 4) {
                throw new BadFormatException("Can't read char type with length: " + len);
            }
            return CVMChar.read(len, blob, offset);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    private static <T extends ACell> T readRecord(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -85) {
            return (T)Block.read(b, pos);
        }
        if (tag == -96) {
            return (T)State.read(b, pos);
        }
        if (tag == -84) {
            return (T)Order.read(b, pos);
        }
        if (tag == -86) {
            return (T)Belief.read(b, pos);
        }
        if (tag == -83) {
            return (T)Result.read(b, pos);
        }
        if (tag == -82) {
            return (T)BlockResult.read(b, pos);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    private static <T extends ACell> T readTransaction(byte tag, Blob b, int pos) throws BadFormatException {
        if ((byte)(tag & 0xFFFFFFFC) == -40) {
            return (T)Receipt.read(tag, b, pos);
        }
        if (tag == -48) {
            return (T)Invoke.read(b, pos);
        }
        if (tag == -47) {
            return (T)Transfer.read(b, pos);
        }
        if (tag == -46) {
            return (T)Call.read(b, pos);
        }
        if (tag == -45) {
            return (T)Multi.read(b, pos);
        }
        throw new BadFormatException(Format.badTagMessage(tag));
    }

    public static boolean isCanonical(ACell o) {
        if (o == null) {
            return true;
        }
        return o.isCanonical();
    }

    public static boolean isEmbedded(ACell cell) {
        if (cell == null) {
            return true;
        }
        return cell.isEmbedded();
    }

    public static Blob encodedBlob(ACell o) {
        if (o == null) {
            return Blob.NULL_ENCODING;
        }
        return o.getEncoding();
    }

    public static int writeHexDigits(byte[] bs, int pos, ABlob src, long start, long length) {
        pos = Format.writeVLCLong(bs, pos, start);
        pos = Format.writeVLCLong(bs, pos, length);
        int nBytes = Utils.checkedInt(length + 1L >> 1);
        byte[] bs2 = new byte[nBytes];
        for (int i = 0; i < nBytes; ++i) {
            long ix = start + (long)(i * 2);
            int d0 = src.getHexDigit(ix);
            int d1 = (long)(i * 2 + 1) < length ? src.getHexDigit(ix + 1L) : 0;
            bs2[i] = (byte)(d0 << 4 | d1 & 0xF);
        }
        System.arraycopy(bs2, 0, bs, pos, nBytes);
        return pos + nBytes;
    }

    public static String encodedString(ACell cell) {
        return Format.encodedBlob(cell).toHexString();
    }

    public static String encodedString(Object o) {
        return Format.encodedString(RT.cvm(o));
    }

    public static int estimateEncodingSize(ACell cell) {
        if (cell == null) {
            return 1;
        }
        return cell.estimatedEncodingSize();
    }

    public static ACell[] decodeCells(Blob data) throws BadFormatException {
        long ml = data.count();
        if (ml > 20000000L) {
            throw new BadFormatException("Message too long: " + ml);
        }
        if (ml == 0L) {
            return Cells.EMPTY_ARRAY;
        }
        ArrayList cells = new ArrayList();
        Object first = Format.read(data, 0);
        cells.add(first);
        int pos = ((ACell)first).getEncodingLength();
        AStore store = Stores.current();
        while ((long)pos < ml) {
            long encLength = Format.readVLCCount(data.getInternalArray(), data.getInternalOffset() + pos);
            Blob enc = data.slice(pos += Format.getVLCCountLength(encLength), (long)pos + encLength);
            Object result = store.decode(enc);
            pos = (int)((long)pos + enc.count);
            cells.add(result);
        }
        return (ACell[])cells.toArray(ACell[]::new);
    }

    public static <T extends ACell> T decodeMultiCell(Blob data) throws BadFormatException {
        long ml = data.count();
        if (ml > 20000000L) {
            throw new BadFormatException("Message too long: " + ml);
        }
        if (ml < 1L) {
            throw new BadFormatException("Attempt to decode from empty Blob");
        }
        Object result = Format.read(data, 0);
        if (result == null) {
            return null;
        }
        int rl = Utils.checkedInt(((ACell)result).getEncodingLength());
        if ((long)rl == ml) {
            return result;
        }
        final HashMap<Hash, ACell> hm = new HashMap<Hash, ACell>();
        Format.decodeCells(hm, data.slice(rl, ml));
        final HashMap done = new HashMap();
        final ArrayList<T> stack = new ArrayList<T>();
        final IRefFunction func = new IRefFunction(){

            @Override
            public Ref<?> apply(Ref<?> r) {
                if (r.isEmbedded()) {
                    Object cc = r.getValue();
                    if (cc == null) {
                        return r;
                    }
                    ACell nc = ((ACell)cc).updateRefs(this);
                    if (cc == nc) {
                        return r;
                    }
                    return nc.getRef();
                }
                Hash h = r.getHash();
                ACell doneVal = (ACell)done.get(h);
                if (doneVal != null) {
                    return doneVal.getRef();
                }
                ACell part = (ACell)hm.get(h);
                if (part != null) {
                    stack.add(part);
                    return part.getRef();
                }
                return r;
            }
        };
        stack.add(result);
        Trees.visitStackMaybePopping(stack, new Predicate<ACell>(){

            @Override
            public boolean test(ACell c) {
                Hash h = c.getHash();
                if (done.containsKey(h)) {
                    return true;
                }
                int pos = stack.size();
                ACell nc = c.updateRefs(func);
                if (stack.size() == pos) {
                    done.put(h, nc);
                    return true;
                }
                stack.set(pos - 1, nc);
                return false;
            }
        });
        result = (ACell)done.get(((ACell)result).getHash());
        return result;
    }

    public static void decodeCells(HashMap<Hash, ACell> acc, Blob data) throws BadFormatException {
        long dataLength = data.count();
        try {
            int ix = 0;
            AStore store = Stores.current();
            while ((long)ix < dataLength) {
                long encLength = Format.readVLCCount(data, ix);
                Blob enc = data.slice(ix += Format.getVLCCountLength(encLength), (long)ix + encLength);
                Hash h = enc.getContentHash();
                Object c = store.decode(enc);
                if (c == null) {
                    throw new BadFormatException("Null child encoding in Message");
                }
                if (((ACell)c).isEmbedded()) {
                    throw new BadFormatException("Embedded Cell provided in Message");
                }
                acc.put(h, (ACell)c);
                ix = (int)((long)ix + encLength);
            }
            if ((long)ix != dataLength) {
                throw new BadFormatException("Bad message length when decoding");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadFormatException("Insufficient bytes to decode Cells");
        }
    }

    public static Blob encodeMultiCell(ACell a, boolean everything) {
        Blob topCellEncoding = Format.encodedBlob(a);
        if (a.getRefCount() == 0) {
            return topCellEncoding;
        }
        ArrayList cells = new ArrayList();
        Consumer<Ref<?>> addToStackFunc = r -> cells.add(r);
        Cells.visitBranchRefs(a, addToStackFunc);
        if (cells.isEmpty()) {
            return topCellEncoding;
        }
        int[] ml = new int[]{topCellEncoding.size()};
        HashSet refs = new HashSet();
        Trees.visitStack(cells, cr -> {
            if (!refs.contains(cr)) {
                Object c = cr.getValue();
                int encLength = ((ACell)c).getEncodingLength();
                int lengthFieldSize = Format.getVLCCountLength(encLength);
                int cellLength = lengthFieldSize + encLength;
                int newLength = ml[0] + cellLength;
                if ((long)newLength > 20000000L) {
                    return;
                }
                ml[0] = newLength;
                refs.add(cr);
                if (everything) {
                    Cells.visitBranchRefs(c, addToStackFunc);
                }
            }
        });
        int messageLength = ml[0];
        byte[] msg = new byte[messageLength];
        topCellEncoding.getBytes(msg, 0);
        int ix = topCellEncoding.size();
        for (Ref r2 : refs) {
            Object c = r2.getValue();
            Blob enc = Format.encodedBlob(c);
            int encLength = enc.size();
            ix = Format.writeVLCCount(msg, ix, encLength);
            ix = enc.getBytes(msg, ix);
        }
        if (ix != messageLength) {
            throw new IllegalArgumentException("Bad message length expected " + ml[0] + " but was: " + ix);
        }
        return Blob.wrap(msg);
    }

    public static Blob encodeCells(java.util.List<ACell> cells) {
        int ml = 0;
        for (ACell a : cells) {
            Blob enc = Format.encodedBlob(a);
            int elen = enc.size();
            if (ml > 0) {
                ml += Format.getVLCCountLength(elen);
            }
            ml += elen;
        }
        byte[] msg = new byte[ml];
        int ix = 0;
        for (ACell a : cells) {
            Blob enc = Format.encodedBlob(a);
            int elen = enc.size();
            if (ix > 0) {
                ix = Format.writeVLCCount(msg, ix, elen);
            }
            ix = enc.getBytes(msg, ix);
        }
        if (ix != ml) {
            throw new Panic("Bad message length expected " + ml + " but was: " + ix);
        }
        return Blob.wrap(msg);
    }

    public static Blob encodeDelta(java.util.List<ACell> cells) {
        int n = cells.size();
        int ml = 0;
        for (int i = 0; i < n; ++i) {
            int clen = cells.get(i).getEncodingLength();
            ml += clen;
            if (i >= n - 1) continue;
            ml += Format.getVLCCountLength(clen);
        }
        byte[] msg = new byte[ml];
        int ix = 0;
        for (int i = n - 1; i >= 0; --i) {
            Blob enc = cells.get(i).getEncoding();
            int elen = enc.size();
            if (i < n - 1) {
                ix = Format.writeVLCCount(msg, ix, elen);
            }
            ix = enc.getBytes(msg, ix);
        }
        if (ix != ml) {
            throw new Panic("Bad message length expected " + ml + " but was: " + ix);
        }
        return Blob.wrap(msg);
    }

    public static int getEncodingLength(ACell value) {
        if (value == null) {
            return 1;
        }
        return value.getEncodingLength();
    }

    public static long readLong(Blob blob, int offset, int length) throws BadFormatException {
        byte[] bs = blob.getInternalArray();
        long v = bs[offset += blob.getInternalOffset()];
        if (v == 0L) {
            if (length == 1) {
                throw new BadFormatException("Long encoding: 0x00 not valid");
            }
            if (bs[offset + 1] >= 0) {
                throw new BadFormatException("Excess 0x00 at start of Long encoding");
            }
        } else if (v == -1L && length > 1 && bs[offset + 1] < 0) {
            throw new BadFormatException("Excess 0xff at start of Long encoding");
        }
        v = v << 56 >> 56;
        for (int i = 1; i < length; ++i) {
            v = (v << 8) + ((long)bs[offset + i] & 0xFFL);
        }
        return v;
    }

    public static int getLongLength(long value) {
        if (value == 0L) {
            return 0;
        }
        if (value > 0L) {
            return 8 - (Bits.leadingZeros(value) - 1) / 8;
        }
        return 8 - (Bits.leadingOnes(value) - 1) / 8;
    }
}

