/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.store.AStore;
import convex.core.store.Stores;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.function.Consumer;

public class Cells {
    public static final ACell[] EMPTY_ARRAY = new ACell[0];

    public static boolean equals(ACell a, ACell b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static ACell[] toCellArray(Object anyArray) {
        int n = Array.getLength(anyArray);
        ACell[] result = new ACell[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (ACell)Array.get(anyArray, i);
        }
        return result;
    }

    public static int refCount(ACell a) {
        if (a == null) {
            return 0;
        }
        return a.getRefCount();
    }

    public static int branchCount(ACell a) {
        if (a == null) {
            return 0;
        }
        int n = a.getRefCount();
        int bc = 0;
        for (int i = 0; i < n; ++i) {
            Ref ref = a.getRef(i);
            if (ref.isEmbedded()) {
                bc += Cells.branchCount(ref.getValue());
                continue;
            }
            ++bc;
        }
        return bc;
    }

    public static <R extends ACell> Ref<R> getRef(ACell cell, int index) {
        if (cell == null) {
            throw new IndexOutOfBoundsException("Bad ref index called on null");
        }
        return cell.getRef(index);
    }

    public static boolean isCVM(ACell a) {
        if (a == null) {
            return true;
        }
        return a.isCVMValue();
    }

    public static boolean isCompletelyEncoded(ACell a) {
        if (a == null) {
            return true;
        }
        return a.isCompletelyEncoded();
    }

    public static boolean isValue(ACell a) {
        if (a == null) {
            return true;
        }
        return a.isDataValue();
    }

    public static <T extends ACell> T persist(T a) throws IOException {
        AStore store = Stores.current();
        return Cells.persist(a, store);
    }

    public static <T extends ACell> T persist(T a, AStore store) throws IOException {
        Ref<T> ref = Ref.get(a);
        Ref<T> sref = store.storeTopRef(ref, 2, null);
        return sref.getValue();
    }

    public static <T extends ACell> T store(T a, AStore store) throws IOException {
        Ref<T> ref = Ref.get(a);
        Ref<T> sref = store.storeTopRef(ref, 1, null);
        return sref.getValue();
    }

    public static <T extends ACell> T announce(T a, Consumer<Ref<ACell>> noveltyHandler) throws IOException {
        if (a == null) {
            return null;
        }
        Ref ref = Stores.current().storeTopRef(a.getRef(), 4, noveltyHandler);
        return (T)ref.getValue();
    }

    public static Hash getHash(ACell a) {
        if (a == null) {
            return Hash.NULL_HASH;
        }
        return a.getHash();
    }

    public static Blob getEncoding(ACell a) {
        if (a == null) {
            return Blob.NULL_ENCODING;
        }
        return a.getEncoding();
    }

    public static long storageSize(ACell a) {
        if (a == null) {
            return 1L;
        }
        long memSize = a.getMemorySize();
        if (a.isEmbedded()) {
            memSize += (long)a.getEncodingLength();
        }
        return memSize;
    }

    public static void visitBranchRefs(ACell a, Consumer<Ref<?>> visitor) {
        if (a == null) {
            return;
        }
        int n = a.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref ref = a.getRef(i);
            if (ref.isEmbedded()) {
                Object child = ref.getValue();
                if (child == null) continue;
                Cells.visitBranchRefs(ref.getValue(), visitor);
                continue;
            }
            visitor.accept(ref);
        }
    }

    public static void visitBranches(ACell a, Consumer<ACell> visitor) {
        if (a == null) {
            return;
        }
        int n = a.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref ref = a.getRef(i);
            if (ref.isEmbedded()) {
                Object child = ref.getValue();
                if (child == null) continue;
                Cells.visitBranches(ref.getValue(), visitor);
                continue;
            }
            visitor.accept((ACell)ref.getValue());
        }
    }

    public static <T extends ACell> T intern(T value) {
        Ref<T> ref = Ref.get(value);
        if (ref.isInternal()) {
            return value;
        }
        ref.setFlags(Ref.mergeFlags(ref.getFlags(), 15));
        return value;
    }
}

