/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Coin;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AHashMap;
import convex.core.data.AIndex;
import convex.core.data.ARecord;
import convex.core.data.ASet;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AFn;
import convex.core.lang.RT;
import convex.core.lang.RecordFormat;
import java.util.Map;

public class AccountStatus
extends ARecord {
    private final long sequence;
    private final long balance;
    private final long memory;
    private final AHashMap<Symbol, ACell> environment;
    private final AHashMap<Symbol, AHashMap<ACell, ACell>> metadata;
    private final Index<Address, ACell> holdings;
    private final ACell controller;
    private final AccountKey publicKey;
    private final Address parent;
    private static final Keyword[] ACCOUNT_KEYS = new Keyword[]{Keywords.SEQUENCE, Keywords.KEY, Keywords.BALANCE, Keywords.ALLOWANCE, Keywords.HOLDINGS, Keywords.CONTROLLER, Keywords.ENVIRONMENT, Keywords.METADATA, Keywords.PARENT};
    private static final Index<Address, ACell> EMPTY_HOLDINGS = Index.none();
    private static final RecordFormat FORMAT = RecordFormat.of(ACCOUNT_KEYS);
    private static final int HAS_SEQUENCE = 1 << (int)FORMAT.indexFor(Keywords.SEQUENCE).longValue();
    private static final int HAS_KEY = 1 << (int)FORMAT.indexFor(Keywords.KEY).longValue();
    private static final int HAS_BALANCE = 1 << (int)FORMAT.indexFor(Keywords.BALANCE).longValue();
    private static final int HAS_ALLOWANCE = 1 << (int)FORMAT.indexFor(Keywords.ALLOWANCE).longValue();
    private static final int HAS_HOLDINGS = 1 << (int)FORMAT.indexFor(Keywords.HOLDINGS).longValue();
    private static final int HAS_CONTROLLER = 1 << (int)FORMAT.indexFor(Keywords.CONTROLLER).longValue();
    private static final int HAS_ENVIRONMENT = 1 << (int)FORMAT.indexFor(Keywords.ENVIRONMENT).longValue();
    private static final int HAS_METADATA = 1 << (int)FORMAT.indexFor(Keywords.METADATA).longValue();
    private static final int HAS_PARENT = 1 << (int)FORMAT.indexFor(Keywords.PARENT).longValue();
    protected static final int INCLUSION_MASK = 255;

    private AccountStatus(long sequence, AccountKey publicKey, long balance, long memory, Index<Address, ACell> holdings, ACell controller, AHashMap<Symbol, ACell> environment, AHashMap<Symbol, AHashMap<ACell, ACell>> metadata, Address parent) {
        super(FORMAT.count());
        this.sequence = sequence;
        this.publicKey = publicKey;
        this.balance = balance;
        this.memory = memory;
        this.holdings = holdings;
        this.controller = controller;
        this.environment = environment;
        this.metadata = metadata;
        this.parent = parent;
    }

    public static AccountStatus create(long sequence, long balance, AccountKey key) {
        return new AccountStatus(sequence, key, balance, 0L, null, null, null, null, null);
    }

    public static AccountStatus createActor() {
        return new AccountStatus(0L, null, 0L, 0L, null, null, null, null, null);
    }

    public static AccountStatus create(long balance, AccountKey key) {
        return AccountStatus.create(0L, balance, key);
    }

    public static AccountStatus create() {
        return AccountStatus.create(0L, 0L, null);
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getBalance() {
        return this.balance;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -63;
        return this.encodeRaw(bs, pos);
    }

    private int getInclusion() {
        int included = 0;
        if (this.sequence != 0L) {
            included |= HAS_SEQUENCE;
        }
        if (this.publicKey != null) {
            included |= HAS_KEY;
        }
        if (this.balance != 0L) {
            included |= HAS_BALANCE;
        }
        if (this.memory != 0L) {
            included |= HAS_ALLOWANCE;
        }
        if (this.holdings != null) {
            included |= HAS_HOLDINGS;
        }
        if (this.controller != null) {
            included |= HAS_CONTROLLER;
        }
        if (this.environment != null) {
            included |= HAS_ENVIRONMENT;
        }
        if (this.metadata != null) {
            included |= HAS_METADATA;
        }
        if (this.parent != null) {
            included |= HAS_PARENT;
        }
        return included;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int included = this.getInclusion();
        pos = Format.writeVLCCount(bs, pos, included);
        if ((included & HAS_SEQUENCE) != 0) {
            pos = Format.writeVLCCount(bs, pos, this.sequence);
        }
        if ((included & HAS_KEY) != 0) {
            pos = this.publicKey.getBytes(bs, pos);
        }
        if ((included & HAS_BALANCE) != 0) {
            pos = Format.writeVLCCount(bs, pos, this.balance);
        }
        if ((included & HAS_ALLOWANCE) != 0) {
            pos = Format.writeVLCCount(bs, pos, this.memory);
        }
        if ((included & HAS_HOLDINGS) != 0) {
            pos = Format.write(bs, pos, this.holdings);
        }
        if ((included & HAS_CONTROLLER) != 0) {
            pos = Format.write(bs, pos, this.controller);
        }
        if ((included & HAS_ENVIRONMENT) != 0) {
            pos = Format.write(bs, pos, this.environment);
        }
        if ((included & HAS_METADATA) != 0) {
            pos = Format.write(bs, pos, this.metadata);
        }
        if ((included & HAS_PARENT) != 0) {
            pos = Format.write(bs, pos, this.parent);
        }
        return pos;
    }

    public static AccountStatus read(Blob b, int pos) throws BadFormatException {
        AccountStatus result;
        int shouldBeIncluded;
        int epos = pos + 1;
        long included = Format.readVLCCount(b, epos);
        epos += Format.getVLCCountLength(included);
        long sequence = 0L;
        if ((included & (long)HAS_SEQUENCE) != 0L) {
            sequence = Format.readVLCCount(b, epos);
            epos += Format.getVLCCountLength(sequence);
        }
        AccountKey publicKey = null;
        if ((included & (long)HAS_KEY) != 0L) {
            publicKey = AccountKey.readRaw(b, epos);
            epos += 32;
        }
        long balance = 0L;
        if ((included & (long)HAS_BALANCE) != 0L) {
            balance = Format.readVLCCount(b, epos);
            epos += Format.getVLCCountLength(balance);
        }
        long allowance = 0L;
        if ((included & (long)HAS_ALLOWANCE) != 0L) {
            allowance = Format.readVLCCount(b, epos);
            epos += Format.getVLCCountLength(allowance);
        }
        Index holdings = null;
        if ((included & (long)HAS_HOLDINGS) != 0L) {
            holdings = (Index)Format.read(b, epos);
            epos += holdings.getEncodingLength();
        }
        Address controller = null;
        if ((included & (long)HAS_CONTROLLER) != 0L) {
            controller = (Address)Format.read(b, epos);
            epos += controller.getEncodingLength();
        }
        AHashMap environment = null;
        if ((included & (long)HAS_ENVIRONMENT) != 0L) {
            environment = (AHashMap)Format.read(b, epos);
            epos += environment.getEncodingLength();
        }
        AHashMap metadata = null;
        if ((included & (long)HAS_METADATA) != 0L) {
            metadata = (AHashMap)Format.read(b, epos);
            epos += metadata.getEncodingLength();
        }
        Address parent = null;
        if ((included & (long)HAS_PARENT) != 0L) {
            parent = (Address)Format.read(b, epos);
            epos += parent.getEncodingLength();
        }
        if (included != (long)(shouldBeIncluded = (result = new AccountStatus(sequence, publicKey, balance, allowance, holdings, controller, environment, metadata, parent)).getInclusion())) {
            throw new BadFormatException("Bad inclusion: " + included + " should be: " + shouldBeIncluded);
        }
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 30 + Format.estimateEncodingSize(this.environment) + Format.estimateEncodingSize(this.holdings) + Format.estimateEncodingSize(this.controller) + 33;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public boolean isActor() {
        return this.publicKey == null;
    }

    public ACell getController() {
        return this.controller;
    }

    public AccountStatus withBalance(long newBalance) {
        if (this.balance == newBalance) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, newBalance, this.memory, this.holdings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountStatus withAccountKey(AccountKey newKey) {
        if (newKey == this.publicKey) {
            return this;
        }
        return new AccountStatus(this.sequence, newKey, this.balance, this.memory, this.holdings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountStatus withMemory(long newMemory) {
        if (this.memory == newMemory) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, newMemory, this.holdings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountStatus withBalances(long newBalance, long newAllowance) {
        if (this.balance == newBalance && this.memory == newAllowance) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, newBalance, newAllowance, this.holdings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountStatus withEnvironment(AHashMap<Symbol, ACell> newEnvironment) {
        if (newEnvironment != null && newEnvironment.isEmpty()) {
            newEnvironment = null;
        }
        if (this.environment == newEnvironment) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, this.holdings, this.controller, newEnvironment, this.metadata, this.parent);
    }

    public AccountStatus withMetadata(AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta) {
        if (newMeta != null && newMeta.isEmpty()) {
            newMeta = null;
        }
        if (this.metadata == newMeta) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, this.holdings, this.controller, this.environment, newMeta, this.parent);
    }

    private AccountStatus withHoldings(Index<Address, ACell> newHoldings) {
        if (newHoldings != null && newHoldings.isEmpty()) {
            newHoldings = null;
        }
        if (this.holdings == newHoldings) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, newHoldings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountStatus withParent(Address newParent) {
        if (this.parent == newParent) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, this.holdings, this.controller, this.environment, this.metadata, newParent);
    }

    @Override
    public boolean equals(ACell o) {
        if (!(o instanceof AccountStatus)) {
            return false;
        }
        AccountStatus as = (AccountStatus)o;
        return this.equals(as);
    }

    public boolean equals(AccountStatus a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.balance != a.balance) {
            return false;
        }
        if (this.sequence != a.sequence) {
            return false;
        }
        if (this.memory != a.memory) {
            return false;
        }
        if (!Cells.equals(this.publicKey, a.publicKey)) {
            return false;
        }
        if (!Cells.equals(this.controller, a.controller)) {
            return false;
        }
        if (!Cells.equals(this.holdings, a.holdings)) {
            return false;
        }
        if (!Cells.equals(this.metadata, a.metadata)) {
            return false;
        }
        if (!Cells.equals(this.environment, a.environment)) {
            return false;
        }
        return Cells.equals(this.parent, a.parent);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.environment != null) {
            if (this.environment.isEmpty()) {
                throw new InvalidDataException("Account should not have empty map as environment", this);
            }
            this.environment.validateCell();
        }
        if (this.holdings != null) {
            if (this.holdings.isEmpty()) {
                throw new InvalidDataException("Account should not have empty map as holdings", this);
            }
            this.holdings.validateCell();
        }
        if (!Coin.isValidAmount(this.balance)) {
            throw new InvalidDataException("Illegal balance: " + this.balance, this);
        }
    }

    public <R extends ACell> R getEnvironmentValue(Symbol symbol) {
        if (this.environment == null) {
            return null;
        }
        Object value = this.environment.get(symbol);
        return (R)value;
    }

    public Index<Address, ACell> getHoldings() {
        Index<Address, ACell> result = this.holdings;
        if (result == null) {
            return EMPTY_HOLDINGS;
        }
        return result;
    }

    public ACell getHolding(Address addr) {
        if (this.holdings == null) {
            return null;
        }
        return this.holdings.get(addr);
    }

    public AccountStatus withHolding(Address addr, ACell value) {
        AIndex hodls = this.getHoldings();
        hodls = value == null ? hodls.dissoc(addr) : (hodls == null ? Index.of((Object)addr, (Object)value) : hodls.assoc(addr, value));
        return this.withHoldings((Index<Address, ACell>)hodls);
    }

    public AccountStatus withController(ACell newController) {
        if (this.controller == newController) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, this.holdings, newController, this.environment, this.metadata, this.parent);
    }

    @Override
    public int getRefCount() {
        int rc = this.environment == null ? 0 : this.environment.getRefCount();
        rc += this.metadata == null ? 0 : this.metadata.getRefCount();
        return rc += this.holdings == null ? 0 : this.holdings.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int hc;
        int mc;
        int ec;
        if (i < 0) {
            throw new IndexOutOfBoundsException(i);
        }
        int n = ec = this.environment == null ? 0 : this.environment.getRefCount();
        if (i < ec) {
            return this.environment.getRef(i);
        }
        int n2 = mc = this.metadata == null ? 0 : this.metadata.getRefCount();
        if ((i -= ec) < mc) {
            return this.metadata.getRef(i);
        }
        int n3 = hc = this.holdings == null ? 0 : this.holdings.getRefCount();
        if ((i -= mc) < hc) {
            return this.holdings.getRef(i);
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.KEY.equals(key)) {
            return this.publicKey;
        }
        if (Keywords.BALANCE.equals(key)) {
            return CVMLong.create(this.balance);
        }
        if (Keywords.ALLOWANCE.equals(key)) {
            return CVMLong.create(this.memory);
        }
        if (Keywords.HOLDINGS.equals(key)) {
            return this.getHoldings();
        }
        if (Keywords.CONTROLLER.equals(key)) {
            return this.controller;
        }
        if (Keywords.ENVIRONMENT.equals(key)) {
            return this.getEnvironment();
        }
        if (Keywords.METADATA.equals(key)) {
            return this.getMetadata();
        }
        if (Keywords.PARENT.equals(key)) {
            return this.parent;
        }
        return null;
    }

    @Override
    public byte getTag() {
        return -63;
    }

    @Override
    public AccountStatus updateRefs(IRefFunction func) {
        AHashMap<Symbol, ACell> newEnv = Ref.updateRefs(this.environment, func);
        AHashMap<Symbol, AHashMap<ACell, ACell>> newMeta = Ref.updateRefs(this.metadata, func);
        Index<Address, ACell> newHoldings = Ref.updateRefs(this.holdings, func);
        if (newEnv == this.environment && newMeta == this.metadata && newHoldings == this.holdings) {
            return this;
        }
        return new AccountStatus(this.sequence, this.publicKey, this.balance, this.memory, newHoldings, this.controller, newEnv, newMeta, this.parent);
    }

    public long getMemory() {
        return this.memory;
    }

    public long getMemoryUsage() {
        return this.getMemorySize();
    }

    public AccountStatus addBalanceAndSequence(long delta) {
        return new AccountStatus(this.sequence + 1L, this.publicKey, this.balance + delta, this.memory, this.holdings, this.controller, this.environment, this.metadata, this.parent);
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public Address getParent() {
        return this.parent;
    }

    public AHashMap<Symbol, AHashMap<ACell, ACell>> getMetadata() {
        if (this.metadata == null) {
            return Maps.empty();
        }
        return this.metadata;
    }

    public AHashMap<Symbol, ACell> getEnvironment() {
        if (this.environment == null) {
            return Maps.empty();
        }
        return this.environment;
    }

    public ASet<Symbol> getCallableFunctions() {
        ACollection results = Sets.empty();
        if (this.metadata == null) {
            return results;
        }
        for (Map.Entry me : this.metadata.entrySet()) {
            Symbol sym;
            Object callVal = ((AHashMap)me.getValue()).get(Keywords.CALLABLE_META);
            if (!RT.bool(callVal) || RT.ensureFunction(this.getEnvironmentValue(sym = (Symbol)me.getKey())) == null) continue;
            results = ((ASet)results).conj(sym);
        }
        return results;
    }

    public <R extends ACell> AFn<R> getCallableFunction(Symbol sym) {
        R exported = this.getEnvironmentValue(sym);
        AFn fn = RT.ensureFunction(exported);
        if (fn == null) {
            return null;
        }
        AHashMap md = (AHashMap)this.getMetadata().get(sym);
        if (RT.bool(md.get(Keywords.CALLABLE_META))) {
            return fn;
        }
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

