/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.data.util.BlobBuilder;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public abstract class ALongBlob
extends ABlob {
    public static final int LENGTH = 8;
    protected static final int HEX_LENGTH = 16;
    protected final long value;

    protected ALongBlob(long value) {
        super(8L);
        this.value = value;
    }

    @Override
    public final long hexLength() {
        return 16L;
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ALongBlob> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 16);
        return newRef;
    }

    @Override
    public boolean appendHex(BlobBuilder bb, long length) {
        long n = Math.min(length, 16L);
        int i = 0;
        while ((long)i < n) {
            bb.append(Utils.toHexChar(this.getHexDigit(i)));
            ++i;
        }
        return n == 16L;
    }

    @Override
    public int getHexDigit(long i) {
        assert (i >= 0L && i < 16L) : "Bad Hex Digit position in LongBlob";
        return 0xF & (int)(this.value >> (int)((16L - i - 1L) * 4L));
    }

    @Override
    public abstract ABlob slice(long var1, long var3);

    @Override
    public abstract Blob toFlatBlob();

    private static void checkIndex(long i) {
        if (i < 0L || i >= 8L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
    }

    @Override
    public final byte byteAt(long i) {
        ALongBlob.checkIndex(i);
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final byte byteAtUnchecked(long i) {
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final ABlob append(ABlob d) {
        return this.toFlatBlob().append(d);
    }

    @Override
    public abstract boolean equals(ABlob var1);

    @Override
    public final int getBytes(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.value);
        return pos;
    }

    @Override
    public final Blob getChunk(long i) {
        if (i == 0L) {
            return this.toFlatBlob();
        }
        throw new IndexOutOfBoundsException(Errors.badIndex(i));
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        return this.toFlatBlob().getByteBuffer();
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        int i = 0;
        while ((long)i < length) {
            int c = b.getHexDigit(start + (long)i);
            if (c != this.getHexDigit(start + (long)i)) {
                return i;
            }
            ++i;
        }
        return length;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(ABlobLike<?> b) {
        if (b.count() == 8L) {
            return this.compareTo(b.longValue());
        }
        return -b.compareTo(this);
    }

    @Override
    protected int compareTo(long bvalue) {
        return Long.compareUnsigned(this.value, bvalue);
    }

    @Override
    public final boolean equalsBytes(ABlob b) {
        if (b.count() != 8L) {
            return false;
        }
        return this.value == b.longValue();
    }

    @Override
    public boolean equalsBytes(byte[] bytes, long byteOffset) {
        return this.value == Utils.readLong(bytes, Utils.checkedInt(byteOffset), 8);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public ABlob toCanonical() {
        return this;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public final boolean isEmbedded() {
        return true;
    }

    @Override
    protected final long calcMemorySize() {
        return 0L;
    }

    @Override
    public boolean isChunkPacked() {
        return false;
    }

    @Override
    public boolean isFullyPacked() {
        return false;
    }

    @Override
    public int read(long offset, long count, ByteBuffer dest) {
        if (offset == 0L && count == 8L) {
            dest.putLong(this.longValue());
            return 8;
        }
        return this.toFlatBlob().read(offset, count, dest);
    }
}

