/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.Blob;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public abstract class ADerivedBlob
extends ABlob {
    protected ADerivedBlob(long count) {
        super(count);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.getCanonical().estimatedEncodingSize();
    }

    @Override
    public final ABlob slice(long start, long end) {
        if (start < 0L) {
            return null;
        }
        if (end > this.count) {
            return null;
        }
        long length = end - start;
        if (length < 0L) {
            return null;
        }
        if (length == 0L) {
            return this.empty();
        }
        if (length == this.count) {
            return this;
        }
        return this.sliceImpl(start, end);
    }

    protected abstract ABlob sliceImpl(long var1, long var3);

    @Override
    public Blob toFlatBlob() {
        if (this.count == 0L) {
            return Blob.EMPTY;
        }
        int n = Utils.checkedInt(this.count);
        byte[] bs = new byte[n];
        this.getBytes(bs, 0);
        return Blob.wrap(bs);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        ABlob can = (ABlob)this.getCanonical();
        can.updateDigest(digest);
    }

    @Override
    public ABlob append(ABlob d) {
        return ((ABlob)this.getCanonical()).append(d);
    }

    @Override
    public boolean equals(ABlob o) {
        return o.equals((ABlob)this.getCanonical());
    }

    @Override
    public ABlob toCanonical() {
        return (ABlob)this.toFlatBlob().getCanonical();
    }

    @Override
    public boolean equalsBytes(byte[] bytes, long offset) {
        ABlob can = (ABlob)this.getCanonical();
        return can.equalsBytes(bytes, offset);
    }

    @Override
    public Blob getChunk(long i) {
        return ((ABlob)this.getCanonical()).getChunk(i);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        ABlob can = (ABlob)this.getCanonical();
        return can.getByteBuffer();
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        ABlob can = (ABlob)this.getCanonical();
        return can.encodeRaw(bs, pos);
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        ABlob can = (ABlob)this.getCanonical();
        return can.equalsBytes(b);
    }

    @Override
    public boolean isFullyPacked() {
        ABlob can = (ABlob)this.getCanonical();
        return can.isFullyPacked();
    }

    @Override
    public int read(long offset, long count, ByteBuffer dest) {
        ABlob can = (ABlob)this.getCanonical();
        return can.read(offset, count, dest);
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        ABlob can = (ABlob)this.getCanonical();
        return can.hexMatch(b, start, length);
    }

    @Override
    public abstract int getBytes(byte[] var1, int var2);

    @Override
    public long longValue() {
        ABlob can = (ABlob)this.getCanonical();
        return can.longValue();
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public int getRefCount() {
        throw new UnsupportedOperationException();
    }
}

