/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AVector;
import convex.core.data.type.AType;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public abstract class ACollection<T extends ACell>
extends ADataStructure<T>
implements Collection<T> {
    protected ACollection(long count) {
        super(count);
    }

    @Override
    public abstract AType getType();

    @Override
    public abstract int encode(byte[] var1, int var2);

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public Iterator<T> iterator() {
        return new BasicIterator(0L);
    }

    @Override
    public final boolean add(T e) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet h = new HashSet(this.size());
        h.addAll(this);
        for (Object o : c) {
            if (h.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException(Errors.immutable(this));
    }

    public abstract AVector<T> toVector();

    protected abstract <R> void copyToArray(R[] var1, int var2);

    public ACell[] toCellArray() {
        int n = Utils.checkedInt(this.count());
        ACell[] cells = new ACell[n];
        int i = 0;
        for (ACell cell : this) {
            cells[i++] = cell;
        }
        return cells;
    }

    @Override
    public <V> V[] toArray(V[] a) {
        int s = this.size();
        if (s > a.length) {
            Class<?> c = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(c, s);
        }
        this.copyToArray(a, 0);
        if (s < a.length) {
            a[s] = null;
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] os = new Object[n];
        for (int i = 0; i < n; ++i) {
            os[i] = this.get(i);
        }
        return os;
    }

    @Override
    public abstract ACollection<T> conj(ACell var1);

    public abstract <R extends ACell> ACollection<R> map(Function<? super T, ? extends R> var1);

    private class BasicIterator
    implements ListIterator<T> {
        long pos;

        public BasicIterator(long index) {
            if (index < 0L) {
                throw new IndexOutOfBoundsException((int)index);
            }
            long c = ACollection.this.count();
            if (index > c) {
                throw new IndexOutOfBoundsException((int)index);
            }
            this.pos = index;
        }

        @Override
        public boolean hasNext() {
            return this.pos < ACollection.this.count();
        }

        @Override
        public T next() {
            return ACollection.this.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0L;
        }

        @Override
        public T previous() {
            if (this.pos > 0L) {
                return ACollection.this.get(--this.pos);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return Utils.checkedInt(this.pos);
        }

        @Override
        public int previousIndex() {
            return Utils.checkedInt(this.pos - 1L);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException(Errors.immutable(this));
        }
    }
}

