/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.Blob;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.util.Utils;

public abstract class ABlobLike<T extends ACell>
extends ACountable<T>
implements Comparable<ABlobLike<?>> {
    public abstract byte byteAt(long var1);

    public byte byteAtUnchecked(long i) {
        return this.byteAt(i);
    }

    public int getHexDigit(long digitPos) {
        byte b = this.byteAtUnchecked(digitPos >> 1);
        int shift = 4 * (1 - ((int)digitPos & 1));
        return b >> shift & 0xF;
    }

    public abstract long hexMatch(ABlobLike<?> var1, long var2, long var4);

    public long hexMatch(ABlobLike<?> b) {
        long limit = Math.min(this.hexLength(), b.hexLength());
        return this.hexMatch(b, 0L, limit);
    }

    public boolean hexEquals(ABlobLike<?> b, long start, long length) {
        return this.hexMatch(b, start, length) == length;
    }

    @Override
    public abstract ABlobLike<T> empty();

    public byte[] getBytes() {
        byte[] result = new byte[Utils.checkedInt(this.count())];
        this.getBytes(result, 0);
        return result;
    }

    @Override
    public Ref<T> getElementRef(long index) {
        return Ref.get(this.get(index));
    }

    public abstract int getBytes(byte[] var1, int var2);

    public long hexLength() {
        return this.count() * 2L;
    }

    public final String toHexString(int hexLength) {
        BlobBuilder bb = new BlobBuilder();
        long hl = (hexLength & 1) == 0 ? (long)hexLength : (long)(hexLength + 1);
        this.appendHex(bb, hl);
        String s = bb.getCVMString().toString();
        if (s.length() > hexLength) {
            s = s.substring(0, hexLength);
        }
        return s;
    }

    public String toHexString() {
        return this.toHexString(Utils.checkedInt(this.hexLength()));
    }

    protected boolean appendHex(BlobBuilder bb, long length) {
        long len = this.hexLength();
        length = Math.min(len, length);
        int i = 0;
        while ((long)i < length) {
            int digit = this.getHexDigit(i);
            char c = Utils.toHexChar(digit);
            bb.append(c);
            ++i;
        }
        return length == len;
    }

    public abstract long longValue();

    public abstract ABlob toBlob();

    public Blob toFlatBlob() {
        return this.toBlob().toFlatBlob();
    }

    public abstract boolean equalsBytes(ABlob var1);

    @Override
    public abstract int compareTo(ABlobLike<?> var1);

    @Override
    public boolean isDataValue() {
        return true;
    }
}

