/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.wallet;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.SignedData;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

public class KeystoreWalletEntry
extends AWalletEntry {
    private final KeyStore ks;
    private AKeyPair keyPair = null;
    private String alias = null;
    private AccountKey key = null;

    public KeystoreWalletEntry(KeyStore ks, String alias, String source) {
        super(source);
        this.ks = ks;
        this.alias = alias;
        this.key = AccountKey.parse(alias);
    }

    public static KeystoreWalletEntry create(KeyStore ks, String alias, String source) {
        return new KeystoreWalletEntry(ks, alias, source);
    }

    @Override
    public AccountKey getPublicKey() {
        return this.key;
    }

    @Override
    public synchronized AKeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public boolean isLocked() {
        return this.keyPair == null;
    }

    public String toString() {
        AccountKey pubKey = this.getPublicKey();
        String ks = "0x" + pubKey.toChecksumHex();
        return "Wallet Entry for: " + ks;
    }

    public <R extends ACell> SignedData<R> sign(R message) {
        return this.keyPair.signData(message);
    }

    @Override
    public AArrayBlob getIdenticonData() {
        return this.key;
    }

    @Override
    public synchronized boolean tryUnlock(char[] password) {
        if (!this.isLocked()) {
            return true;
        }
        try {
            this.keyPair = PFXTools.getKeyPair(this.ks, this.alias, password);
            return this.keyPair != null;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    @Override
    public synchronized void lock(char[] password) {
        this.keyPair = null;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean needsLockPassword() {
        return false;
    }

    @Override
    public void lock() {
        this.keyPair = null;
    }
}

