/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.Arrays;

public class InsecureRandom
extends SecureRandom {
    private static final Provider SECURITY_PROVIDER = new InsecureRandomProvider();

    public InsecureRandom(long seed) {
        super(new InsecureRandomSpi(seed), SECURITY_PROVIDER);
    }

    private static class InsecureRandomSpi
    extends SecureRandomSpi {
        private long seed;

        private InsecureRandomSpi(long seed) {
            this.seed = seed;
        }

        private static long nextLong(long x) {
            x ^= x << 21;
            x ^= x >>> 35;
            x ^= x << 4;
            return x;
        }

        private void initialise(byte[] seedBytes) {
            this.seed = InsecureRandomSpi.nextLong(Arrays.hashCode(seedBytes));
        }

        @Override
        protected void engineSetSeed(byte[] seedBytes) {
            this.initialise(seedBytes);
        }

        @Override
        protected void engineNextBytes(byte[] out) {
            int n = out.length;
            long x = this.seed;
            for (int i = 0; i < n; ++i) {
                out[i] = (byte)(x >> 32);
                x = InsecureRandomSpi.nextLong(x);
            }
            this.seed = x;
        }

        @Override
        protected byte[] engineGenerateSeed(int length) {
            byte[] newSeed = new byte[length];
            this.engineNextBytes(newSeed);
            return newSeed;
        }
    }

    private static class InsecureRandomProvider
    extends Provider {
        private InsecureRandomProvider() {
            super("InsecureRandom", "0.01", "Random number generator with deterministic values");
        }
    }
}

