/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.data.Hash;
import convex.core.exceptions.Panic;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.jcajce.provider.digest.Keccak;

public class Hashing {
    private static final ThreadLocal<MessageDigest> sha256Store = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Panic("SHA-256 algorithm not available", e);
        }
    });
    private static final ThreadLocal<MessageDigest> sha3Store = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA3-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Panic("SHA3-256 algorithm not available", e);
        }
    });
    private static final ThreadLocal<MessageDigest> KECCAK_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return new Keccak.Digest256();
        }
    };

    public static Hash sha3(String message) {
        return Hashing.sha3(message.getBytes(StandardCharsets.UTF_8));
    }

    public static Hash sha3(byte[] data) {
        MessageDigest md = Hashing.getSHA3Digest();
        byte[] hash = md.digest(data);
        return Hash.wrap(hash);
    }

    public static MessageDigest getSHA3Digest() {
        return sha3Store.get();
    }

    public static MessageDigest getDigest() {
        return Hashing.getSHA3Digest();
    }

    public static MessageDigest getKeccak256Digest() {
        Keccak.Digest256 md = new Keccak.Digest256();
        return md;
    }

    public static MessageDigest getSHA256Digest() {
        return sha256Store.get();
    }

    public static Hash sha256(byte[] data) {
        MessageDigest md = Hashing.getSHA256Digest();
        byte[] hash = md.digest(data);
        return Hash.wrap(hash);
    }

    public static Hash keccak256(byte[] data) {
        MessageDigest md = Hashing.getKeccak256Digest();
        byte[] hash = md.digest(data);
        return Hash.wrap(hash);
    }

    public static Hash sha256(String message) {
        return Hashing.sha256(message.getBytes(StandardCharsets.UTF_8));
    }
}

