/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.ASignature;
import convex.core.crypto.Providers;
import convex.core.data.AArrayBlob;
import convex.core.data.AString;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Strings;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Ed25519Signature
extends ASignature {
    public static final int SIGNATURE_LENGTH = 64;
    public static final Ed25519Signature ZERO = Ed25519Signature.wrap(new byte[64]);

    private Ed25519Signature(byte[] signature) {
        super(signature, 0);
    }

    public Ed25519Signature(byte[] data, int pos) {
        super(data, pos);
    }

    public static Ed25519Signature wrap(byte[] signature) {
        if (signature.length != 64) {
            throw new IllegalArgumentException("Bsd signature length for ED25519");
        }
        return new Ed25519Signature(signature);
    }

    public static Ed25519Signature wrap(byte[] data, int pos) {
        return new Ed25519Signature(data, pos);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public Ed25519Signature toCanonical() {
        return this;
    }

    public static Ed25519Signature read(ByteBuffer bb) throws BadFormatException {
        byte count = bb.get();
        if (count != 64) {
            throw new BadFormatException("Expected count byte of signature wrong: " + Utils.toHexString(count));
        }
        return Ed25519Signature.readRaw(bb);
    }

    public static Ed25519Signature readRaw(ByteBuffer bb) throws BadFormatException {
        byte[] sigData = new byte[64];
        bb.get(sigData);
        return Ed25519Signature.wrap(sigData);
    }

    public static ASignature readRaw(Blob b, int pos) {
        byte[] data = b.getInternalArray();
        int off = b.getInternalOffset();
        if ((long)(pos + 64) > b.count()) {
            throw new IndexOutOfBoundsException("wrapping Ed25519Signature beyond blob bounds");
        }
        return Ed25519Signature.wrap(data, off + pos);
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 10L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public boolean verify(AArrayBlob message, AccountKey publicKey) {
        return Providers.verify(this, message, publicKey);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int estimatedEncodingSize() {
        return 65;
    }

    @Override
    public Blob getChunk(long i) {
        return Blob.create(this.store).getChunk(i);
    }
}

