/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.ErrorCodes;
import convex.core.ResultContext;
import convex.core.SourceCodes;
import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.ARecordGeneric;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ResultException;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.RecordFormat;
import convex.core.lang.exception.AExceptional;
import convex.core.lang.exception.ErrorValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public final class Result
extends ARecordGeneric {
    private static final RecordFormat RESULT_FORMAT = RecordFormat.of(Keywords.ID, Keywords.RESULT, Keywords.ERROR, Keywords.LOG, Keywords.INFO);
    private static final long FIELD_COUNT = RESULT_FORMAT.count();
    private static final long ID_POS = RESULT_FORMAT.indexFor(Keywords.ID);
    private static final long RESULT_POS = RESULT_FORMAT.indexFor(Keywords.RESULT);
    private static final long ERROR_POS = RESULT_FORMAT.indexFor(Keywords.ERROR);
    private static final long INFO_POS = RESULT_FORMAT.indexFor(Keywords.INFO);
    private static final long LOG_POS = RESULT_FORMAT.indexFor(Keywords.LOG);
    private static final AVector<AVector<ACell>> EMPTY_LOG = null;
    private static final Result INTERRUPTED_RESULT = Result.error(ErrorCodes.INTERRUPTED, Strings.create("Interrupted!")).withSource(SourceCodes.CLIENT);
    private static final Result MISSING_RESULT = Result.error(ErrorCodes.MISSING, Strings.create("Missing Data!")).withSource(SourceCodes.CLIENT);

    private Result(AVector<ACell> values) {
        super(RESULT_FORMAT, values);
    }

    public static Result buildFromVector(AVector<ACell> values) {
        return new Result(values);
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode, AHashMap<Keyword, ACell> info) {
        return Result.buildFromVector(Vectors.of(id, value, errorCode, EMPTY_LOG, info));
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode, AVector<AVector<ACell>> log, AHashMap<Keyword, ACell> info) {
        return Result.buildFromVector(Vectors.of(id, value, errorCode, log, info));
    }

    public static Result create(CVMLong id, ACell value, ACell errorCode) {
        return Result.create(id, value, errorCode, null);
    }

    public static Result create(CVMLong id, ACell value) {
        return Result.create(id, value, null, null);
    }

    public static Result error(Keyword errorCode, AString message) {
        return Result.error(errorCode, message, null);
    }

    public static Result error(Keyword errorCode, String message) {
        return Result.error(errorCode, Strings.create(message), null);
    }

    private static Result error(Keyword errorCode, AString message, AHashMap<Keyword, ACell> info) {
        return Result.create(CVMLong.ZERO, message, errorCode, info);
    }

    public ACell getID() {
        return this.values.get(ID_POS);
    }

    public <T extends ACell> T getValue() {
        return this.values.get(RESULT_POS);
    }

    public AVector<AString> getTrace() {
        AMap<Keyword, ACell> info = this.getInfo();
        if (info instanceof AMap) {
            AMap<Keyword, ACell> m = info;
            return (AVector)m.get(Keywords.TRACE);
        }
        return null;
    }

    public AMap<Keyword, ACell> getInfo() {
        return (AMap)this.values.get(INFO_POS);
    }

    public Result withInfo(Keyword k, ACell v) {
        ADataStructure newInfo;
        AMap<Keyword, ACell> info = this.getInfo();
        if (info == null) {
            info = Maps.empty();
        }
        if ((newInfo = info.assoc(k, v)) == info) {
            return this;
        }
        return new Result((AVector<ACell>)this.values.assoc(INFO_POS, (ACell)newInfo));
    }

    public Result withSource(Keyword source) {
        return this.withInfo(Keywords.SOURCE, source);
    }

    public AVector<AVector<ACell>> getLog() {
        AVector<AVector<ACell>> log = (AVector<AVector<ACell>>)this.values.get(LOG_POS);
        if (log == null) {
            log = Vectors.empty();
        }
        return log;
    }

    public ACell getErrorCode() {
        return this.values.get(ERROR_POS);
    }

    public Keyword getSource() {
        AMap<Keyword, ACell> info = this.getInfo();
        if (info == null) {
            return null;
        }
        ACell source = info.get(Keywords.SOURCE);
        if (source instanceof Keyword) {
            return (Keyword)source;
        }
        return null;
    }

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    @Override
    protected Result withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Result(newValues);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
        String problem = Result.checkValues(this.values);
        if (problem != null) {
            throw new InvalidDataException(problem, this);
        }
    }

    private static String checkValues(AVector<ACell> values) {
        if (values.count() != FIELD_COUNT) {
            return "Wrong number of fields for Result";
        }
        ACell id = values.get(ID_POS);
        if (id != null && !(id instanceof CVMLong)) {
            return "Result ID must be a CVM long value";
        }
        ACell info = values.get(INFO_POS);
        if (info != null && !(info instanceof AHashMap)) {
            return "Result info must be a hash map";
        }
        ACell log = values.get(LOG_POS);
        if (log != null && !(log instanceof AVector)) {
            return "Result log must be a Vector";
        }
        return null;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -83;
        pos = this.values.encodeRaw(bs, pos);
        return pos;
    }

    public static Result read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<ACell> v = Vectors.read(b, epos);
        epos += Format.getEncodingLength(v);
        String problem = Result.checkValues(v);
        if (problem != null) {
            throw new BadFormatException(problem);
        }
        Blob enc = v.getEncoding();
        Result r = Result.buildFromVector(v);
        v.attachEncoding(null);
        r.attachEncoding(enc);
        return r;
    }

    public boolean isError() {
        return this.getErrorCode() != null;
    }

    public static Result fromContext(CVMLong id, ResultContext rc) {
        Context ctx = rc.context;
        Object result = ctx.getValue();
        ACell errorCode = null;
        AVector<AVector<ACell>> log = ctx.getLog();
        Object info = Maps.empty();
        if (result instanceof AExceptional) {
            AExceptional ex = (AExceptional)result;
            result = ex.getMessage();
            errorCode = ex.getCode();
            if (ex instanceof ErrorValue) {
                ErrorValue ev = (ErrorValue)ex;
                AVector trace = Vectors.create(ev.getTrace());
                Address errorAddress = ev.getAddress();
                info = ((AHashMap)info).assoc(Keywords.TRACE, trace);
                info = ((AHashMap)info).assoc(Keywords.EADDR, errorAddress);
            }
        }
        if (rc.memUsed > 0L) {
            info = ((AHashMap)info).assoc(Keywords.MEM, CVMLong.create(rc.memUsed));
        }
        if (rc.totalFees > 0L) {
            info = ((AHashMap)info).assoc(Keywords.FEES, CVMLong.create(rc.totalFees));
        }
        if (rc.juiceUsed > 0L) {
            info = ((AHashMap)info).assoc(Keywords.JUICE, CVMLong.create(rc.juiceUsed));
        }
        if (rc.source != null) {
            info = ((AHashMap)info).assoc(Keywords.SOURCE, rc.source);
        }
        return Result.create(id, (ACell)result, errorCode, log, info);
    }

    public Result withExtraInfo(Map<Keyword, ACell> extInfo) {
        if (extInfo != null && !extInfo.isEmpty()) {
            ADataStructure info = this.getInfo();
            if (info == null) {
                info = Maps.empty();
            }
            for (Map.Entry<Keyword, ACell> me : extInfo.entrySet()) {
                info = info.assoc(me.getKey(), me.getValue());
            }
            return new Result((AVector<ACell>)this.values.assoc(INFO_POS, (ACell)info));
        }
        return this;
    }

    public static Result fromContext(Context ctx) {
        Object rval = ctx.isExceptional() ? ctx.getExceptional().getMessage() : ctx.getResult();
        return Result.create(null, rval, ctx.getErrorCode(), null);
    }

    public Result withID(ACell id) {
        return this.withValues((AVector)this.values.assoc(ID_POS, id));
    }

    @Override
    public byte getTag() {
        return -83;
    }

    @Override
    public RecordFormat getFormat() {
        return RESULT_FORMAT;
    }

    public static Result fromException(Throwable e) {
        if (e == null) {
            return Result.error(ErrorCodes.EXCEPTION, Strings.NIL);
        }
        if (e instanceof TimeoutException) {
            String msg = e.getMessage();
            return Result.error(ErrorCodes.TIMEOUT, Strings.create(msg));
        }
        if (e instanceof IOException) {
            String msg = e.getMessage();
            return Result.error(ErrorCodes.IO, Strings.create(msg));
        }
        if (e instanceof BadFormatException) {
            String msg = e.getMessage();
            return Result.error(ErrorCodes.FORMAT, Strings.create(msg));
        }
        if (e instanceof MissingDataException) {
            return MISSING_RESULT;
        }
        if (e instanceof ResultException) {
            return ((ResultException)e).getResult();
        }
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return Result.fromException(e.getCause());
        }
        if (e instanceof InterruptedException) {
            return Result.interruptThread();
        }
        return Result.error(ErrorCodes.EXCEPTION, Strings.create(e.getMessage()));
    }

    public static Result interruptThread() {
        Thread.currentThread().interrupt();
        return INTERRUPTED_RESULT;
    }

    public HashMap<String, Object> toJSON() {
        AMap<Keyword, ACell> info;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        if (this.isError()) {
            hm.put("errorCode", RT.name(this.getErrorCode()).toString());
        }
        hm.put("value", RT.json(this.getValue()));
        AVector<AVector<ACell>> log = this.getLog();
        if (log != null) {
            hm.put("info", RT.json(log));
        }
        if ((info = this.getInfo()) != null) {
            hm.put("info", RT.json(info));
        }
        return hm;
    }
}

