/*
 * Decompiled with CFR 0.152.
 */
package etch;

import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.util.Utils;
import etch.Etch;
import etch.IEtchIndexVisitor;
import java.io.IOException;

public class EtchUtils {
    public static FullValidator getFullValidator() {
        return new FullValidator();
    }

    public static class FullValidator
    implements IEtchIndexVisitor {
        public long visited = 0L;
        public long entries = 0L;
        public long empty = 0L;
        public long values = 0L;
        public long indexPtrs = 0L;

        @Override
        public void visit(Etch e, int level, int[] digits, long indexPointer) {
            ++this.visited;
            int isize = e.indexSize(level);
            Object ps = "";
            for (int ll = 0; ll < level; ++ll) {
                int lsize = e.indexSize(ll);
                int hd = Integer.bitCount(lsize - 1) / 4;
                ps = (String)ps + Utils.toHexString(digits[ll]).substring(8 - hd);
            }
            try {
                this.entries += (long)isize;
                if (isize <= 0) {
                    this.fail("Bad index size:" + isize);
                }
                for (int i = 0; i < isize; ++i) {
                    int imm;
                    long prevSlot;
                    long pt;
                    int ipp;
                    long nextSlot;
                    long type;
                    long slot = e.readSlot(indexPointer, i);
                    long ptr = e.rawPointer(slot);
                    if ((ptr | (type = e.extractType(slot))) != slot) {
                        this.fail("Inconsistent slot code?!?");
                    }
                    if (slot == 0L) {
                        ++this.empty;
                    } else if (type != 0x4000000000000000L) {
                        ++this.values;
                        Hash h = e.readValueKey(ptr);
                        String hp = h.toHexString(((String)ps).length());
                        if (!hp.equals(ps)) {
                            this.fail("Index " + (String)ps + " inconsistent with hash " + String.valueOf(h));
                        }
                        this.visitHash(e, h);
                    } else {
                        ++this.indexPtrs;
                    }
                    if (type == Long.MIN_VALUE && e.extractType(nextSlot = e.readSlot(indexPointer, ipp = (i + 1) % isize)) != -4611686018427387904L) {
                        this.fail("Invalid slot after chain start: " + Utils.toHexString(nextSlot));
                    }
                    if (type != -4611686018427387904L || (pt = e.extractType(prevSlot = e.readSlot(indexPointer, imm = (i + isize - 1) % isize))) == -4611686018427387904L || pt == Long.MIN_VALUE) continue;
                    this.fail("Invalid slot before chain entry: " + Utils.toHexString(prevSlot));
                }
            }
            catch (IOException e1) {
                throw (RuntimeException)Utils.sneakyThrow(e1);
            }
        }

        public void visitHash(Etch e, Hash h) {
        }

        public void fail(String msg) {
            throw new Error(msg);
        }
    }

    public static abstract class EtchCellVisitor
    implements IEtchIndexVisitor {
        @Override
        public void visit(Etch e, int level, int[] digits, long indexPointer) {
            int isize = e.indexSize(level);
            try {
                for (int i = 0; i < isize; ++i) {
                    long type;
                    long slot = e.readSlot(indexPointer, i);
                    if (slot == 0L) continue;
                    long ptr = e.rawPointer(slot);
                    if ((ptr | (type = e.extractType(slot))) != slot) {
                        throw new Error("Inconsistent slot code?!?");
                    }
                    if (type == 0x4000000000000000L) continue;
                    Object cell = e.readCell(ptr);
                    this.visitCell((ACell)cell);
                }
            }
            catch (IOException e1) {
                throw (RuntimeException)Utils.sneakyThrow(e1);
            }
        }

        protected abstract void visitCell(ACell var1);
    }
}

