/*
 * Decompiled with CFR 0.152.
 */
package convex.dlfs;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.prim.CVMLong;
import convex.core.util.Utils;
import convex.dlfs.DLFSProvider;
import convex.dlfs.DLPath;
import convex.dlfs.impl.DLDirectoryStream;
import convex.dlfs.impl.DLFSFileAttributes;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.Set;

public abstract class DLFileSystem
extends FileSystem
implements Cloneable {
    static final String SEP = "/";
    private static final Set<String> SUPPORTED_FILE_ATTRIBUTE_SET = Collections.singleton("basic");
    protected final DLFSProvider provider;
    private CVMLong timestamp;
    protected final DLPath root = new DLPath(this, DLPath.EMPTY_STRINGS, true);
    protected final DLPath emptyPath = new DLPath(this);
    protected final String uriPath;

    protected DLFileSystem(DLFSProvider dlfsProvider, String uriPath, CVMLong timestamp) {
        this.provider = dlfsProvider;
        this.uriPath = uriPath;
        this.timestamp = timestamp;
    }

    @Override
    public DLFSProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
    }

    public final CVMLong getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(CVMLong newTimestamp) {
        this.timestamp = newTimestamp;
    }

    public synchronized CVMLong updateTimestamp(long newTimestamp) {
        if (newTimestamp > this.timestamp.longValue()) {
            this.timestamp = CVMLong.create(newTimestamp);
        }
        return this.timestamp;
    }

    public synchronized CVMLong updateTimestamp() {
        return this.updateTimestamp(Utils.getCurrentTimestamp());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return SEP;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singletonList(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_FILE_ATTRIBUTE_SET;
    }

    @Override
    public DLPath getPath(String first, String ... more) {
        Object fullPath = first;
        if (more != null && more.length > 0) {
            fullPath = (String)fullPath + SEP + String.join((CharSequence)SEP, more);
        }
        return DLPath.create(this, (String)fullPath);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return null;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public DLPath getRoot() {
        return this.root;
    }

    public DLPath getEmptyPath() {
        return this.emptyPath;
    }

    public abstract SeekableByteChannel newByteChannel(DLPath var1, Set<? extends OpenOption> var2, FileAttribute<?>[] var3) throws IOException;

    public abstract DLDirectoryStream newDirectoryStream(DLPath var1, DirectoryStream.Filter<? super Path> var2);

    public DLFSFileAttributes getFileAttributes(DLPath path) {
        AVector<ACell> node = this.getNode(path);
        return DLFSFileAttributes.create(node);
    }

    public abstract AVector<ACell> getNode(DLPath var1);

    protected abstract DLPath createDirectory(DLPath var1, FileAttribute<?>[] var2) throws IOException;

    protected abstract void checkAccess(DLPath var1) throws IOException;

    public abstract void delete(DLPath var1) throws IOException;

    public abstract Hash getRootHash();

    public Hash getNodeHash(DLPath p) {
        AVector<ACell> node = this.getNode(p);
        if (node == null) {
            return null;
        }
        return Cells.getHash(node);
    }

    public abstract AVector<ACell> createFile(DLPath var1) throws IOException;

    public abstract AVector<ACell> updateNode(DLPath var1, AVector<ACell> var2);

    public abstract void merge(AVector<ACell> var1);

    public void replicate(DLFileSystem other) {
        this.merge(other.getNode(other.getRoot()));
    }

    public abstract DLFileSystem clone();
}

