/*
 * Decompiled with CFR 0.152.
 */
package convex.dlfs;

import convex.core.util.SoftCache;
import convex.dlfs.DLFS;
import convex.dlfs.DLFileSystem;
import convex.dlfs.DLPath;
import convex.dlfs.impl.DLDirectoryStream;
import convex.dlfs.impl.DLFSLocal;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class DLFSProvider
extends FileSystemProvider {
    SoftCache<String, DLFileSystem> fileSystems = new SoftCache();

    @Override
    public String getScheme() {
        return "dlfs";
    }

    @Override
    public DLFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        String path = uri.getPath();
        DLFSLocal fs = DLFSLocal.create(this);
        this.fileSystems.put(path, fs);
        return fs;
    }

    @Override
    public DLFileSystem getFileSystem(URI uri) {
        String pathPart = uri.getPath();
        if (pathPart == null) {
            throw new IllegalArgumentException("URI contains no path");
        }
        FileSystem fs = this.fileSystems.get(pathPart);
        if (fs == null) {
            fs = this.newFileSystem(uri, (Map)null);
        }
        return fs;
    }

    public Iterable<DLFileSystem> getFileSystems() {
        ArrayList<DLFileSystem> systems = new ArrayList<DLFileSystem>();
        for (Map.Entry<String, DLFileSystem> e : this.fileSystems.entrySet()) {
            DLFileSystem fs = e.getValue();
            if (fs == null) continue;
            systems.add(fs);
        }
        return systems;
    }

    @Override
    public Path getPath(URI uri) {
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FileSystem fs = path.getFileSystem();
        if (!(fs instanceof DLFileSystem)) {
            throw new ProviderMismatchException("Not DLFS");
        }
        return ((DLFileSystem)fs).newByteChannel((DLPath)path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileSystem fs = dir.getFileSystem();
        if (!(fs instanceof DLFileSystem)) {
            throw new ProviderMismatchException("Not DLFS");
        }
        DLDirectoryStream stream = ((DLFileSystem)fs).newDirectoryStream((DLPath)dir, filter);
        if (stream == null) {
            throw new NotDirectoryException("Not a directory: " + String.valueOf(dir));
        }
        return stream;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        FileSystem fs = dir.getFileSystem();
        if (!(fs instanceof DLFileSystem)) {
            throw new ProviderMismatchException("Not DLFS");
        }
        ((DLFileSystem)fs).createDirectory((DLPath)dir, attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        DLPath dlp = DLFS.checkPath(path);
        dlp.getFileSystem().delete(dlp);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.toAbsolutePath().equals(path2.toAbsolutePath());
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        DLPath dlp = DLFS.checkPath(path);
        dlp.getFileSystem().checkAccess(dlp);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            DLPath dlp = DLFS.checkPath(path);
            return (A)dlp.getFileSystem().getFileAttributes(dlp);
        }
        throw new UnsupportedOperationException("No support of attributes type: " + String.valueOf(type));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
    }
}

