/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.Address;
import convex.core.data.Format;
import convex.core.data.type.AType;
import convex.core.data.type.Transaction;
import convex.core.lang.Context;

public abstract class ATransaction
extends ARecord {
    public static final long UNKNOWN_SEQUENCE = 0L;
    protected final Address origin;
    protected final long sequence;

    protected ATransaction(long count, Address origin, long sequence) {
        super(count);
        if (origin == null) {
            throw new ClassCastException("Null Origin Address for transaction");
        }
        this.origin = origin;
        this.sequence = sequence;
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCCount(bs, pos, this.origin.longValue());
        pos = Format.writeVLCCount(bs, pos, this.sequence);
        return pos;
    }

    @Override
    public abstract int estimatedEncodingSize();

    public abstract Context apply(Context var1);

    public Address getOrigin() {
        return this.origin;
    }

    public final long getSequence() {
        return this.sequence;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public AType getType() {
        return Transaction.INSTANCE;
    }

    public abstract ATransaction withSequence(long var1);

    public abstract ATransaction withOrigin(Address var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean equals(ACell o) {
        return ACell.genericEquals(this, o);
    }
}

