/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.util.Errors;

public class Def<T extends ACell>
extends AOp<T> {
    private final ACell symbol;
    private final Ref<AOp<T>> opRef;

    private Def(ACell key, Ref<AOp<T>> op) {
        this.opRef = op;
        this.symbol = key;
        if (this.symbol == null) {
            throw new IllegalArgumentException("Null key in Def!!!");
        }
    }

    public static <T extends ACell> Def<T> create(ACell key, Ref<AOp<T>> op) {
        if (!Def.validKey(key)) {
            throw new IllegalArgumentException("Invalid Def key: " + String.valueOf(key));
        }
        return new Def<T>(key, op);
    }

    public static <T extends ACell> Def<T> create(Syntax key, Ref<AOp<T>> op) {
        if (!Def.validKey(key)) {
            throw new IllegalArgumentException("Invalid Def key: " + String.valueOf(key));
        }
        return new Def<T>(key, op);
    }

    public static <T extends ACell> Def<T> create(Syntax key, AOp<T> op) {
        return Def.create(key, op.getRef());
    }

    public static <T extends ACell> Def<T> create(Symbol key, AOp<T> op) {
        return new Def<T>(key, op.getRef());
    }

    public static <T extends ACell> Def<T> create(ACell key, AOp<T> op) {
        return new Def<T>(key, op.getRef());
    }

    public static <T extends ACell> Def<T> create(ACell key) {
        return new Def<T>(key, Ref.NULL_VALUE);
    }

    public static <T extends ACell> Def<T> create(String key, AOp<T> op) {
        return Def.create(Symbol.create(key), op);
    }

    @Override
    public Context execute(Context ctx) {
        Object value;
        AOp<T> op = this.opRef.getValue();
        if (op != null) {
            if ((ctx = ctx.execute(op)).isExceptional()) {
                return ctx;
            }
            value = ctx.getResult();
        } else {
            value = ctx.getEnvironment().get((ACell)Syntax.unwrap(this.symbol));
        }
        if (this.symbol instanceof Syntax) {
            Syntax syn = (Syntax)this.symbol;
            ctx = ctx.defineWithSyntax(syn, (ACell)value);
        } else {
            ctx = ctx.define((Symbol)this.symbol, (ACell)value);
        }
        return ctx.withResult(100L, (ACell)value);
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    public Ref<AOp<T>> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.opRef;
    }

    @Override
    public Def<T> updateRefs(IRefFunction func) {
        ACell newSymbol = this.symbol.updateRefs(func);
        Ref<AOp<T>> newRef = func.apply(this.opRef);
        if (this.opRef == newRef) {
            return this;
        }
        return new Def<T>(newSymbol, newRef);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(def ");
        this.symbol.print(sb, limit);
        sb.append(' ');
        if (!RT.print(sb, this.opRef.getValue(), limit)) {
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    public byte opCode() {
        return 6;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.symbol);
        pos = this.opRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.symbol.estimatedEncodingSize() + 140;
    }

    public static <T extends ACell> Def<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Object symbol = Format.read(b, epos);
        Ref<AOp<T>> ref = Format.readRef(b, epos += Format.getEncodingLength(symbol));
        if (!Def.validKey(symbol)) {
            throw new BadFormatException("Symbol not valid for Def op");
        }
        epos = (int)((long)epos + ref.getEncodingLength());
        Def<T> result = new Def<T>((ACell)symbol, ref);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!Def.validKey(this.symbol)) {
            throw new InvalidDataException("Def requires a Symbol or Syntax Object for definition but was: " + String.valueOf(RT.getType(this.symbol)), this);
        }
        this.symbol.validateCell();
    }

    private static boolean validKey(ACell key) {
        if (key instanceof Symbol) {
            return true;
        }
        if (!(key instanceof Syntax)) {
            return false;
        }
        return ((Syntax)key).getValue() instanceof Symbol;
    }
}

