/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASet;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.List;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.SetLeaf;
import convex.core.data.Sets;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.VectorLeaf;
import convex.core.data.prim.CVMBool;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.util.Errors;

public class Constant<T extends ACell>
extends AOp<T> {
    public static final Constant<?> NULL = new Constant(Ref.NULL_VALUE);
    public static final Constant<CVMBool> TRUE = new Constant<CVMBool>(Ref.TRUE_VALUE);
    public static final Constant<CVMBool> FALSE = new Constant<CVMBool>(Ref.FALSE_VALUE);
    public static final Constant<StringShort> EMPTY_STRING = new Constant<StringShort>(Strings.EMPTY_REF);
    public static final Constant<AVector<?>> EMPTY_VECTOR = new Constant(VectorLeaf.EMPTY_REF);
    public static final Constant<AList<?>> EMPTY_LIST = new Constant(List.EMPTY_REF);
    public static final Constant<AMap<?, ?>> EMPTY_MAP = new Constant(Maps.EMPTY_REF);
    public static final Constant<ASet<?>> EMPTY_SET = new Constant<SetLeaf>(Sets.EMPTY_REF);
    private final Ref<T> valueRef;

    private Constant(Ref<T> valueRef) {
        this.valueRef = valueRef;
    }

    public static <T extends ACell> Constant<T> create(T value) {
        if (value == null) {
            return NULL;
        }
        return new Constant(value.getRef());
    }

    public static <T extends ACell> Constant<T> of(Object value) {
        return Constant.create(RT.cvm(value));
    }

    public static <T extends ACell> Constant<T> of(T value) {
        return Constant.create(value);
    }

    public static Constant<CVMBool> forBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Constant<AString> createString(String stringValue) {
        return new Constant<AString>(Strings.create(stringValue).getRef());
    }

    public static <T extends ACell> Constant<T> createFromRef(Ref<T> valueRef) {
        if (valueRef == null) {
            throw new IllegalArgumentException("Can't create with null ref");
        }
        return new Constant<T>(valueRef);
    }

    @Override
    public Context execute(Context context) {
        return context.withResult(5L, (ACell)this.valueRef.getValue());
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return RT.print(sb, this.valueRef.getValue(), limit);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 141;
    }

    public static <T extends ACell> Constant<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref ref = Format.readRef(b, epos);
        epos = (int)((long)epos + ref.getEncodingLength());
        Constant result = Constant.createFromRef(ref);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public byte opCode() {
        return 0;
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.valueRef;
    }

    public T getValue() {
        return this.valueRef.getValue();
    }

    @Override
    public Constant<T> updateRefs(IRefFunction func) {
        Ref<?> newRef = func.apply(this.valueRef);
        if (this.valueRef == newRef) {
            return this;
        }
        return Constant.createFromRef(newRef);
    }

    public static <T extends ACell> AOp<T> nil() {
        return NULL;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.valueRef == null) {
            throw new InvalidDataException("Missing contant value ref!", this);
        }
    }
}

