/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.ops.Cond;
import convex.core.lang.ops.Constant;
import convex.core.lang.ops.Def;
import convex.core.lang.ops.Do;
import convex.core.lang.ops.Invoke;
import convex.core.lang.ops.Lambda;
import convex.core.lang.ops.Let;
import convex.core.lang.ops.Local;
import convex.core.lang.ops.Lookup;
import convex.core.lang.ops.Query;
import convex.core.lang.ops.Set;
import convex.core.lang.ops.Special;

public class Ops {
    public static final byte CONSTANT = 0;
    public static final byte INVOKE = 1;
    public static final byte COND = 2;
    public static final byte DO = 3;
    public static final byte LET = 4;
    public static final byte LOOP = 5;
    public static final byte DEF = 6;
    public static final byte LOOKUP = 7;
    public static final byte LAMBDA = 8;
    public static final byte QUERY = 9;
    public static final byte LOCAL = 10;
    public static final byte SET = 11;
    public static final byte SPECIAL = 15;
    public static final int OP_DATA_OFFSET = 1;

    public static <T extends ACell> AOp<T> read(Blob b, int pos, byte opCode) throws BadFormatException {
        switch (opCode) {
            case 0: {
                return Constant.read(b, pos);
            }
            case 1: {
                return Invoke.read(b, pos);
            }
            case 2: {
                return Cond.read(b, pos);
            }
            case 6: {
                return Def.read(b, pos);
            }
            case 3: {
                return Do.read(b, pos);
            }
            case 7: {
                return Lookup.read(b, pos);
            }
            case 8: {
                return Lambda.read(b, pos);
            }
            case 4: {
                return Let.read(b, pos, false);
            }
            case 9: {
                return Query.read(b, pos);
            }
            case 5: {
                return Let.read(b, pos, true);
            }
            case 10: {
                return Local.read(b, pos);
            }
            case 11: {
                return Set.read(b, pos);
            }
            case 15: {
                return Special.read(b, pos);
            }
        }
        throw new BadFormatException("Invalide OpCode: " + opCode);
    }
}

