/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.ErrorCodes;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Cells;
import convex.core.data.Keywords;
import convex.core.data.List;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Sets;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.Types;
import convex.core.lang.AFn;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.Core;
import convex.core.lang.RT;
import convex.core.lang.Symbols;
import convex.core.lang.impl.AClosure;
import convex.core.lang.impl.CoreFn;
import convex.core.lang.impl.MultiFn;
import convex.core.lang.ops.Cond;
import convex.core.lang.ops.Constant;
import convex.core.lang.ops.Def;
import convex.core.lang.ops.Do;
import convex.core.lang.ops.Invoke;
import convex.core.lang.ops.Lambda;
import convex.core.lang.ops.Let;
import convex.core.lang.ops.Local;
import convex.core.lang.ops.Lookup;
import convex.core.lang.ops.Query;
import convex.core.lang.ops.Set;
import convex.core.lang.ops.Special;
import java.util.Map;

public class Compiler {
    public static final CoreFn<ACell> INITIAL_EXPANDER = new CoreFn<ACell>(Symbols.STAR_INITIAL_EXPANDER, 259){

        @Override
        public Context invoke(Context context, ACell[] args) {
            if (args.length != 2) {
                return context.withArityError(this.exactArityMessage(2, args.length));
            }
            ACell x = args[0];
            AFn cont = RT.ensureFunction(args[1]);
            if (cont == null) {
                return context.withCastError(1, args, Types.FUNCTION);
            }
            if (x instanceof Syntax) {
                Syntax sx = (Syntax)x;
                ACell[] nargs = (ACell[])args.clone();
                nargs[0] = (ACell)sx.getValue();
                if ((context = context.invoke(this, nargs)).isExceptional()) {
                    return context;
                }
                Object expanded = context.getResult();
                Syntax result = Syntax.mergeMeta(expanded, sx);
                return context.withResult(40L, result);
            }
            if (x instanceof ADataStructure) {
                ACell form = x;
                if (form instanceof ASequence) {
                    ASequence seq;
                    if (form instanceof AList) {
                        AList listForm = (AList)form;
                        int n = listForm.size();
                        if (n == 0) {
                            return context.withResult(40L, x);
                        }
                        ACell first = (ACell)Syntax.unwrap((ACell)listForm.get(0));
                        AFn<ACell> expander = context.lookupExpander(first);
                        if (expander != null) {
                            return context.expand(expander, x, cont);
                        }
                    }
                    if ((seq = (ASequence)form).isEmpty()) {
                        return context.withResult(40L, x);
                    }
                    long n = seq.count();
                    for (long i = 0L; i < n; ++i) {
                        Object elem = seq.get(i);
                        if ((context = context.expand(cont, (ACell)elem, cont)).isExceptional()) {
                            return context;
                        }
                        Object newElement = context.getResult();
                        if (newElement == elem) continue;
                        seq = seq.assoc(i, newElement);
                    }
                    Context rctx = context;
                    return rctx.withResult(100L, seq);
                }
                if (form instanceof ASet) {
                    Context ctx = context;
                    ACollection updated = Sets.empty();
                    for (ACell elem : (ASet)form) {
                        if ((ctx = ctx.expand(cont, elem, cont)).isExceptional()) {
                            return ctx;
                        }
                        Object newElement = ctx.getResult();
                        updated = ((ASet)updated).conj((ACell)newElement);
                    }
                    return ctx.withResult(100L, updated);
                }
                if (form instanceof AMap) {
                    Context ctx = context;
                    Object updated = Maps.empty();
                    for (Map.Entry me : ((AMap)form).entrySet()) {
                        if ((ctx = ctx.expand(cont, (ACell)me.getKey(), cont)).isExceptional()) {
                            return ctx;
                        }
                        Object newKey = ctx.getResult();
                        if ((ctx = ctx.expand(cont, (ACell)me.getValue(), cont)).isExceptional()) {
                            return ctx;
                        }
                        Object newValue = ctx.getResult();
                        updated = ((AMap)updated).assoc((ACell)newKey, (ACell)newValue);
                    }
                    return ctx.withResult(100L, (ACell)updated);
                }
            }
            return context.withResult(40L, x);
        }
    };

    static Context expandCompile(ACell form, Context context) {
        CoreFn<ACell> ex = INITIAL_EXPANDER;
        Context ctx = context.invoke(ex, form, ex);
        if (ctx.isExceptional()) {
            return ctx;
        }
        Object c = ctx.getResult();
        return ctx.compile((ACell)c);
    }

    static Context compile(ACell form, Context context) {
        if (form == null) {
            return Compiler.compileConstant(context, null);
        }
        if (form instanceof Symbol) {
            return Compiler.compileSymbol((Symbol)form, context);
        }
        if (form instanceof ADataStructure) {
            if (form instanceof AList) {
                return Compiler.compileList((AList)form, context);
            }
            if (form instanceof AVector) {
                return Compiler.compileVector((AVector)form, context);
            }
            if (form instanceof AMap) {
                return Compiler.compileMap((AMap)form, context);
            }
            if (form instanceof ASet) {
                return Compiler.compileSet((ASet)form, context);
            }
            return context.withCompileError("Unexpected data structure: " + String.valueOf(form.getClass()));
        }
        if (form instanceof ABlobLike) {
            ABlobLike bf = (ABlobLike)form;
            if (bf.count() == 0L && bf instanceof AString) {
                return context.withResult(30L, Constant.EMPTY_STRING);
            }
            return Compiler.compileConstant(context, form);
        }
        if (form instanceof Syntax) {
            return Compiler.compileSyntax((Syntax)form, context);
        }
        if (form instanceof CVMBool) {
            return Compiler.compileBoolean(context, (CVMBool)form);
        }
        if (form instanceof AOp) {
            return context.withResult(30L, (AOp)form);
        }
        return Compiler.compileConstant(context, form);
    }

    static Context compileAll(ASequence<ACell> forms, Context context) {
        if (forms == null) {
            return context.withResult(Vectors.empty());
        }
        int n = forms.size();
        ASequence obs = Vectors.empty();
        for (int i = 0; i < n; ++i) {
            Object form = forms.get(i);
            if ((context = context.compile((ACell)form)).isExceptional()) {
                return context;
            }
            obs = obs.conj((AOp)context.getResult());
        }
        return context.withResult(obs);
    }

    private static Context compileSyntax(Syntax s, Context context) {
        context = Compiler.compile((ACell)s.getValue(), context);
        return context;
    }

    private static Context compileSymbol(Symbol sym, Context context) {
        ACell maybeCoreImplicit;
        CVMLong position;
        Context.CompilerState cs = context.getCompilerState();
        if (cs != null && (position = cs.getPosition(sym)) != null) {
            Local op = Local.create(position.longValue());
            return context.withResult(50L, op);
        }
        int ch = sym.getName().charAt(0L);
        if (ch == 42) {
            Special maybeSpecial = Special.forSymbol(sym);
            if (maybeSpecial != null) {
                return context.withResult(maybeSpecial);
            }
        } else if (ch == 35 && (maybeCoreImplicit = Core.CORE_FORMS.get(sym)) != null) {
            return Compiler.compileConstant(context, maybeCoreImplicit);
        }
        Address address = context.getAddress();
        return Compiler.compileEnvSymbol(address, sym, context);
    }

    private static Context compileEnvSymbol(Address address, Symbol sym, Context context) {
        AHashMap<ACell, ACell> meta = context.lookupMeta(sym);
        if (meta != null && meta.get(Keywords.STATIC) == CVMBool.TRUE) {
            ACell value = context.lookupValue(sym);
            return context.withResult(50L, Constant.create(value));
        }
        if ((context = context.lookupDefiningAddress(address, sym)).isExceptional()) {
            return context;
        }
        Address a = (Address)context.getResult();
        if (a != null) {
            return context.withResult(50L, Lookup.create(Constant.of(a), sym));
        }
        Lookup lookUp = Lookup.create(Constant.of(address), sym);
        return context.withResult(50L, lookUp);
    }

    private static Context compileSetBang(AList<ACell> list, Context context) {
        CVMLong position;
        if (list.count() != 3L) {
            return context.withArityError("set! requires two arguments, a symbol and an expression");
        }
        Object a1 = list.get(1);
        if (!(a1 instanceof Symbol)) {
            return context.withError(ErrorCodes.SYNTAX, "set! requires a symbol as first argument");
        }
        Symbol sym = (Symbol)a1;
        if ((context = context.compile((ACell)list.get(2))).isExceptional()) {
            return context;
        }
        AOp exp = (AOp)context.getResult();
        Context.CompilerState cs = context.getCompilerState();
        CVMLong cVMLong = position = cs == null ? null : context.getCompilerState().getPosition(sym);
        if (position == null) {
            if (context.getEnvironment().containsKey(sym)) {
                Def op = Def.create(sym, exp);
                return context.withResult(200L, op);
            }
            return context.withUndeclaredError(sym);
        }
        Set op = Set.create(position.longValue(), exp);
        return context.withResult(200L, op);
    }

    private static Context compileLookup(AList<ACell> list, Context context) {
        Object a1;
        long n = list.count();
        if (n < 2L || n > 3L) {
            return context.withArityError("lookup requires one or two arguments: an optional expression specifying an account and a Symbol");
        }
        AOp exp = null;
        if (n == 3L) {
            if ((context = context.compile((ACell)list.get(1))).isExceptional()) {
                return context;
            }
            exp = (AOp)context.getResult();
        }
        if (!((a1 = list.get(n - 1L)) instanceof Symbol)) {
            return context.withCompileError("lookup requires a Symbol as last argument");
        }
        Symbol sym = (Symbol)a1;
        if (exp instanceof Constant) {
            Address address = RT.ensureAddress(((Constant)exp).getValue());
            if (address == null) {
                return context.withError(ErrorCodes.CAST, "lookup first expression must be an Address");
            }
            AHashMap<ACell, ACell> meta = context.lookupMeta(address, sym);
            if (meta != null && meta.get(Keywords.STATIC) == CVMBool.TRUE) {
                ACell value = context.lookupValue(address, sym);
                return context.withResult(50L, Constant.create(value));
            }
        }
        Lookup op = Lookup.create((AOp<Address>)exp, sym);
        return context.withResult(200L, op);
    }

    private static Context compileMap(AMap<ACell, ACell> form, Context context) {
        int n = form.size();
        if (n == 0) {
            return context.withResult(30L, Constant.EMPTY_MAP);
        }
        ACell[] vs = new ACell[1 + n * 2];
        vs[0] = Symbols.HASH_MAP;
        for (int i = 0; i < n; ++i) {
            MapEntry<ACell, ACell> me = form.entryAt(i);
            vs[1 + i * 2] = me.getKey();
            vs[1 + i * 2 + 1] = me.getValue();
        }
        return Compiler.compileList(List.create(vs), context);
    }

    private static Context compileSet(ASet<ACell> form, Context context) {
        if (form.isEmpty()) {
            return context.withResult(30L, Constant.EMPTY_SET);
        }
        ASequence vs = Vectors.empty();
        for (ACell o : form) {
            vs = ((AVector)vs).conj(o);
        }
        vs = ((AVector)vs).conj(Symbols.HASH_SET);
        return Compiler.compileList(List.reverse(vs), context);
    }

    private static Context compileVector(AVector<ACell> vec, Context context) {
        int n = vec.size();
        if (n == 0) {
            return context.withResult(30L, Constant.EMPTY_VECTOR);
        }
        if ((context = context.compileAll(vec)).isExceptional()) {
            return context;
        }
        AVector obs = (AVector)context.getResult();
        Constant<CoreFn<AVector<ACell>>> fn = Constant.create(Core.VECTOR);
        return context.withResult(200L, Invoke.create(fn, obs));
    }

    private static Context compileConstant(Context context, ACell value) {
        return context.withResult(30L, Constant.create(value));
    }

    private static Context compileBoolean(Context context, CVMBool value) {
        return context.withResult(30L, Constant.forBoolean(value.booleanValue()));
    }

    protected static boolean isListStarting(Symbol element, ACell form) {
        if (!(form instanceof AList)) {
            return false;
        }
        AList list = (AList)form;
        if (list.count() == 0L) {
            return false;
        }
        Object firstElement = list.get(0);
        return Cells.equals(element, (ACell)Syntax.unwrap((ACell)firstElement));
    }

    private static Context compileList(AList<ACell> list, Context context) {
        int n = list.size();
        if (n == 0) {
            return context.withResult(30L, Constant.EMPTY_LIST);
        }
        Object first = list.get(0);
        ACell head = (ACell)Syntax.unwrap((ACell)first);
        if (head instanceof Symbol) {
            Symbol sym = (Symbol)head;
            if (sym.equals(Symbols.DO)) {
                return Compiler.compileDo(list, context);
            }
            if (sym.equals(Symbols.LET)) {
                return Compiler.compileLet(list, context, false);
            }
            if (sym.equals(Symbols.COND)) {
                if ((context = context.compileAll(list.next())).isExceptional()) {
                    return context;
                }
                Cond op = Cond.create((AVector)context.getResult());
                return context.withResult(200L, op);
            }
            if (sym.equals(Symbols.DEF)) {
                return Compiler.compileDef(list, context);
            }
            if (sym.equals(Symbols.FN)) {
                return Compiler.compileFn(list, context);
            }
            if (sym.equals(Symbols.QUOTE)) {
                if (list.size() != 2) {
                    return context.withArityError("quote requires one argument.");
                }
                return Compiler.compileConstant(context, (ACell)list.get(1));
            }
            if (sym.equals(Symbols.QUASIQUOTE)) {
                return context.withCompileError("unexpanded quasiquote in compiler. Remember to expand first!");
            }
            if (sym.equals(Symbols.UNQUOTE)) {
                if (list.size() != 2) {
                    return context.withArityError("unquote requires one argument.");
                }
                if ((context = context.expandCompile((ACell)list.get(1))).isExceptional()) {
                    return context;
                }
                AOp quotedOp = (AOp)context.getResult();
                Context rctx = context.execute(quotedOp);
                if (rctx.isExceptional()) {
                    return rctx;
                }
                Syntax resultForm = Syntax.create(rctx.getResult());
                return Compiler.expandCompile(resultForm, context);
            }
            if (sym.equals(Symbols.QUERY)) {
                if ((context = context.compileAll(list.next())).isExceptional()) {
                    return context;
                }
                Query op = Query.create((AVector)context.getResult());
                return context.withResult(200L, op);
            }
            if (sym.equals(Symbols.LOOP)) {
                return Compiler.compileLet(list, context, true);
            }
            if (sym.equals(Symbols.SET_BANG)) {
                return Compiler.compileSetBang(list, context);
            }
            if (sym.equals(Symbols.LOOKUP)) {
                return Compiler.compileLookup(list, context);
            }
        }
        if ((context = context.compileAll(list)).isExceptional()) {
            return context;
        }
        Invoke op = Invoke.create((AVector)context.getResult());
        return context.withResult(200L, op);
    }

    private static Context compileLet(ASequence<ACell> list, Context context, boolean isLoop) {
        int n = list.size();
        if (n < 2) {
            return context.withSyntaxError(String.valueOf(list.get(0)) + " requires a binding form vector at minimum");
        }
        Object bo = list.get(1);
        if (!(bo instanceof AVector)) {
            return context.withSyntaxError(String.valueOf(list.get(0)) + " requires a vector of binding forms but got: " + String.valueOf(bo));
        }
        AVector bv = (AVector)bo;
        int bn = bv.size();
        if ((bn & 1) != 0) {
            return context.withSyntaxError(String.valueOf(list.get(0)) + " requires a binding vector with an even number of forms but got: " + bn);
        }
        ASequence bindingForms = Vectors.empty();
        ASequence ops = Vectors.empty();
        for (int i = 0; i < bn; i += 2) {
            if ((context = context.expandCompile((ACell)bv.get(i + 1))).isExceptional()) {
                return context;
            }
            AOp op = (AOp)context.getResult();
            ops = ((AVector)ops).conj(op);
            Object bf = bv.get(i);
            context = Compiler.compileBinding((ACell)bf, context);
            if (context.isExceptional()) {
                return context;
            }
            bindingForms = bindingForms.conj((ACell)context.getResult());
        }
        int exs = n - 2;
        for (int i = 2; i < 2 + exs; ++i) {
            if ((context = context.expandCompile((ACell)list.get(i))).isExceptional()) {
                return context;
            }
            AOp op = (AOp)context.getResult();
            ops = ((AVector)ops).conj(op);
        }
        Let op = Let.create(bindingForms, ops, isLoop);
        return context.withResult(200L, op);
    }

    private static Context compileBinding(ACell bindingForm, Context context) {
        Context.CompilerState cs = context.getCompilerState();
        if (cs == null) {
            cs = Context.CompilerState.EMPTY;
        }
        if ((cs = Compiler.updateBinding(bindingForm, cs)) == null) {
            return context.withCompileError("Bad binding form");
        }
        context = context.withCompilerState(cs);
        return context.withResult(bindingForm);
    }

    private static Context.CompilerState updateBinding(ACell bindingForm, Context.CompilerState cs) {
        if ((bindingForm = (ACell)Syntax.unwrap(bindingForm)) instanceof Symbol) {
            Symbol sym = (Symbol)bindingForm;
            if (!sym.equals(Symbols.UNDERSCORE)) {
                cs = cs.define(sym, null);
            }
        } else if (bindingForm instanceof AVector) {
            AVector v = (AVector)bindingForm;
            boolean foundAmpersand = false;
            long vcount = v.count();
            for (long i = 0L; i < vcount; ++i) {
                Object bf = v.get(i);
                if (Symbols.AMPERSAND.equals((ACell)bf)) {
                    if (foundAmpersand) {
                        return null;
                    }
                    if (i >= vcount - 1L) {
                        return null;
                    }
                    foundAmpersand = true;
                    bf = v.get(i + 1L);
                    ++i;
                }
                if ((cs = Compiler.updateBinding(bf, cs)) != null) continue;
                return null;
            }
        } else {
            cs = null;
        }
        return cs;
    }

    private static Context compileFn(AList<ACell> list, Context context) {
        int n = list.size();
        if (n < 2) {
            return context.withArityError("fn requires parameter vector and body in form: " + String.valueOf(list));
        }
        ACell firstObject = (ACell)Syntax.unwrap((ACell)list.get(1));
        if (firstObject instanceof AVector) {
            AVector paramsVector = (AVector)firstObject;
            AList<ACell> bodyList = list.drop(2L);
            return Compiler.compileFnInstance(paramsVector, bodyList, context);
        }
        return Compiler.compileMultiFn(list.drop(1L), context);
    }

    private static Context compileMultiFn(AList<ACell> list, Context context) {
        ASequence fns = Vectors.empty();
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            ACell o = (ACell)Syntax.unwrap((ACell)list.get(i));
            if (!(o instanceof AList)) {
                return context.withSyntaxError("multi-function requires instances of form: ([args] ...) but got " + String.valueOf(list));
            }
            if ((context = Compiler.compileFnInstance((AList)o, context)).isExceptional()) {
                return context;
            }
            AClosure compiledFn = ((Lambda)context.getResult()).getFunction();
            fns = fns.conj(compiledFn);
        }
        MultiFn mf = MultiFn.create(fns);
        Lambda op = Lambda.create(mf);
        return context.withResult(200L, op);
    }

    private static Context compileFnInstance(AList<ACell> list, Context context) {
        int n = list.size();
        if (n < 1) {
            return context.withArityError("fn requires parameter vector and body in form: " + String.valueOf(list));
        }
        ACell firstObject = (ACell)Syntax.unwrap((ACell)list.get(0));
        if (firstObject instanceof AVector) {
            AVector paramsVector = (AVector)firstObject;
            AList<ACell> bodyList = list.drop(1L);
            return Compiler.compileFnInstance(paramsVector, bodyList, context);
        }
        return context.withSyntaxError("fn instance requires a vector of parameters but got form: " + String.valueOf(list));
    }

    private static Context compileFnInstance(AVector<ACell> paramsVector, AList<ACell> bodyList, Context context) {
        Context.CompilerState savedCompilerState = context.getCompilerState();
        if ((context = Compiler.compileBinding(paramsVector, context)).isExceptional()) {
            return context.withCompilerState(savedCompilerState);
        }
        paramsVector = (AVector)context.getResult();
        if ((context = context.compileAll(bodyList)).isExceptional()) {
            return context.withCompilerState(savedCompilerState);
        }
        int n = bodyList.size();
        AOp body = n == 0 ? Constant.nil() : (n == 1 ? (AOp)((ASequence)context.getResult()).get(0) : Do.create((ASequence)context.getResult()));
        Lambda op = Lambda.create(paramsVector, body);
        context = context.withCompilerState(savedCompilerState);
        return context.withResult(200L, op);
    }

    private static Context compileDef(AList<ACell> list, Context context) {
        Def op;
        long n = list.count();
        if (n < 2L) {
            return context.withCompileError("def requires a symbol as second argument");
        }
        if (n > 3L) {
            return context.withCompileError("Too many arguments to def");
        }
        Object symArg = list.get(1);
        Object sym = Syntax.unwrapAll((ACell)symArg);
        if (!(sym instanceof Symbol)) {
            return context.withCompileError("def requires a Symbol as first argument but got: " + String.valueOf(RT.getType(sym)));
        }
        if (n == 3L) {
            Object exp = list.get(2);
            if (exp instanceof Syntax) {
                symArg = Syntax.create((ACell)symArg).mergeMeta(((Syntax)exp).getMeta());
                exp = (ACell)Syntax.unwrap((ACell)exp);
            }
            if ((context = context.compile((ACell)exp)).isExceptional()) {
                return context;
            }
            AOp valOp = (AOp)context.getResult();
            op = Def.create((ACell)symArg, valOp);
        } else {
            op = Def.create((ACell)symArg);
        }
        return context.withResult(200L, op);
    }

    private static Context compileDo(AList<ACell> list, Context context) {
        if ((list = ((AList)list).next()) == null) {
            return context.withResult(200L, Constant.NULL);
        }
        if ((context = context.compileAll(list)).isExceptional()) {
            return context;
        }
        AVector ops = (AVector)context.getResult();
        if (list.count() == 1L) {
            return context.withResult(200L, (ACell)ops.get(0));
        }
        Do op = Do.create(ops);
        return context.withResult(200L, op);
    }
}

