/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Bits;

public final class CVMBool
extends APrimitive {
    private final boolean value;
    public static final CVMBool TRUE = new CVMBool(true);
    public static final CVMBool FALSE = new CVMBool(false);
    public static final int MAX_ENCODING_LENGTH = 1;
    private static final int TRUE_HASHCODE = Bits.hash32(-1342062370L);
    private static final int FALSE_HASHCODE = ~TRUE_HASHCODE;
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";

    private CVMBool(boolean value) {
        this.value = value;
    }

    @Override
    public AType getType() {
        return Types.BOOLEAN;
    }

    public static CVMBool create(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static CVMBool of(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public long longValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.value ? -79 : -80;
        return pos;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return pos;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.value ? Strings.TRUE : Strings.FALSE);
        return bb.check(limit);
    }

    @Override
    public double doubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public byte getTag() {
        return this.value ? (byte)-79 : -80;
    }

    public static ACell parse(String text) {
        if (TRUE_STRING.equals(text)) {
            return TRUE;
        }
        if (FALSE_STRING.equals(text)) {
            return FALSE;
        }
        return null;
    }

    @Override
    public AString toCVMString(long limit) {
        return this.value ? Strings.TRUE : Strings.FALSE;
    }

    @Override
    public int hashCode() {
        return this.value ? TRUE_HASHCODE : FALSE_HASHCODE;
    }

    @Override
    public boolean equals(ACell a) {
        return this == a;
    }

    public Blob toBlob() {
        return this.value ? Blob.ONE : Blob.ZERO;
    }

    public ACell not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public String toString() {
        return this.value ? TRUE_STRING : FALSE_STRING;
    }
}

