/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.impl;

import convex.core.data.ABlob;
import convex.core.data.ADerivedBlob;
import org.bouncycastle.util.Arrays;

public class ZeroBlob
extends ADerivedBlob {
    public static final ZeroBlob EMPTY = new ZeroBlob(0L);

    protected ZeroBlob(long count) {
        super(count);
    }

    @Override
    public ABlob append(ABlob other) {
        if (other instanceof ZeroBlob) {
            return ZeroBlob.create(this.count + ((ZeroBlob)other).count);
        }
        return super.append(other);
    }

    @Override
    public ZeroBlob sliceImpl(long start, long end) {
        return new ZeroBlob(end - start);
    }

    public static ZeroBlob create(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative Count");
        }
        if (count == 0L) {
            return EMPTY;
        }
        return new ZeroBlob(count);
    }

    @Override
    public int getBytes(byte[] dest, int destOffset) {
        int end = destOffset + this.size();
        Arrays.fill((byte[])dest, (int)destOffset, (int)end, (byte)0);
        return end;
    }

    @Override
    public byte byteAtUnchecked(long i) {
        return 0;
    }
}

