/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.StringShort;
import convex.core.data.StringTree;
import convex.core.data.prim.CVMChar;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static final StringShort EMPTY = StringShort.EMPTY;
    public static final Ref<StringShort> EMPTY_REF = EMPTY.getRef();
    public static final StringShort NIL = StringShort.create("nil");
    public static final StringShort TRUE = StringShort.create("true");
    public static final StringShort FALSE = StringShort.create("false");
    public static final StringShort BAD_SIGNATURE = StringShort.create("Bad Signature!");
    public static final StringShort BAD_FORMAT = StringShort.create("Bad Message Format!");
    public static final StringShort SERVER_LOADED = StringShort.create("Trx overload");
    public static final StringShort COLON = StringShort.create(":");
    public static final StringShort HEX_PREFIX = StringShort.create("0x");
    public static final int MAX_ENCODING_LENGTH = Math.max(StringShort.MAX_ENCODING_LENGTH, 645);
    public static final byte EXCESS_BYTE = -1;
    public static final StringShort MISSING_PEER = StringShort.create("Missing Peer!");
    public static final StringShort INSUFFICIENT_STAKE = StringShort.create("Insufficient Stake!");
    public static final StringShort ILLEGAL_BLOCK_SIZE = StringShort.create("Illegal Block Size!");
    public static final StringShort BACKDATED_BLOCK = StringShort.create("Block too old");
    public static final StringShort MISORDERED_BLOCK = StringShort.create("Block out of order");
    public static final StringShort NO_SUCH_ACCOUNT = StringShort.create("Account does not exist");
    public static final StringShort NO_TX_FOR_ACTOR = StringShort.create("Cannot run external transaction for actor account");
    public static final StringShort WRONG_KEY = StringShort.create("Wrong key for account");
    public static final StringShort OLD_SEQUENCE = StringShort.create("Old sequence number");

    public static AString read(Blob blob, int offset) throws BadFormatException {
        long length = Format.readVLCCount(blob, offset + 1);
        if (length < 0L) {
            throw new BadFormatException("Negative string length!");
        }
        if (length > Integer.MAX_VALUE) {
            throw new BadFormatException("String length too long! " + length);
        }
        if (length <= 4096L) {
            return StringShort.read(length, blob, offset);
        }
        return StringTree.read(length, blob, offset);
    }

    public static AString create(String s) {
        int n = s.length();
        if (n == 0) {
            return StringShort.EMPTY;
        }
        ABlob utfBlob = null;
        if (n <= 128) {
            utfBlob = Strings.tryGetASCII(s);
        }
        if (utfBlob == null) {
            ByteBuffer bb;
            CharsetEncoder encoder = Strings.getEncoder();
            try {
                bb = encoder.encode(CharBuffer.wrap(s));
            }
            catch (CharacterCodingException e) {
                throw new Error("Shouldn't happen!", e);
            }
            BlobBuilder builder = new BlobBuilder();
            builder.append(bb);
            utfBlob = builder.toBlob();
        }
        return Strings.create(utfBlob);
    }

    public static AString create(CVMChar c) {
        return Strings.create(c.toUTFBlob());
    }

    private static Blob tryGetASCII(String s) {
        int n = s.length();
        byte[] bs = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                return null;
            }
            bs[i] = (byte)c;
        }
        return Blob.wrap(bs);
    }

    public static AString join(ASequence<AString> ss, AString separator) {
        long n = ss.count();
        if (n == 0L) {
            return StringShort.EMPTY;
        }
        BlobBuilder builder = new BlobBuilder();
        builder.append((AString)ss.get(0));
        for (long i = 1L; i < n; ++i) {
            builder.append(separator);
            builder.append(ss.get(i));
        }
        return Strings.create(builder.toBlob());
    }

    public static AString join(ASequence<AString> ss, CVMChar separator) {
        long n = ss.count();
        if (n == 0L) {
            return StringShort.EMPTY;
        }
        BlobBuilder builder = new BlobBuilder();
        for (long i = 0L; i < n; ++i) {
            AString c;
            if (i != 0L) {
                builder.append(separator);
            }
            if (!((c = ss.get(i)) instanceof AString)) {
                return null;
            }
            builder.append(c);
        }
        return Strings.create(builder.toBlob());
    }

    public static AString create(ABlob b) {
        long n = b.count();
        if (n <= 4096L) {
            return StringShort.create(b.toFlatBlob());
        }
        return StringTree.create(b);
    }

    public static AString fromHex(String hexString) {
        return Strings.create(Blobs.fromHex(hexString));
    }

    public static StringShort empty() {
        return StringShort.EMPTY;
    }

    public static CharsetDecoder getDecoder() {
        Charset charset = StandardCharsets.UTF_8;
        CharsetDecoder dec = charset.newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPLACE);
        dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return dec;
    }

    private static CharsetEncoder getEncoder() {
        Charset charset = StandardCharsets.UTF_8;
        CharsetEncoder enc = charset.newEncoder();
        enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        enc.onMalformedInput(CodingErrorAction.REPLACE);
        return enc;
    }

    public static AString appendAll(AString[] strs) {
        BlobBuilder bb = new BlobBuilder();
        for (AString s : strs) {
            bb.append(s);
        }
        return Strings.create(bb.toBlob());
    }
}

