/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.Providers;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;

public final class SignedData<T extends ACell>
extends ARecord {
    private final AccountKey pubKey;
    private final ASignature signature;
    private final Ref<T> valueRef;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.PUBLIC_KEY, Keywords.SIGNATURE, Keywords.VALUE};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    private AccountKey verifiedKey = null;

    private SignedData(Ref<T> refToValue, AccountKey address, ASignature sig) {
        super(FORMAT.count());
        this.valueRef = refToValue;
        this.pubKey = address;
        this.signature = sig;
    }

    public static <T extends ACell> SignedData<T> signRef(AKeyPair keyPair, Ref<T> ref) {
        Blob message = SignedData.getMessageForRef(ref);
        ASignature sig = keyPair.sign(message);
        SignedData<T> sd = new SignedData<T>(ref, keyPair.getAccountKey(), sig);
        sd.markValidated();
        return sd;
    }

    public static <T extends ACell> Blob getMessageForRef(Ref<T> ref) {
        return ref.getEncoding();
    }

    private void markValidated() {
        Ref ref = this.getRef();
        int flags = ref.getFlags();
        if ((flags & 0x40) != 0) {
            return;
        }
        ref.setFlags(flags | 0x40);
    }

    private void markBadSignature() {
        Ref ref = this.getRef();
        int flags = ref.getFlags();
        if ((flags & 0x80) != 0) {
            return;
        }
        ref.setFlags(flags | 0x80);
    }

    public static <T extends ACell> SignedData<T> sign(AKeyPair keyPair, T value) {
        return SignedData.signRef(keyPair, Ref.get(value));
    }

    public static <T extends ACell> SignedData<T> create(ASignature sig, Ref<T> ref) {
        return SignedData.create(null, sig, ref);
    }

    public static <T extends ACell> SignedData<T> create(AccountKey address, ASignature sig, Ref<T> ref) {
        return new SignedData<T>(ref, address, sig);
    }

    public T getValue() {
        return this.valueRef.getValue();
    }

    public AccountKey getAccountKey() {
        return this.pubKey;
    }

    public ASignature getSignature() {
        return this.signature;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.PUBLIC_KEY.equals(key)) {
            return this.pubKey;
        }
        if (Keywords.SIGNATURE.equals(key)) {
            return this.signature;
        }
        if (Keywords.VALUE.equals(key)) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        int tag = -112;
        bs[pos++] = tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.pubKey.getBytes(bs, pos);
        pos = this.signature.getBytes(bs, pos);
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 237;
    }

    public static <T extends ACell> SignedData<T> read(Blob b, int pos, boolean includeKey) throws BadFormatException {
        AccountKey pubKey;
        int epos = pos + 1;
        if (includeKey) {
            pubKey = AccountKey.readRaw(b, epos);
            epos += 32;
        } else {
            pubKey = null;
        }
        ASignature sig = Ed25519Signature.readRaw(b, epos);
        Ref value = Format.readRef(b, epos += 64);
        epos = (int)((long)epos + value.getEncodingLength());
        SignedData result = SignedData.create(pubKey, sig, value);
        Blob enc = b.slice(pos, epos);
        result.attachEncoding(enc);
        return result;
    }

    public boolean checkSignature() {
        if (this.pubKey == null) {
            return false;
        }
        return this.checkSignatureImpl(this.pubKey);
    }

    public boolean checkSignature(AccountKey publicKey) {
        if (this.pubKey != null && !this.pubKey.equals(publicKey)) {
            return false;
        }
        return this.checkSignatureImpl(publicKey);
    }

    private synchronized boolean checkSignatureImpl(AccountKey publicKey) {
        if (this.verifiedKey != null) {
            return this.verifiedKey.equals(publicKey);
        }
        Ref sigRef = this.getRef();
        int flags = sigRef.getFlags();
        if ((flags & 0x80) != 0) {
            return false;
        }
        if ((flags & 0x40) != 0) {
            return true;
        }
        Blob message = this.getMessage();
        boolean check = Providers.verify(this.signature, message, publicKey);
        if (check) {
            this.markValidated();
            this.verifiedKey = publicKey;
        } else {
            this.markBadSignature();
        }
        return check;
    }

    private Blob getMessage() {
        Blob b = this.getEncoding();
        int offset = 1 + (this.pubKey == null ? 64 : 96);
        return b.slice(offset);
    }

    public boolean isSignatureChecked() {
        Ref sigRef = this.getRef();
        int flags = sigRef.getFlags();
        return (flags & 0xC0) != 0;
    }

    public void validateSignature() throws BadSignatureException {
        if (!this.checkSignature()) {
            throw new BadSignatureException("Signature not valid!", this);
        }
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public final int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException("Illegal SignedData ref index: " + i);
        }
        return this.valueRef;
    }

    @Override
    public SignedData<T> updateRefs(IRefFunction func) {
        Ref<?> newValueRef = func.apply(this.valueRef);
        if (this.valueRef == newValueRef) {
            return this;
        }
        SignedData newSD = new SignedData(newValueRef, this.pubKey, this.signature);
        Ref sdr = newSD.getRef();
        sdr.setFlags(Ref.mergeFlags(sdr.getFlags(), this.getRef().getFlags()));
        newSD.attachEncoding(this.encoding);
        return newSD;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.pubKey != null) {
            this.pubKey.validate();
        }
        this.signature.validate();
        this.valueRef.validate();
    }

    public Ref<T> getValueRef() {
        return this.valueRef;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public byte getTag() {
        return -112;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }

    @Override
    public boolean equals(ACell o) {
        if (!(o instanceof SignedData)) {
            return false;
        }
        SignedData b = (SignedData)o;
        if (!this.signature.equals(b.signature)) {
            return false;
        }
        if (!Cells.equals(this.pubKey, b.pubKey)) {
            return false;
        }
        return this.valueRef.equals(b.valueRef);
    }
}

