/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ACountable;
import convex.core.data.AHashSet;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.SetLeaf;
import convex.core.data.SetTree;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Collection;

public class Sets {
    static final Ref<?>[] EMPTY_ENTRIES = new Ref[0];
    static final SetLeaf EMPTY = new SetLeaf(EMPTY_ENTRIES);
    public static final Ref<SetLeaf> EMPTY_REF;

    public static <T extends ACell> SetLeaf<T> empty() {
        return EMPTY;
    }

    public static <T extends ACell> Ref<SetLeaf<T>> emptyRef() {
        return EMPTY_REF;
    }

    @SafeVarargs
    public static <T extends ACell> ASet<T> of(Object ... elements) {
        int n = elements.length;
        ACollection result = Sets.empty();
        for (int i = 0; i < n; ++i) {
            result = ((ASet)result).conj((ACell)RT.cvm(elements[i]));
        }
        return result;
    }

    @SafeVarargs
    public static <T extends ACell> ASet<T> of(ACell ... elements) {
        int n = elements.length;
        ACollection result = Sets.empty();
        for (int i = 0; i < n; ++i) {
            result = ((ASet)result).conj(elements[i]);
        }
        return result;
    }

    public static <T extends ACell> ASet<T> create(ACountable<T> source) {
        if (source == null) {
            return EMPTY;
        }
        if (source instanceof ASet) {
            return (ASet)source;
        }
        if (source instanceof AMap) {
            ASequence seq = RT.sequence(source);
            return Sets.create(seq);
        }
        if (source instanceof ACountable) {
            return Sets.fromCollection(source);
        }
        throw new IllegalArgumentException("Unexpected type!" + String.valueOf(Utils.getClass(source)));
    }

    public static <T extends ACell> ASet<T> fromCollection(Collection<T> source) {
        return Sets.of(source.toArray());
    }

    private static <T extends ACell> ASet<T> fromCollection(ACountable<T> source) {
        long n = source.count();
        ASet set = EMPTY;
        for (long i = 0L; i < n; ++i) {
            set = ((ASet)set).include(source.get(i));
        }
        return set;
    }

    public static <T extends ACell> ASet<T> read(Blob b, int pos) throws BadFormatException {
        long count = Format.readVLCLong(b, pos + 1);
        if (count <= 16L) {
            return SetLeaf.read(b, pos, count);
        }
        return SetTree.read(b, pos, count);
    }

    public static <T extends ACell> AHashSet<T> createWithShift(int shift, ArrayList<Ref<T>> values) {
        AHashSet result = Sets.empty();
        for (Ref<T> v : values) {
            result = ((AHashSet)result).includeRef(v, shift);
        }
        return result;
    }

    static {
        EMPTY.getRef().setFlags(80);
        EMPTY_REF = EMPTY.getRef();
    }
}

