/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Ref;
import convex.core.data.RefSoft;
import convex.core.store.AStore;
import convex.core.util.Trees;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class Refs {
    public static void visitAllRefs(Ref<?> root, Consumer<Ref<?>> visitor) {
        ArrayList al = new ArrayList();
        al.add(root);
        Consumer<Ref> addingVisitor = r -> {
            visitor.accept((Ref<?>)r);
            Refs.pushChildRefs(al, r);
        };
        Trees.visitStack(al, addingVisitor);
    }

    public static void checkConsistentStores(Ref<?> root, AStore store) {
        Refs.visitAllRefs(root, r -> {
            RefSoft rs;
            AStore rstore;
            if (r instanceof RefSoft && (rstore = (rs = (RefSoft)r).getStore()) != store) {
                String msg = "Inconsistent store! " + String.valueOf(rs) + " expected " + String.valueOf(store) + " but was " + String.valueOf(rstore);
                msg = msg + " in Cell of type: " + String.valueOf(r.getValue().getClass());
                throw new IllegalStateException(msg);
            }
        });
    }

    public static RefTreeStats getRefTreeStats(Ref<?> root) {
        RefTreeStats rts = new RefTreeStats();
        rts.root = root;
        Consumer<Ref<?>> statVisitor = r -> {
            ++rts.total;
            if (r.isEmbedded()) {
                ++rts.embedded;
            }
            if (r.isDirect()) {
                ++rts.direct;
            }
            if (r.getStatus() >= 2) {
                ++rts.persisted;
            }
            if (r.getStatus() >= 1) {
                ++rts.stored;
            }
        };
        Refs.visitAllRefs(root, statVisitor);
        return rts;
    }

    public static Set<Ref<?>> accumulateRefSet(ACell a) {
        return Refs.accumulateRefSet(Ref.get(a));
    }

    public static Set<Ref<?>> accumulateRefSet(Ref<?> root) {
        HashSet hs = new HashSet();
        Refs.accumulateRefSet(root, hs);
        return hs;
    }

    static void accumulateRefSet(Ref<?> root, HashSet<Ref<?>> hs) {
        ArrayList al = new ArrayList();
        al.add(root);
        Consumer<Ref> accVisitor = r -> {
            if (!hs.contains(r)) {
                hs.add((Ref<?>)r);
                Refs.pushChildRefs(al, r);
            }
        };
        Trees.visitStack(al, accVisitor);
    }

    static <T extends ACell> void pushChildRefs(ArrayList<Ref<?>> stack, Ref<T> r) {
        T a = r.getValue();
        if (a == null) {
            return;
        }
        int n = ((ACell)a).getRefCount();
        for (int i = n - 1; i >= 0; --i) {
            stack.add(((ACell)a).getRef(i));
        }
    }

    public static long totalRefCount(ACell a) {
        Ref<ACell> r = Ref.get(a);
        RefTreeStats rts = Refs.getRefTreeStats(r);
        return rts.total;
    }

    public static long uniqueRefCount(ACell a) {
        Set<Ref<?>> rs = Refs.accumulateRefSet(a);
        return rs.size();
    }

    public static void printMissingTree(StringBuilder sb, ACell value) {
        Refs.printTree(sb, Ref.get(value), 0);
    }

    public static String printMissingTree(ACell value) {
        StringBuilder sb = new StringBuilder();
        Refs.printMissingTree(sb, value);
        return sb.toString();
    }

    private static void printTree(StringBuilder sb, Ref<ACell> ref, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append(ref.isEmbedded() ? (char)'-' : '=');
        sb.append(' ');
        if (ref.isMissing()) {
            sb.append("Missing: " + String.valueOf(ref.getHash()) + "\n");
            return;
        }
        ACell v = ref.getValue();
        if (v == null) {
            sb.append("nil\n");
            return;
        }
        sb.append(v.getClass().getSimpleName() + "\n");
        int rc = v.getRefCount();
        for (int i = 0; i < rc; ++i) {
            Refs.printTree(sb, v.getRef(i), indent + 1);
        }
    }

    public static final class RefTreeStats {
        public Ref<?> root = null;
        public long total = 0L;
        public long embedded = 0L;
        public long direct = 0L;
        public long persisted = 0L;
        public long stored = 0L;
    }
}

