/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AIndex;
import convex.core.data.ARecord;
import convex.core.data.AString;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;

public class PeerStatus
extends ARecord {
    private static final Keyword[] PEER_KEYS = new Keyword[]{Keywords.CONTROLLER, Keywords.STAKE, Keywords.STAKES, Keywords.DELEGATED_STAKE, Keywords.METADATA, Keywords.TIMESTAMP, Keywords.BALANCE};
    private static final RecordFormat FORMAT = RecordFormat.of(PEER_KEYS);
    private static final Index<Address, CVMLong> EMPTY_STAKES = Index.none();
    private final Address controller;
    private final long peerStake;
    private final long delegatedStake;
    private final long timestamp;
    private final long balance;
    private final Index<Address, CVMLong> stakes;
    private final AHashMap<ACell, ACell> metadata;

    private PeerStatus(Address controller, long stake, Index<Address, CVMLong> stakes, long delegatedStake, AHashMap<ACell, ACell> metadata, long timestamp, long balance) {
        super(FORMAT.count());
        this.controller = controller;
        this.peerStake = stake;
        this.delegatedStake = delegatedStake;
        this.metadata = metadata;
        this.stakes = stakes;
        this.timestamp = timestamp;
        this.balance = balance;
    }

    public static PeerStatus create(Address controller, long stake) {
        return PeerStatus.create(controller, stake, null);
    }

    public static PeerStatus create(Address controller, long stake, AHashMap<ACell, ACell> metadata) {
        return new PeerStatus(controller, stake, EMPTY_STAKES, 0L, metadata, -1L, stake);
    }

    public long getTotalStake() {
        return this.peerStake + this.delegatedStake;
    }

    public long getBalance() {
        return this.balance;
    }

    public long getDelegatedStake() {
        return this.delegatedStake;
    }

    public long getPeerStake() {
        return this.peerStake;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Address getController() {
        return this.controller;
    }

    public AString getHostname() {
        if (this.metadata == null) {
            return null;
        }
        return RT.ensureString(this.metadata.get(Keywords.URL));
    }

    public AHashMap<ACell, ACell> getMetadata() {
        return this.metadata == null ? Maps.empty() : this.metadata;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -62;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.controller);
        pos = Format.writeVLCLong(bs, pos, this.peerStake);
        if (this.stakes.isEmpty()) {
            bs[pos++] = 0;
        } else {
            pos = Format.write(bs, pos, this.stakes);
        }
        pos = Format.writeVLCLong(bs, pos, this.delegatedStake);
        pos = Format.write(bs, pos, this.metadata);
        pos = Format.writeVLCLong(bs, pos, this.timestamp);
        pos = Format.writeVLCCount(bs, pos, this.balance);
        return pos;
    }

    public static PeerStatus read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Address owner = (Address)Format.read(b, epos);
        long stake = Format.readVLCLong(b, epos += Format.getEncodingLength(owner));
        Index<Address, CVMLong> stakes = (Index<Address, CVMLong>)Format.read(b, epos += Format.getVLCLength(stake));
        epos += Format.getEncodingLength(stakes);
        if (stakes == null) {
            stakes = EMPTY_STAKES;
        } else if (stakes.isEmpty()) {
            throw new BadFormatException("Empty delegated stakes should be encoded as null");
        }
        long delegatedStake = Format.readVLCLong(b, epos);
        AHashMap metadata = (AHashMap)Format.read(b, epos += Format.getVLCLength(delegatedStake));
        long timestamp = Format.readVLCLong(b, epos += Format.getEncodingLength(metadata));
        long balance = Format.readVLCCount(b, epos += Format.getVLCLength(timestamp));
        PeerStatus result = new PeerStatus(owner, stake, stakes, delegatedStake, metadata, timestamp, balance);
        result.attachEncoding(b.slice(pos, epos += Format.getVLCCountLength(balance)));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return this.stakes.estimatedEncodingSize() + 100;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public long getDelegatedStake(Address delegator) {
        CVMLong a = this.stakes.get(delegator);
        if (a == null) {
            return 0L;
        }
        return a.longValue();
    }

    public PeerStatus withDelegatedStake(Address delegator, long newStake) {
        long oldStake = this.getDelegatedStake(delegator);
        if (oldStake == newStake) {
            return this;
        }
        long stakeChange = newStake - oldStake;
        long newDelegatedStake = this.delegatedStake + stakeChange;
        AIndex newStakes = newStake == 0L ? this.stakes.dissoc((ABlobLike)delegator) : this.stakes.assoc(delegator, CVMLong.create(newStake));
        return new PeerStatus(this.controller, this.peerStake, (Index<Address, CVMLong>)newStakes, newDelegatedStake, this.metadata, this.timestamp, this.balance + stakeChange);
    }

    public PeerStatus withPeerStake(long newStake) {
        if (this.peerStake == newStake) {
            return this;
        }
        long stakeChange = newStake - this.peerStake;
        return new PeerStatus(this.controller, newStake, this.stakes, this.delegatedStake, this.metadata, this.timestamp, this.balance + stakeChange);
    }

    public PeerStatus withPeerData(AHashMap<ACell, ACell> newMeta) {
        if (this.metadata == newMeta) {
            return this;
        }
        return new PeerStatus(this.controller, this.peerStake, this.stakes, this.delegatedStake, newMeta, this.timestamp, this.balance);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.stakes == null) {
            throw new InvalidDataException("Null stakes?", this);
        }
        this.stakes.validateCell();
        if (this.metadata != null) {
            this.metadata.validateCell();
        }
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.CONTROLLER.equals(key)) {
            return this.controller;
        }
        if (Keywords.STAKE.equals(key)) {
            return CVMLong.create(this.peerStake);
        }
        if (Keywords.STAKES.equals(key)) {
            return this.stakes;
        }
        if (Keywords.DELEGATED_STAKE.equals(key)) {
            return CVMLong.create(this.delegatedStake);
        }
        if (Keywords.METADATA.equals(key)) {
            return this.metadata;
        }
        if (Keywords.TIMESTAMP.equals(key)) {
            return CVMLong.create(this.timestamp);
        }
        if (Keywords.BALANCE.equals(key)) {
            return CVMLong.create(this.balance);
        }
        return null;
    }

    @Override
    public byte getTag() {
        return -62;
    }

    @Override
    public PeerStatus updateRefs(IRefFunction func) {
        Index<Address, CVMLong> newStakes = Ref.updateRefs(this.stakes, func);
        AHashMap<ACell, ACell> newMeta = Ref.updateRefs(this.metadata, func);
        if (this.stakes == newStakes && this.metadata == newMeta) {
            return this;
        }
        return new PeerStatus(this.controller, this.peerStake, newStakes, this.delegatedStake, newMeta, this.timestamp, this.balance);
    }

    protected static long computeDelegatedStake(Index<Address, CVMLong> stakes) {
        long ds = stakes.reduceValues((? super R acc, ? super V e) -> acc + e.longValue(), 0L);
        return ds;
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof PeerStatus)) {
            return false;
        }
        PeerStatus ps = (PeerStatus)a;
        return this.equals(ps);
    }

    public boolean equals(PeerStatus a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        if (this.peerStake != a.peerStake) {
            return false;
        }
        if (this.delegatedStake != a.delegatedStake) {
            return false;
        }
        if (this.balance != a.balance) {
            return false;
        }
        if (!Cells.equals(this.stakes, a.stakes)) {
            return false;
        }
        if (!Cells.equals(this.metadata, a.metadata)) {
            return false;
        }
        return Cells.equals(this.controller, a.controller);
    }

    @Override
    public int getRefCount() {
        int result = 0;
        result += Cells.refCount(this.stakes);
        return result += Cells.refCount(this.metadata);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int sc = Cells.refCount(this.stakes);
        if (i < sc) {
            return this.stakes.getRef(i);
        }
        if (this.metadata == null) {
            throw new IndexOutOfBoundsException(i);
        }
        return this.metadata.getRef(i - sc);
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

