/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blobs;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class Blob
extends AArrayBlob {
    public static final Blob EMPTY = Blob.wrap(Utils.EMPTY_BYTES);
    public static final Blob ZERO = Blob.wrap(new byte[]{0});
    public static final Blob ONE = Blob.wrap(new byte[]{1});
    public static final Blob NULL_ENCODING = Blob.wrap(new byte[]{0});
    public static final int CHUNK_LENGTH = 4096;
    public static final Blob EMPTY_CHUNK = Blob.wrap(new byte[4096]);
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCCountLength(4096L) + 4096;

    private Blob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    public static Blob create(byte[] data, int offset, int length) {
        if (length <= 0) {
            if (length == 0) {
                return EMPTY;
            }
            throw new IllegalArgumentException(Errors.negativeLength(length));
        }
        byte[] store = Arrays.copyOfRange(data, offset, offset + length);
        return Blob.wrap(store);
    }

    public static Blob create(byte[] data) {
        return Blob.create(data, 0, data.length);
    }

    public static Blob parse(String data) {
        ABlob b = Blobs.parse(data);
        if (b == null) {
            return null;
        }
        return b.toFlatBlob();
    }

    public static Blob wrap(byte[] data) {
        return new Blob(data, 0, data.length);
    }

    public static Blob wrap(byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException(Errors.negativeLength(length));
        }
        if (offset < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException(Errors.badRange(offset, offset + length));
        }
        if (length == 0) {
            return EMPTY;
        }
        return new Blob(data, offset, length);
    }

    @Override
    public Blob toFlatBlob() {
        return this;
    }

    @Override
    public Blob slice(long start, long end) {
        if (start < 0L) {
            return null;
        }
        if (end > this.count) {
            return null;
        }
        long length = end - start;
        int size = (int)length;
        if ((long)size != length) {
            return null;
        }
        if (length < 0L) {
            return null;
        }
        if (length == 0L) {
            return EMPTY;
        }
        if (length == this.count) {
            return this;
        }
        return Blob.wrap(this.store, Utils.checkedInt(start + (long)this.offset), size);
    }

    @Override
    public Blob slice(long start) {
        return this.slice(start, this.count());
    }

    @Override
    public boolean equals(ABlob a) {
        if (a == this) {
            return true;
        }
        if (a instanceof Blob) {
            return this.equals((Blob)a);
        }
        long n = this.count();
        if (a.count() != n) {
            return false;
        }
        if (a.getType() != Types.BLOB) {
            return false;
        }
        if (n <= 4096L) {
            return a.equalsBytes(this.store, this.offset);
        }
        return this.getEncoding().equals(a.getEncoding());
    }

    public boolean equals(Blob b) {
        if (this == b) {
            return true;
        }
        if (this.count != b.count) {
            return false;
        }
        return Utils.arrayEquals(this.store, this.offset, b.store, b.offset, this.size());
    }

    public boolean equals(AArrayBlob other) {
        if (other == this) {
            return true;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.contentHash != null && other.contentHash != null && this.contentHash.equals(other.contentHash)) {
            return true;
        }
        return Utils.arrayEquals(other.store, other.offset, this.store, this.offset, this.size());
    }

    public static Blob fromHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString);
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return EMPTY;
        }
        return Blob.wrap(bs);
    }

    public static Blob forByte(byte b) {
        return Blob.wrap(new byte[]{b});
    }

    public static Blob fromByteBuffer(ByteBuffer bb) {
        int count = bb.remaining();
        byte[] bs = new byte[count];
        bb.get(bs);
        return Blob.wrap(bs);
    }

    public static Blob read(Blob source, int pos, long count) throws BadFormatException {
        if (count == 0L) {
            return EMPTY;
        }
        if (count > 4096L) {
            throw new BadFormatException("Trying to read flat blob with count = " + count);
        }
        int headerLength = 1 + Format.getVLCCountLength(count);
        long start = pos + headerLength;
        if (start + count > source.count()) {
            throw new BadFormatException("Insufficient bytes to read Blob required count =" + count);
        }
        Blob result = source.slice(start, start + count);
        if (result == null) {
            throw new IllegalArgumentException("Failed to slice Blob source");
        }
        if (source.byteAtUnchecked(pos) == 49) {
            result.attachEncoding(source.slice(pos, (long)pos + ((long)headerLength + count)));
        }
        return result;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        if (this.count > 4096L) {
            return ((ACell)this.getCanonical()).encodeRaw(bs, pos);
        }
        pos = super.encodeRaw(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 11 + this.size();
    }

    @Override
    public boolean isCanonical() {
        return this.count <= 4096L;
    }

    public static Blob createRandom(Random random, long length) {
        byte[] randBytes = new byte[Utils.checkedInt(length)];
        random.nextBytes(randBytes);
        return Blob.wrap(randBytes);
    }

    @Override
    public Blob getChunk(long i) {
        if (i == 0L && this.count <= 4096L) {
            return this;
        }
        long start = i * 4096L;
        long take = Math.min(4096L, this.count - start);
        return this.slice(start, start + take);
    }

    public void attachContentHash(Hash hash) {
        if (this.contentHash == null) {
            this.contentHash = hash;
        }
    }

    @Override
    public ABlob toCanonical() {
        if (this.isCanonical()) {
            return this;
        }
        return Blobs.toCanonical(this);
    }
}

