/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.data.StringShort;
import convex.core.data.prim.CVMChar;
import convex.core.exceptions.InvalidDataException;

public abstract class ASymbolic
extends ABlobLike<CVMChar> {
    protected final StringShort name;

    protected ASymbolic(StringShort name) {
        this.name = name;
        this.memorySize = 0L;
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ASymbolic> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 80);
        return newRef;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public final boolean isDataValue() {
        return true;
    }

    @Override
    protected long calcMemorySize() {
        return 0L;
    }

    @Override
    public final int estimatedEncodingSize() {
        return (int)(2L + this.name.count());
    }

    public final StringShort getName() {
        return this.name;
    }

    protected static boolean validateName(AString name) {
        if (name == null) {
            return false;
        }
        long n = name.count();
        return n >= 1L && n <= 128L;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public abstract void validateCell() throws InvalidDataException;

    @Override
    public byte byteAt(long i) {
        return this.toBlob().byteAt(i);
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        return this.toBlob().hexMatch(b, start, length);
    }

    @Override
    public ABlobLike<CVMChar> empty() {
        return null;
    }

    @Override
    public int getBytes(byte[] dest, int destOffset) {
        return this.toBlob().getBytes(dest, destOffset);
    }

    @Override
    public long longValue() {
        return this.toBlob().longValue();
    }

    @Override
    public ABlob toBlob() {
        return this.name.toBlob();
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        return this.name.equalsBytes(b);
    }

    @Override
    public long count() {
        return this.name.count();
    }

    @Override
    public Ref<CVMChar> getElementRef(long index) {
        return Ref.get(this.get(index));
    }

    @Override
    public CVMChar get(long index) {
        return this.name.get(index);
    }

    @Override
    public abstract ABlobLike<CVMChar> slice(long var1, long var3);

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public int getRefCount() {
        return 0;
    }
}

