/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AIndex<K extends ABlobLike<?>, V extends ACell>
extends AMap<K, V> {
    protected AIndex(long count) {
        super(count);
    }

    @Override
    public final V get(ACell key) {
        if (!(key instanceof ABlobLike)) {
            return null;
        }
        return this.get((K)((ABlobLike)key));
    }

    @Override
    public boolean containsKey(ACell key) {
        if (!(key instanceof ABlobLike)) {
            return false;
        }
        return this.getEntry((K)((ABlobLike)key)) != null;
    }

    @Override
    public abstract V get(K var1);

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<MapEntry<K, V>> hs = new HashSet<MapEntry<K, V>>(this.size());
        long n = this.count();
        for (long i = 0L; i < n; ++i) {
            MapEntry<K, V> me = this.entryAt(i);
            hs.add(me);
        }
        return Collections.unmodifiableSet(hs);
    }

    @Override
    public abstract int getRefCount();

    @Override
    public abstract <R extends ACell> Ref<R> getRef(int var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public AType getType() {
        return Types.INDEX;
    }

    @Override
    public abstract AIndex<K, V> assoc(ACell var1, ACell var2);

    @Override
    public final AIndex<K, V> dissoc(ACell key) {
        if (key instanceof ABlobLike) {
            return this.dissoc((K)((ABlobLike)key));
        }
        return this;
    }

    public abstract AIndex<K, V> dissoc(K var1);

    @Override
    public MapEntry<K, V> getKeyRefEntry(Ref<ACell> ref) {
        return this.getEntry((K)ref.getValue());
    }

    @Override
    public abstract MapEntry<K, V> entryAt(long var1);

    @Override
    public MapEntry<K, V> getEntry(ACell key) {
        if (key instanceof ABlobLike) {
            return this.getEntry((K)((ABlobLike)key));
        }
        return null;
    }

    public abstract MapEntry<K, V> getEntry(K var1);

    @Override
    public abstract int estimatedEncodingSize();
}

