/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ASet;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.prim.CVMBool;
import convex.core.exceptions.InvalidDataException;

public abstract class AHashSet<T extends ACell>
extends ASet<T> {
    protected static final int OP_UNION = 1;
    protected static final int OP_INTERSECTION = 2;
    protected static final int OP_DIFF_LEFT = 3;
    protected static final int OP_DIFF_RIGHT = 4;
    protected static final int MAX_SHIFT = 63;

    protected AHashSet(long count) {
        super(count);
    }

    protected abstract AHashSet<T> mergeWith(AHashSet<T> var1, int var2);

    protected abstract AHashSet<T> mergeWith(AHashSet<T> var1, int var2, int var3);

    @Override
    public AHashSet<T> includeAll(ASet<? extends T> elements) {
        return this.mergeWith((AHashSet)elements, 1);
    }

    protected final int reverseOp(int setOp) {
        if (setOp >= 3) {
            setOp = 7 - setOp;
        }
        return setOp;
    }

    protected final Ref<T> applyOp(int setOp, Ref<T> a, Ref<T> b) {
        switch (setOp) {
            case 1: {
                return a == null ? b : a;
            }
            case 2: {
                return a == null ? null : (b == null ? null : a);
            }
            case 3: {
                return a == null ? null : (b == null ? a : null);
            }
            case 4: {
                return b == null ? null : (a == null ? b : null);
            }
        }
        throw new Error("Invalid setOp: " + setOp);
    }

    protected final AHashSet<T> applySelf(int setOp) {
        switch (setOp) {
            case 1: {
                return this;
            }
            case 2: {
                return this;
            }
            case 3: {
                return Sets.empty();
            }
            case 4: {
                return Sets.empty();
            }
        }
        throw new Error("Invalid setOp: " + setOp);
    }

    @Override
    public ASet<T> intersectAll(ASet<T> elements) {
        return this.mergeWith((AHashSet)elements, 2);
    }

    @Override
    public ASet<T> excludeAll(ASet<T> elements) {
        return this.mergeWith((AHashSet)elements, 3);
    }

    @Override
    public abstract AHashSet<T> toCanonical();

    @Override
    public AHashSet<T> conjAll(ACollection<? extends T> elements) {
        if (elements instanceof AHashSet) {
            return this.includeAll((ASet)((AHashSet)elements));
        }
        ASet result = this;
        long n = elements.count();
        for (long i = 0L; i < n; ++i) {
            result = result.conj((ACell)elements.get(i));
        }
        return result;
    }

    @Override
    public ASet<T> disjAll(ACollection<T> b) {
        if (b instanceof AHashSet) {
            return this.excludeAll((AHashSet)b);
        }
        AHashSet<T> result = this;
        long n = b.count();
        for (long i = 0L; i < n; ++i) {
            result = result.excludeRef(b.getElementRef(i));
        }
        return result;
    }

    public abstract AHashSet<T> excludeRef(Ref<?> var1);

    @Override
    public abstract AHashSet<T> includeRef(Ref<T> var1);

    @Override
    public AHashSet<T> conj(ACell a) {
        return this.includeRef((Ref)Ref.get(a));
    }

    @Override
    public ASet<T> exclude(ACell a) {
        return this.excludeRef(Ref.get(a));
    }

    @Override
    public AHashSet<T> include(T a) {
        return this.includeRef((Ref)Ref.get(a));
    }

    protected abstract void validateWithPrefix(Hash var1, int var2, int var3) throws InvalidDataException;

    @Override
    public Object[] toArray() {
        int s = this.size();
        Object[] result = new Object[s];
        this.copyToArray(result, 0);
        return result;
    }

    @Override
    public final CVMBool get(ACell key) {
        Ref me = this.getValueRef(key);
        if (me == null) {
            return CVMBool.FALSE;
        }
        return CVMBool.TRUE;
    }

    public T getByHash(Hash hash) {
        Ref ref = this.getRefByHash(hash);
        if (ref == null) {
            return null;
        }
        return ref.getValue();
    }

    protected abstract AHashSet<T> includeRef(Ref<T> var1, int var2);

    public abstract boolean containsHash(Hash var1);

    @Override
    public boolean contains(ACell key) {
        return this.getValueRef(key) != null;
    }
}

