/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AHashMap<K extends ACell, V extends ACell>
extends AMap<K, V> {
    protected AHashMap(long count) {
        super(count);
    }

    @Override
    public AHashMap<K, V> empty() {
        return Maps.empty();
    }

    public abstract AHashMap<K, V> dissocRef(Ref<K> var1);

    public abstract AHashMap<K, V> assocRef(Ref<K> var1, V var2);

    @Override
    public abstract AHashMap<K, V> assoc(ACell var1, ACell var2);

    @Override
    public abstract AHashMap<K, V> dissoc(ACell var1);

    protected abstract AHashMap<K, V> assocRef(Ref<K> var1, V var2, int var3);

    @Override
    public abstract AHashMap<K, V> assocEntry(MapEntry<K, V> var1);

    protected abstract AHashMap<K, V> assocEntry(MapEntry<K, V> var1, int var2);

    @Override
    public AHashMap<K, V> merge(AHashMap<K, V> m) {
        AMap result = this;
        long n = m.count();
        int i = 0;
        while ((long)i < n) {
            result = result.assocEntry(m.entryAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public AHashMap<K, V> merge(AMap<K, V> m) {
        if (m instanceof AHashMap) {
            return this.merge((AHashMap)m);
        }
        return (AHashMap)super.merge(m);
    }

    public abstract AHashMap<K, V> mergeDifferences(AHashMap<K, V> var1, MergeFunction<V> var2);

    protected abstract AHashMap<K, V> mergeDifferences(AHashMap<K, V> var1, MergeFunction<V> var2, int var3);

    public abstract AHashMap<K, V> mergeWith(AHashMap<K, V> var1, MergeFunction<V> var2);

    protected abstract AHashMap<K, V> mergeWith(AHashMap<K, V> var1, MergeFunction<V> var2, int var3);

    @Override
    public AHashMap<K, V> filterValues(Predicate<V> pred) {
        return this.mergeWith(this, (a, b) -> pred.test(a) ? a : null);
    }

    public abstract AHashMap<K, V> mapEntries(Function<MapEntry<K, V>, MapEntry<K, V>> var1);

    protected abstract void validateWithPrefix(String var1) throws InvalidDataException;

    @Override
    public abstract AHashMap<K, V> updateRefs(IRefFunction var1);

    public abstract boolean containsAllKeys(AHashMap<K, V> var1);

    @Override
    public final boolean containsKey(ACell key) {
        if (this.count == 0L) {
            return false;
        }
        return this.getEntry(key) != null;
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    @Override
    public AVector<K> getKeys() {
        int n = Utils.checkedInt(this.count);
        ACell[] keys = new ACell[n];
        for (int i = 0; i < n; ++i) {
            keys[i] = this.entryAt(i).getKey();
        }
        return Vectors.wrap(keys);
    }

    @Override
    public HashSet<Map.Entry<K, V>> entrySet() {
        int len = this.size();
        HashSet h = new HashSet(len);
        this.accumulateEntrySet(h);
        return h;
    }

    @Override
    public AHashMap<K, V> slice(long start) {
        return this.slice(start, this.count);
    }

    @Override
    public abstract AHashMap<K, V> slice(long var1, long var3);
}

